/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.conczin.mca.MCA;
import net.conczin.mca.client.gui.ExtendedScreen;
import net.conczin.mca.client.gui.FamilyTreeScreen;
import net.conczin.mca.client.gui.widget.LegacyImageButton;
import net.conczin.mca.client.gui.widget.TooltipButtonWidget;
import net.conczin.mca.client.gui.widget.WidgetUtils;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.c2s.GetVillageRequest;
import net.conczin.mca.network.c2s.RenameVillageMessage;
import net.conczin.mca.network.c2s.ReportBuildingMessage;
import net.conczin.mca.network.c2s.SaveVillageMessage;
import net.conczin.mca.resources.BuildingTypes;
import net.conczin.mca.resources.Rank;
import net.conczin.mca.resources.data.BuildingType;
import net.conczin.mca.resources.data.tasks.Task;
import net.conczin.mca.server.world.data.Building;
import net.conczin.mca.server.world.data.Village;
import net.conczin.mca.util.compat.ButtonWidget;
import net.conczin.mca.util.localization.FlowingText;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class BlueprintScreen
extends ExtendedScreen {
    private static final int POSITION_TAXES = -60;
    private static final int POSITION_BIRTH = -10;
    private static final int POSITION_MARRIAGE = 40;
    private static final ResourceLocation ICON_TEXTURES = MCA.locate("textures/buildings.png");
    private final List<Button> catalogButtons = new LinkedList<Button>();
    private Village village;
    private int reputation;
    private boolean isVillage;
    private Rank rank;
    private Set<String> completedTasks;
    private String page;
    private ButtonWidget[] buttonTaxes;
    private ButtonWidget[] buttonBirths;
    private ButtonWidget[] buttonMarriage;
    private ButtonWidget buttonPage;
    private int pageNumber = 0;
    private BuildingType selectedBuilding;
    private UUID selectedVillager;
    private int mouseX;
    private int mouseY;
    private Map<Rank, List<Task>> tasks;

    public BlueprintScreen() {
        super((Component)Component.literal((String)"Blueprint"));
    }

    private void saveVillage() {
        Network.sendToServer(new SaveVillageMessage(this.village));
    }

    private void changeTaxes(float d) {
        this.village.setTaxes(Math.max(0.0f, Math.min(1.0f, this.village.getTaxes() + d)));
        this.saveVillage();
    }

    private void changePopulationThreshold(float d) {
        this.village.setPopulationThreshold(Math.max(0.0f, Math.min(1.0f, this.village.getPopulationThreshold() + d)));
        this.saveVillage();
    }

    private void changeMarriageThreshold(float d) {
        this.village.setMarriageThreshold(Math.max(0.0f, Math.min(1.0f, this.village.getMarriageThreshold() + d)));
        this.saveVillage();
    }

    private ButtonWidget[] createValueChanger(int x, int y, int w, int h, Consumer<Boolean> onPress, Component tooltip) {
        ButtonWidget[] buttons = new ButtonWidget[3];
        buttons[1] = (ButtonWidget)this.addRenderableWidget((GuiEventListener)new ButtonWidget(x - w / 2, y, w / 4, h, (Component)Component.literal((String)"<<"), b -> onPress.accept(false)));
        buttons[2] = (ButtonWidget)this.addRenderableWidget((GuiEventListener)new ButtonWidget(x + w / 4, y, w / 4, h, (Component)Component.literal((String)">>"), b -> onPress.accept(true)));
        buttons[0] = (ButtonWidget)this.addRenderableWidget((GuiEventListener)new ButtonWidget(x - w / 4, y, w / 2, h, (Component)Component.literal((String)""), b -> {}, tooltip));
        return buttons;
    }

    protected void drawBuildingIcon(GuiGraphics context, ResourceLocation texture, int x, int y, int u, int v) {
        PoseStack matrices = context.pose();
        matrices.pushPose();
        matrices.translate((double)x - 6.6, (double)y - 6.6, 0.0);
        matrices.scale(0.66f, 0.66f, 0.66f);
        context.blit(texture, 0, 0, u, v, 20, 20);
        matrices.popPose();
    }

    public void init() {
        Network.sendToServer(new GetVillageRequest());
        this.setPage("waiting");
    }

    private void setPage(String page) {
        if (page.equals("close")) {
            assert (this.minecraft != null);
            this.minecraft.setScreen(null);
            return;
        }
        this.page = page;
        this.clearWidgets();
        this.addRenderableWidget((GuiEventListener)new ButtonWidget(5, 5, 20, 20, (Component)Component.translatable((String)"gui.button.backarrow"), b -> this.setPage("close")));
        int bx = this.width / 2 - 180;
        int by = this.height / 2 - 56;
        if (!(page.equals("rename") || page.equals("empty") || page.equals("waiting"))) {
            for (String p : new String[]{"map", "rank", "catalog", "villagers", "rules", "refresh"}) {
                ButtonWidget widget = new ButtonWidget(bx, by, 80, 20, (Component)Component.translatable((String)("gui.blueprint." + p)), b -> this.setPage(p));
                this.addRenderableWidget((GuiEventListener)widget);
                if (page.equals(p)) {
                    widget.active = false;
                }
                by += 22;
            }
        }
        switch (page) {
            case "empty": {
                bx = this.width / 2 - 48;
                by = this.height / 2;
                this.addRenderableWidget((GuiEventListener)new TooltipButtonWidget(bx - 50, by + 5, 96, 20, "gui.blueprint.addRoom", b -> {
                    Network.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.ADD_ROOM));
                    Network.sendToServer(new GetVillageRequest());
                    this.onClose();
                }));
                this.addRenderableWidget((GuiEventListener)new TooltipButtonWidget(bx + 50, by + 5, 96, 20, "gui.blueprint.addBuilding", b -> {
                    Network.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.ADD));
                    Network.sendToServer(new GetVillageRequest());
                    this.onClose();
                }));
                break;
            }
            case "refresh": {
                Network.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.FULL_SCAN));
                Network.sendToServer(new GetVillageRequest());
                assert (this.minecraft != null);
                assert (this.minecraft.player != null);
                this.minecraft.player.displayClientMessage((Component)Component.translatable((String)"blueprint.refreshed"), true);
                this.setPage("map");
                break;
            }
            case "advanced": {
                bx = this.width / 2 + 180 - 64 - 16;
                by = this.height / 2 - 56;
                MutableComponent text = Component.translatable((String)"gui.blueprint.autoScan");
                if (this.village.isAutoScan()) {
                    text.withStyle(ChatFormatting.GREEN);
                } else {
                    text.withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.STRIKETHROUGH);
                }
                this.addRenderableWidget((GuiEventListener)new TooltipButtonWidget(bx, by, 96, 20, text, Component.translatable((String)"gui.blueprint.autoScan.tooltip"), arg_0 -> this.lambda$setPage$7((String)page, arg_0)));
                this.addRenderableWidget((GuiEventListener)new TooltipButtonWidget(bx, by += 22, 96, 20, "gui.blueprint.restrictAccess", b -> {
                    Network.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.FORCE_TYPE, "blocked"));
                    Network.sendToServer(new GetVillageRequest());
                }));
                this.addRenderableWidget((GuiEventListener)new TooltipButtonWidget(bx, by += 22, 96, 20, "gui.blueprint.addBuilding", b -> {
                    Network.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.ADD));
                    Network.sendToServer(new GetVillageRequest());
                }));
                by += 66;
                if (this.isVillage) {
                    this.addRenderableWidget((GuiEventListener)new ButtonWidget(bx, by, 96, 20, (Component)Component.translatable((String)"gui.blueprint.renameVillage"), b -> this.setPage("rename")));
                }
            }
            case "map": {
                bx = this.width / 2 + 180 - 64 - 16;
                by = this.height / 2 - 56 + 66;
                this.addRenderableWidget((GuiEventListener)new TooltipButtonWidget(bx, by, 96, 20, "gui.blueprint.addRoom", b -> {
                    Network.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.ADD_ROOM));
                    Network.sendToServer(new GetVillageRequest());
                }));
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(bx, by += 22, 96, 20, (Component)Component.translatable((String)"gui.blueprint.removeBuilding"), b -> {
                    Network.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.REMOVE));
                    Network.sendToServer(new GetVillageRequest());
                }));
                by += 22;
                if (page.equals("advanced")) break;
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(bx, by, 96, 20, (Component)Component.translatable((String)"gui.blueprint.advanced"), b -> this.setPage("advanced")));
                break;
            }
            case "rank": {
                break;
            }
            case "catalog": {
                int row = 0;
                int col = 0;
                int size = 21;
                int x = this.width / 2 - 4 * size - 8;
                int y = (int)((double)this.height / 2.0 - 2.0 * (double)size);
                this.catalogButtons.clear();
                for (BuildingType bt : BuildingTypes.getInstance()) {
                    if (!bt.visible()) continue;
                    LegacyImageButton widget = new LegacyImageButton(row * size + x + 10, col * size + y - 10, 20, 20, bt.iconU(), bt.iconV() + 20, 20, ICON_TEXTURES, 256, 256, button -> {
                        this.selectBuilding(bt);
                        button.active = false;
                        this.catalogButtons.forEach(b -> {
                            b.active = true;
                        });
                    }, (Component)Component.translatable((String)("buildingType." + bt.name())));
                    this.catalogButtons.add((Button)this.addRenderableWidget((GuiEventListener)widget));
                    if (++row <= 4) continue;
                    row = 0;
                    ++col;
                }
                break;
            }
            case "villagers": {
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 24 - 20, this.height / 2 + 54, 20, 20, (Component)Component.literal((String)"<"), b -> {
                    if (this.pageNumber > 0) {
                        --this.pageNumber;
                    }
                }));
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + 24, this.height / 2 + 54, 20, 20, (Component)Component.literal((String)">"), b -> {
                    if ((double)this.pageNumber < Math.ceil((double)this.village.getPopulation() / 9.0) - 1.0) {
                        ++this.pageNumber;
                    }
                }));
                this.buttonPage = (ButtonWidget)this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 24, this.height / 2 + 54, 48, 20, (Component)Component.literal((String)"0/0)"), b -> {}));
                break;
            }
            case "rules": {
                this.buttonTaxes = this.createValueChanger(this.width / 2, this.height / 2 + -60 + 10, 80, 20, b -> this.changeTaxes(b != false ? 0.125f : -0.125f), (Component)Component.translatable((String)"gui.blueprint.tooltip.taxes"));
                this.toggleButtons(this.buttonTaxes, false);
                this.buttonBirths = this.createValueChanger(this.width / 2, this.height / 2 + -10 + 10, 80, 20, b -> this.changePopulationThreshold(b != false ? 0.125f : -0.125f), (Component)Component.translatable((String)"gui.blueprint.tooltip.births"));
                this.toggleButtons(this.buttonBirths, false);
                this.buttonMarriage = this.createValueChanger(this.width / 2, this.height / 2 + 40 + 10, 80, 20, b -> this.changeMarriageThreshold(b != false ? 0.125f : -0.125f), (Component)Component.translatable((String)"gui.blueprint.tooltip.marriage"));
                this.toggleButtons(this.buttonMarriage, false);
                break;
            }
            case "rename": {
                EditBox field = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 65, this.height / 2 - 16, 130, 20, (Component)Component.translatable((String)"gui.blueprint.renameVillage")));
                field.setMaxLength(32);
                field.setValue(this.village.getName());
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 66, this.height / 2 + 8, 64, 20, (Component)Component.translatable((String)"gui.blueprint.cancel"), b -> this.setPage("map")));
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + 2, this.height / 2 + 8, 64, 20, (Component)Component.translatable((String)"gui.blueprint.rename"), b -> {
                    Network.sendToServer(new RenameVillageMessage(this.village.getId(), field.getValue()));
                    this.village.setName(field.getValue());
                    this.setPage("map");
                }));
            }
        }
    }

    private void selectBuilding(BuildingType b) {
        this.selectedBuilding = b;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(GuiGraphics context, int sizeX, int sizeY, float offset) {
        super.render(context, sizeX, sizeY, offset);
        assert (this.minecraft != null);
        this.mouseX = (int)(this.minecraft.mouseHandler.xpos() * (double)this.width / (double)this.minecraft.getWindow().getWidth());
        this.mouseY = (int)(this.minecraft.mouseHandler.ypos() * (double)this.height / (double)this.minecraft.getWindow().getHeight());
        switch (this.page) {
            case "waiting": {
                context.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.blueprint.waiting"), this.width / 2, this.height / 2, -5592406);
                break;
            }
            case "empty": {
                context.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.blueprint.empty"), this.width / 2, this.height / 2 - 20, -5592406);
                break;
            }
            case "map": {
                this.renderStats(context);
                this.renderName(context);
                this.renderMap(context);
                break;
            }
            case "advanced": {
                this.renderName(context);
                this.renderMap(context);
                break;
            }
            case "rank": {
                this.renderTasks(context);
                this.renderStats(context);
                break;
            }
            case "catalog": {
                this.renderCatalog(context);
                break;
            }
            case "villagers": {
                this.renderVillagers(context);
                break;
            }
            case "rules": {
                this.renderRules(context);
            }
        }
    }

    private void renderName(GuiGraphics context) {
        PoseStack matrices = context.pose();
        matrices.pushPose();
        matrices.scale(2.0f, 2.0f, 2.0f);
        if (this.isVillage) {
            context.drawCenteredString(this.font, this.village.getName(), this.width / 4, this.height / 4 - 48, -1);
        } else {
            context.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.blueprint.settlement"), this.width / 4, this.height / 4 - 48, -1);
        }
        matrices.popPose();
    }

    private void renderStats(GuiGraphics context) {
        int x = this.width / 2 + (this.page.equals("rank") ? -70 : 105);
        int y = this.height / 2 - 50;
        MutableComponent rankStr = Component.translatable((String)this.rank.getTranslationKey());
        int rankColor = this.rank.ordinal() == 0 ? -65536 : -256;
        context.drawString(this.font, (Component)Component.translatable((String)"gui.blueprint.currentRank", (Object[])new Object[]{rankStr}), x, y, rankColor);
        context.drawString(this.font, (Component)Component.translatable((String)"gui.blueprint.reputation", (Object[])new Object[]{String.valueOf(this.reputation)}), x, y + 11, this.rank.ordinal() == 0 ? -65536 : -1);
        context.drawString(this.font, (Component)Component.translatable((String)"gui.blueprint.buildings", (Object[])new Object[]{this.village.getBuildings().size()}), x, y + 22, -1);
        context.drawString(this.font, (Component)Component.translatable((String)"gui.blueprint.population", (Object[])new Object[]{this.village.getPopulation(), this.village.getMaxPopulation()}), x, y + 33, -1);
    }

    /*
     * WARNING - void declaration
     */
    private void renderMap(GuiGraphics context) {
        void var11_14;
        PoseStack matrices = context.pose();
        int mapSize = 75;
        int y = this.height / 2 + 8;
        WidgetUtils.drawRectangle(context, this.width / 2 - mapSize, y - mapSize, this.width / 2 + mapSize, y + mapSize, -120);
        if (!this.village.isAutoScan() && this.village.getBuildings().size() <= 1) {
            context.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.blueprint.autoScanDisabled"), this.width / 2, this.height / 2 + 90, -1426063361);
        }
        matrices.pushPose();
        float sc = Math.min((float)mapSize / (float)(this.village.getBox().getMaxBlockCount() + 3) * 2.0f, 2.0f);
        int mouseLocalX = (int)(((double)this.mouseX - (double)this.width / 2.0) / (double)sc + (double)this.village.getCenter().getX());
        int mouseLocalY = (int)((float)(this.mouseY - y) / sc + (float)this.village.getCenter().getZ());
        matrices.translate((double)this.width / 2.0, (double)y, 0.0);
        matrices.scale(sc, sc, 0.0f);
        matrices.translate((float)(-this.village.getCenter().getX()), (float)(-this.village.getCenter().getZ()), 0.0f);
        assert (this.minecraft != null);
        LocalPlayer player = this.minecraft.player;
        if (player != null) {
            WidgetUtils.drawRectangle(context, (int)player.getX() - 1, (int)player.getZ() - 1, (int)player.getX() + 1, (int)player.getZ() + 1, -65281);
        }
        LinkedList<Building> hoverBuildings = new LinkedList<Building>();
        for (Building building : this.village.getBuildings().values()) {
            if (!building.isComplete()) continue;
            BuildingType bt = building.getBuildingType();
            if (bt.isIcon()) {
                BlockPos blockPos = building.getCenter();
                this.drawBuildingIcon(context, ICON_TEXTURES, blockPos.getX(), blockPos.getZ(), bt.iconU(), bt.iconV());
                int n = 6;
                Vec3i vec3i = new Vec3i(mouseLocalX, blockPos.getY(), mouseLocalY);
                if (!(blockPos.distSqr(vec3i) < (double)(n * n))) continue;
                hoverBuildings.add(building);
                continue;
            }
            BlockPos blockPos = building.getPos0();
            BlockPos blockPos2 = building.getPos1();
            WidgetUtils.drawRectangle(context, blockPos.getX(), blockPos.getZ(), blockPos2.getX(), blockPos2.getZ(), bt.getColor());
            if (bt.visible()) {
                BlockPos c = building.getCenter();
                this.drawBuildingIcon(context, ICON_TEXTURES, c.getX(), c.getZ(), bt.iconU(), bt.iconV());
            }
            int margin = 1;
            if (mouseLocalX < blockPos.getX() - margin || mouseLocalX > blockPos2.getX() + margin || mouseLocalY < blockPos.getZ() - margin || mouseLocalY > blockPos2.getZ() + margin) continue;
            hoverBuildings.add(building);
        }
        matrices.popPose();
        hoverBuildings.sort((a, b) -> b.getCenter().getY() - a.getCenter().getY());
        LinkedList<List<Component>> tooltips = new LinkedList<List<Component>>();
        for (Object b2 : hoverBuildings) {
            tooltips.add(this.getBuildingTooltip((Building)b2));
        }
        boolean bl = false;
        for (List list : tooltips) {
            var11_14 += this.getTooltipHeight(list) + 9;
        }
        int py = this.mouseY - var11_14 / 2 + 12;
        for (List list : tooltips) {
            context.renderComponentTooltip(this.font, list, this.mouseX, py);
            py += this.getTooltipHeight(list) + 9;
        }
    }

    private List<Component> getBuildingTooltip(Building hoverBuilding) {
        LinkedList<Component> lines = new LinkedList<Component>();
        BuildingType bt = BuildingTypes.getInstance().getBuildingType(hoverBuilding.getType());
        lines.add((Component)Component.translatable((String)("buildingType." + bt.name())));
        for (String string : this.village.getResidents(hoverBuilding.getId())) {
            lines.add((Component)Component.literal((String)string));
        }
        for (Map.Entry entry : hoverBuilding.getBlocks().entrySet()) {
            lines.add((Component)Component.literal((String)(((List)entry.getValue()).size() + " x ")).append(this.getBlockName((ResourceLocation)entry.getKey())).withStyle(ChatFormatting.GRAY));
        }
        return lines;
    }

    private void renderTasks(GuiGraphics context) {
        if (this.rank == null) {
            return;
        }
        int y = this.height / 2 + 5;
        int x = this.width / 2 - 70;
        for (Task task : this.tasks.get((Object)this.rank.promote())) {
            boolean completed = this.completedTasks.contains(task.getId());
            MutableComponent t = task.getTranslatable().withStyle(completed ? ChatFormatting.STRIKETHROUGH : ChatFormatting.RESET);
            context.drawString(this.font, (Component)t, x, y, completed ? -7798904 : -43691);
            y += 11;
        }
    }

    private void renderCatalog(GuiGraphics context) {
        PoseStack matrices = context.pose();
        matrices.pushPose();
        matrices.scale(2.0f, 2.0f, 2.0f);
        context.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.blueprint.catalogFull"), this.width / 4, this.height / 4 - 52, -1);
        matrices.popPose();
        context.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.blueprint.catalogHint").withStyle(ChatFormatting.GRAY), this.width / 2, this.height / 2 - 82, -1);
        int x = this.width / 2 + 35;
        int y = this.height / 2 - 50;
        if (this.selectedBuilding != null) {
            context.drawString(this.font, (Component)Component.translatable((String)("buildingType." + this.selectedBuilding.name())), x, y, this.selectedBuilding.getColor());
            y += 12;
            List<Component> wrap = FlowingText.wrap((Component)Component.translatable((String)("buildingType." + this.selectedBuilding.name() + ".description")).withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC), 150);
            for (Component component : wrap) {
                context.drawString(this.font, component, x, y, -1);
                y += 10;
            }
            y += 24;
            for (Map.Entry entry : this.selectedBuilding.getGroups().entrySet()) {
                context.drawString(this.font, (Component)Component.literal((String)(String.valueOf(entry.getValue()) + " x ")).append(this.getBlockName((ResourceLocation)entry.getKey())), x, y, -1);
                y += 10;
            }
        } else {
            List<Component> wrap = FlowingText.wrap((Component)Component.translatable((String)"gui.blueprint.buildingTypes").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC), 150);
            for (Component component : wrap) {
                context.drawString(this.font, component, x, y, -1);
                y += 10;
            }
        }
    }

    private void renderVillagers(GuiGraphics context) {
        int index;
        int maxPages = (int)Math.ceil((double)this.village.getPopulation() / 9.0);
        this.buttonPage.setMessage((Component)Component.literal((String)(this.pageNumber + 1 + "/" + maxPages)));
        List villager = this.village.getResidentNames().entrySet().stream().sorted(Map.Entry.comparingByValue()).toList();
        this.selectedVillager = null;
        for (int i = 0; i < 9 && (index = i + this.pageNumber * 9) < villager.size(); ++i) {
            int y = this.height / 2 - 51 + i * 11;
            boolean hover = this.isMouseWithin(this.width / 2 - 50, y - 1, 100, 11);
            context.drawCenteredString(this.font, (Component)Component.literal((String)((String)villager.get(index).getValue())), this.width / 2, y, hover ? -2631804 : -1);
            if (!hover) continue;
            this.selectedVillager = (UUID)villager.get(index).getKey();
        }
    }

    private void renderRules(GuiGraphics context) {
        this.buttonTaxes[0].setMessage((Component)Component.literal((String)((int)(this.village.getTaxes() * 100.0f) + "%")));
        this.buttonMarriage[0].setMessage((Component)Component.literal((String)((int)(this.village.getMarriageThreshold() * 100.0f) + "%")));
        this.buttonBirths[0].setMessage((Component)Component.literal((String)((int)(this.village.getPopulationThreshold() * 100.0f) + "%")));
        context.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.blueprint.taxes"), this.width / 2, this.height / 2 + -60, -1);
        if (!this.rank.isAtLeast(Rank.MERCHANT)) {
            context.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.blueprint.rankTooLow"), this.width / 2, this.height / 2 + -60 + 15, -1);
            this.toggleButtons(this.buttonTaxes, false);
        } else {
            this.toggleButtons(this.buttonTaxes, true);
        }
        context.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.blueprint.birth"), this.width / 2, this.height / 2 + -10, -1);
        if (!this.rank.isAtLeast(Rank.NOBLE)) {
            context.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.blueprint.rankTooLow"), this.width / 2, this.height / 2 + -10 + 15, -1);
            this.toggleButtons(this.buttonBirths, false);
        } else {
            this.toggleButtons(this.buttonBirths, true);
        }
        context.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.blueprint.marriage"), this.width / 2, this.height / 2 + 40, -1);
        if (!this.rank.isAtLeast(Rank.MAYOR)) {
            context.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.blueprint.rankTooLow"), this.width / 2, this.height / 2 + 40 + 15, -1);
            this.toggleButtons(this.buttonMarriage, false);
        } else {
            this.toggleButtons(this.buttonMarriage, true);
        }
    }

    private Component getBlockName(ResourceLocation id) {
        if (BuiltInRegistries.BLOCK.containsKey(id)) {
            return Component.translatable((String)((Block)BuiltInRegistries.BLOCK.get(id)).getDescriptionId());
        }
        return Component.translatable((String)("tag.block." + id.getNamespace() + "." + id.getPath()));
    }

    private void toggleButtons(ButtonWidget[] buttons, boolean active) {
        for (ButtonWidget b : buttons) {
            b.active = active;
            b.visible = active;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.page.equals("villagers") && this.selectedVillager != null) {
            assert (this.minecraft != null);
            this.minecraft.setScreen((Screen)new FamilyTreeScreen(this.selectedVillager));
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected boolean isMouseWithin(int x, int y, int w, int h) {
        return this.mouseX >= x && this.mouseX < x + w && this.mouseY >= y && this.mouseY < y + h;
    }

    public void setVillage(Village village) {
        this.village = village;
        if (village == null) {
            this.setPage("empty");
        } else if (this.page.equals("waiting")) {
            this.setPage("map");
        }
    }

    public void setVillageData(Rank rank, int reputation, boolean isVillage, Set<String> completedTasks, Map<Rank, List<Task>> tasks) {
        this.rank = rank;
        this.reputation = reputation;
        this.isVillage = isVillage;
        this.completedTasks = completedTasks;
        this.tasks = tasks;
    }

    private /* synthetic */ void lambda$setPage$7(String page, Button b) {
        Network.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.AUTO_SCAN));
        Network.sendToServer(new GetVillageRequest());
        this.village.toggleAutoScan();
        this.setPage(page);
    }
}

