/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.conczin.mca.Config;
import net.conczin.mca.MCA;
import net.conczin.mca.MCAClient;
import net.conczin.mca.client.gui.VillagerEditorScreen;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.c2s.DestinyMessage;
import net.conczin.mca.util.compat.ButtonWidget;
import net.conczin.mca.util.localization.FlowingText;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class DestinyScreen
extends VillagerEditorScreen {
    private static final ResourceLocation LOGO_TEXTURE = MCA.locate("textures/banner.png");
    private final LinkedList<Component> story = new LinkedList();
    private final boolean allowTeleportation;
    private String location;
    private boolean teleported = false;
    private ButtonWidget acceptWidget;

    public DestinyScreen(UUID playerUUID, boolean allowTeleportation) {
        super(playerUUID, playerUUID);
        this.allowTeleportation = allowTeleportation;
    }

    @Override
    public boolean isPauseScreen() {
        return true;
    }

    public void onClose() {
        if (!this.page.equals("general") && !this.page.equals("story")) {
            this.setPage("destiny");
        }
    }

    @Override
    protected String[] getPages() {
        LinkedList<String> pages = new LinkedList<String>();
        pages.add("general");
        if (Config.getInstance().allowBodyCustomizationInDestiny) {
            pages.add("body");
            pages.add("head");
        }
        if (Config.getInstance().allowTraitCustomizationInDestiny) {
            pages.add("traits");
        }
        return pages.toArray(new String[0]);
    }

    private void drawScaledText(GuiGraphics context, Component text, int x, int y, float scale) {
        PoseStack matrices = context.pose();
        matrices.pushPose();
        matrices.scale(scale, scale, scale);
        context.drawCenteredString(this.font, text, (int)((float)x / scale), (int)((float)y / scale), -1);
        matrices.popPose();
    }

    public void renderBackground(GuiGraphics context, int mouseX, int mouseY, float partialTick) {
        this.renderPanorama(context, partialTick);
        this.renderBlurredBackground(partialTick);
        this.renderMenuBackground(context);
    }

    @Override
    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        PoseStack matrices = context.pose();
        switch (this.page) {
            case "general": {
                this.drawScaledText(context, (Component)Component.translatable((String)"gui.destiny.whoareyou"), this.width / 2, this.height / 2 - 24, 1.5f);
                matrices.pushPose();
                matrices.scale(0.25f, 0.25f, 0.25f);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                context.blit(LOGO_TEXTURE, this.width * 2 - 512, -40, 0.0f, 0.0f, 1024, 512, 1024, 512);
                matrices.popPose();
                break;
            }
            case "destiny": {
                this.drawScaledText(context, (Component)Component.translatable((String)"gui.destiny.journey"), this.width / 2, this.height / 2 - 48, 1.5f);
                break;
            }
            case "story": {
                List<Component> text = FlowingText.wrap(this.story.getFirst(), 256);
                int y = (int)((double)this.height / 2.0 - 20.0 - (double)(7.5f * (float)text.size()));
                for (Component t : text) {
                    this.drawScaledText(context, t, this.width / 2, y, 1.25f);
                    y += 15;
                }
                break;
            }
        }
    }

    @Override
    protected boolean shouldDrawEntity() {
        return !this.page.equals("general") && !this.page.equals("destiny") && !this.page.equals("story") && super.shouldDrawEntity();
    }

    protected String getPath(String location) {
        String[] split = location.split(":");
        return split[split.length - 1];
    }

    @Override
    protected void setPage(String page) {
        if (page.equals("destiny") && !this.allowTeleportation) {
            Network.sendToServer(new DestinyMessage("", true));
            MCAClient.getDestinyManager().allowClosing();
            super.onClose();
            return;
        }
        if (page.equals("destiny") && Config.getServerConfig().destinySpawnLocations.size() == 1) {
            this.selectStory(Config.getServerConfig().destinySpawnLocations.getFirst());
            return;
        }
        this.page = page;
        this.clearWidgets();
        switch (page) {
            case "general": {
                this.drawName(this.width / 2 - 87, this.height / 2, name -> {
                    this.updateName((String)name);
                    if (this.acceptWidget != null) {
                        this.acceptWidget.active = !MCA.isBlankString(name);
                    }
                });
                this.drawGender(this.width / 2 - 87, this.height / 2 + 24);
                this.addModelSelectionWidgets(this.width / 2 - 87, this.height / 2 + 24 + 22);
                this.acceptWidget = (ButtonWidget)this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 32, this.height / 2 + 60 + 22, 64, 20, (Component)Component.translatable((String)"gui.button.accept"), sender -> {
                    if (Config.getInstance().allowBodyCustomizationInDestiny) {
                        this.setPage("body");
                    } else if (Config.getInstance().allowTraitCustomizationInDestiny) {
                        this.setPage("traits");
                    } else {
                        this.setPage("destiny");
                    }
                }));
                break;
            }
            case "destiny": {
                int x = 0;
                int y = 0;
                for (String location : Config.getServerConfig().destinySpawnLocations) {
                    int rows = (int)Math.ceil((float)Config.getServerConfig().destinySpawnLocations.size() / 3.0f);
                    float offsetX = y + 1 == rows ? (float)(2 - (Config.getServerConfig().destinySpawnLocations.size() - 1) % 3) / 2.0f : 0.0f;
                    float offsetY = (float)Math.max(0, 3 - rows) / 2.0f;
                    MutableComponent name2 = Component.translatable((String)("gui.destiny." + this.getPath(location)));
                    this.addRenderableWidget((GuiEventListener)new ButtonWidget((int)((float)this.width / 2.0f - 144.0f + ((float)x + offsetX) * 96.0f), (int)((float)this.height / 2.0f + ((float)y + offsetY) * 20.0f - 16.0f), 96, 20, (Component)name2, sender -> this.selectStory(location)));
                    if (++x < 3) continue;
                    x = 0;
                    ++y;
                }
                break;
            }
            case "story": {
                this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 48, this.height / 2 + 32, 96, 20, (Component)Component.translatable((String)"gui.destiny.next"), sender -> {
                    if (!this.teleported) {
                        Network.sendToServer(new DestinyMessage(this.location, false));
                        MCAClient.getDestinyManager().allowClosing();
                        this.teleported = true;
                    }
                    if (this.story.size() > 1) {
                        this.story.removeFirst();
                    } else {
                        Network.sendToServer(new DestinyMessage("", true));
                        super.onClose();
                    }
                }));
                break;
            }
            default: {
                super.setPage(page);
            }
        }
    }

    private void selectStory(String location) {
        this.story.clear();
        this.story.add((Component)Component.translatable((String)"destiny.story.reason"));
        Map<String, String> map = Config.getInstance().destinyLocationsToTranslationMap;
        this.story.add((Component)Component.translatable((String)map.getOrDefault(location, map.getOrDefault("default", "missing_default"))));
        this.story.add((Component)Component.translatable((String)("destiny.story." + this.getPath(location))));
        this.location = location;
        this.setPage("story");
    }
}

