/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.gui;

import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.conczin.mca.MCA;
import net.conczin.mca.client.gui.FamilyTreeScreen;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.c2s.FamilyTreeUUIDLookup;
import net.conczin.mca.util.compat.ButtonWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class FamilyTreeSearchScreen
extends Screen {
    static final int DATA_WIDTH = 120;
    private List<Entry> list = new LinkedList<Entry>();
    private ButtonWidget buttonPage;
    private int pageNumber;
    private UUID selectedVillager;
    private int mouseX;
    private int mouseY;
    private String currentVillagerName = "";

    public FamilyTreeSearchScreen() {
        super((Component)Component.translatable((String)"gui.family_tree.title"));
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void init() {
        EditBox field = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 60, this.height / 2 - 80, 120, 18, (Component)Component.translatable((String)"structure_block.structure_name")));
        field.setMaxLength(32);
        field.setResponder(this::searchVillager);
        field.setFocused(true);
        this.setFocused((GuiEventListener)field);
        this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 44, this.height / 2 + 82, 88, 20, (Component)Component.translatable((String)"gui.done"), sender -> this.onClose()));
        this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 24 - 20, this.height / 2 + 60, 20, 20, (Component)Component.literal((String)"<"), b -> {
            if (this.pageNumber > 0) {
                --this.pageNumber;
            }
        }));
        this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + 24, this.height / 2 + 60, 20, 20, (Component)Component.literal((String)">"), b -> {
            if ((double)this.pageNumber < Math.ceil((double)this.list.size() / 9.0) - 1.0) {
                ++this.pageNumber;
            }
        }));
        this.buttonPage = (ButtonWidget)this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 24, this.height / 2 + 60, 48, 20, (Component)Component.literal((String)"0/0)"), b -> {}));
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        assert (this.minecraft != null);
        this.mouseX = (int)(this.minecraft.mouseHandler.xpos() * (double)this.width / (double)this.minecraft.getWindow().getWidth());
        this.mouseY = (int)(this.minecraft.mouseHandler.ypos() * (double)this.height / (double)this.minecraft.getWindow().getHeight());
        context.fill(this.width / 2 - 60 - 10, this.height / 2 - 110, this.width / 2 + 60 + 10, this.height / 2 + 110, 0x66000000);
        this.renderVillagers(context);
        context.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.title.family_tree"), this.width / 2, this.height / 2 - 100, 0xFFFFFF);
    }

    private void renderVillagers(GuiGraphics context) {
        int index;
        int maxPages = (int)Math.ceil((double)this.list.size() / 9.0);
        this.buttonPage.setMessage((Component)Component.literal((String)(this.pageNumber + 1 + "/" + maxPages)));
        this.selectedVillager = null;
        for (int i = 0; i < 9 && (index = i + this.pageNumber * 9) < this.list.size(); ++i) {
            int y = this.height / 2 - 52 + i * 12;
            boolean hover = this.isMouseWithin(this.width / 2 - 50, y - 1, 100, 12);
            Entry entry = this.list.get(index);
            MutableComponent text = MCA.isBlankString(entry.mother) && MCA.isBlankString(entry.father) ? Component.translatable((String)"gui.family_tree.child_of_0") : (MCA.isBlankString(entry.mother) ? Component.translatable((String)"gui.family_tree.child_of_1", (Object[])new Object[]{entry.father}) : (MCA.isBlankString(entry.father) ? Component.translatable((String)"gui.family_tree.child_of_1", (Object[])new Object[]{entry.mother}) : Component.translatable((String)"gui.family_tree.child_of_2", (Object[])new Object[]{entry.father, entry.mother})));
            context.drawCenteredString(this.font, (Component)text, this.width / 2, y, hover ? -2631804 : -1);
            if (!hover) continue;
            this.selectedVillager = entry.uuid;
        }
    }

    private void searchVillager(String v) {
        if (!MCA.isBlankString(v)) {
            Network.sendToServer(new FamilyTreeUUIDLookup(v));
        }
        this.currentVillagerName = v;
    }

    public void setList(List<Entry> list) {
        this.list = list;
    }

    protected boolean isMouseWithin(int x, int y, int w, int h) {
        return this.mouseX >= x && this.mouseX < x + w && this.mouseY >= y && this.mouseY < y + h;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.selectedVillager != null) {
            this.selectVillager(this.currentVillagerName, this.selectedVillager);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    void selectVillager(String name, UUID villager) {
        assert (this.minecraft != null);
        this.minecraft.setScreen((Screen)new FamilyTreeScreen(villager));
    }

    public record Entry(UUID uuid, String father, String mother) {
        public static final StreamCodec<ByteBuf, Entry> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, Entry::uuid, (StreamCodec)ByteBufCodecs.STRING_UTF8, Entry::father, (StreamCodec)ByteBufCodecs.STRING_UTF8, Entry::mother, Entry::new);
    }
}

