/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.gui;

import java.util.Objects;
import net.conczin.mca.item.BabyItem;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.c2s.BabyNameRequest;
import net.conczin.mca.network.c2s.BabyNamingVillagerMessage;
import net.conczin.mca.util.compat.ButtonWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class NameBabyScreen
extends Screen {
    private final ItemStack baby;
    private final Player player;
    private EditBox babyNameTextField;

    public NameBabyScreen(Player player, ItemStack baby) {
        super((Component)Component.translatable((String)"gui.nameBaby.title"));
        this.baby = baby;
        this.player = player;
    }

    public void init() {
        this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 40, this.height / 2 + 20, 80, 20, (Component)Component.translatable((String)"gui.button.done"), b -> {
            Network.sendToServer(new BabyNamingVillagerMessage(this.player.getInventory().selected, this.babyNameTextField.getValue().trim()));
            Objects.requireNonNull(this.minecraft).setScreen(null);
        }));
        this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 + 105, this.height / 2 - 20, 60, 20, (Component)Component.translatable((String)"gui.button.random"), b -> Network.sendToServer(new BabyNameRequest(((BabyItem)this.baby.getItem()).getGender()))));
        this.babyNameTextField = new EditBox(this.font, this.width / 2 - 100, this.height / 2 - 20, 200, 20, (Component)Component.translatable((String)"structure_block.structure_name"));
        this.babyNameTextField.setMaxLength(32);
        this.setInitialFocus((GuiEventListener)this.babyNameTextField);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(GuiGraphics context, int w, int h, float scale) {
        super.render(context, w, h, scale);
        this.setFocused((GuiEventListener)this.babyNameTextField);
        context.drawCenteredString(this.font, this.title, this.width / 2, 70, 0xFFFFFF);
        this.babyNameTextField.render(context, this.width / 2 - 100, this.height / 2 - 20, scale);
    }

    public void setBabyName(String name) {
        this.babyNameTextField.setValue(name);
    }
}

