/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.gui.widget;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.conczin.mca.util.localization.FlowingText;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;

public abstract class ExtendedSliderWidget<T>
extends AbstractSliderButton {
    protected final Supplier<Component> tooltipSupplier;
    final Consumer<T> onApplyValue;
    private T oldValue;

    public ExtendedSliderWidget(int x, int y, int width, int height, Component text, double value, Consumer<T> onApplyValue, Supplier<Component> tooltipSupplier) {
        super(x, y, width, height, text, value);
        this.onApplyValue = onApplyValue;
        this.tooltipSupplier = tooltipSupplier;
    }

    protected double getOpticalValue() {
        return this.value;
    }

    abstract T getValue();

    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int i = (this.isHovered() ? 2 : 1) * 20;
        super.renderWidget(context, mouseX, mouseY, delta);
        if (this.isHovered()) {
            this.renderTooltip(context, mouseX, mouseY);
        }
    }

    protected void applyValue() {
        T v = this.getValue();
        if (v != this.oldValue) {
            this.oldValue = v;
            this.onApplyValue.accept(v);
        }
    }

    public void renderTooltip(GuiGraphics context, int mouseX, int mouseY) {
        context.renderComponentTooltip(Minecraft.getInstance().font, FlowingText.wrap(this.tooltipSupplier.get(), 160), mouseX, mouseY);
    }
}

