/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Supplier;
import net.conczin.mca.client.gui.widget.ColorPickerWidget;
import net.conczin.mca.client.gui.widget.HorizontalColorPickerWidget;
import net.conczin.mca.client.gui.widget.WidgetUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;

public class HorizontalGradientWidget
extends HorizontalColorPickerWidget {
    private final Supplier<float[]> startColorSupplier;
    private final Supplier<float[]> endColorSupplier;

    public HorizontalGradientWidget(int x, int y, int width, int height, double valueX, Supplier<float[]> startColorSupplier, Supplier<float[]> endColorSupplier, ColorPickerWidget.DualConsumer<Double, Double> consumer) {
        super(x, y, width, height, valueX, null, consumer);
        this.startColorSupplier = startColorSupplier;
        this.endColorSupplier = endColorSupplier;
    }

    @Override
    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder builder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        float[] startColor = this.startColorSupplier.get();
        float[] endColor = this.endColorSupplier.get();
        float z = 0.0f;
        PoseStack matrices = context.pose();
        Matrix4f matrix = matrices.last().pose();
        builder.addVertex(matrix, (float)this.getX() + (float)this.width, (float)this.getY(), z).setColor(endColor[0], endColor[1], endColor[2], endColor[3]);
        builder.addVertex(matrix, (float)this.getX(), (float)this.getY(), z).setColor(startColor[0], startColor[1], startColor[2], startColor[3]);
        builder.addVertex(matrix, (float)this.getX(), (float)this.getY() + (float)this.height, z).setColor(startColor[0], startColor[1], startColor[2], startColor[3]);
        builder.addVertex(matrix, (float)this.getX() + (float)this.width, (float)this.getY() + (float)this.height, z).setColor(endColor[0], endColor[1], endColor[2], endColor[3]);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.disableBlend();
        WidgetUtils.drawRectangle(context, this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -1426063361);
        context.blit(MCA_GUI_ICONS_TEXTURE, (int)((double)this.getX() + this.valueX * (double)this.width) - 8, (int)((double)this.getY() + this.valueY * (double)this.height) - 8, 240.0f, 0.0f, 16, 16, 256, 256);
    }
}

