/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.UUID;
import net.conczin.mca.MCAClient;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.VillagerLike;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.conczin.mca.entity.ai.relationship.VillagerDimensions;
import net.conczin.mca.registry.EntitiesMCA;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public interface CommonVillagerModel<T extends LivingEntity> {
    public static VillagerLike<?> getVillager(Level world, UUID uuid) {
        if (MCAClient.fallbackVillager == null) {
            MCAClient.fallbackVillager = (VillagerEntityMCA)EntitiesMCA.MALE_VILLAGER.create(world);
        }
        return MCAClient.playerData.getOrDefault(uuid, MCAClient.fallbackVillager);
    }

    public static VillagerLike<?> getVillager(Entity villager) {
        if (villager instanceof VillagerLike) {
            VillagerLike v = (VillagerLike)villager;
            return v;
        }
        return CommonVillagerModel.getVillager(villager.level(), villager.getUUID());
    }

    public ModelPart getBreastPart();

    public ModelPart getBodyPart();

    public Iterable<ModelPart> getCommonHeadParts();

    public Iterable<ModelPart> getCommonBodyParts();

    public Iterable<ModelPart> getBreastParts();

    public VillagerDimensions.Mutable getDimensions();

    public float getBreastSize();

    public void setBreastSize(float var1);

    default public void renderCommon(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        float breastSize;
        float headSize = this.getDimensions().getHead();
        matrices.pushPose();
        matrices.scale(headSize, headSize, headSize);
        this.getCommonHeadParts().forEach(a -> a.render(matrices, vertices, light, overlay, color));
        matrices.popPose();
        this.getCommonBodyParts().forEach(a -> a.render(matrices, vertices, light, overlay, color));
        if (this.getBreastPart().visible && this.getBodyPart().visible && (breastSize = this.getBreastSize() * this.getDimensions().getBreasts()) > 0.0f) {
            matrices.pushPose();
            matrices.scale(breastSize * 0.2f + 1.05f, breastSize * 0.75f + 0.75f, breastSize * 0.75f + 0.75f);
            for (ModelPart part : this.getBreastParts()) {
                part.render(matrices, vertices, light, overlay, color);
            }
            matrices.popPose();
        }
    }

    default public void applyVillagerDimensions(VillagerLike<?> villager, boolean isSneaking) {
        this.getDimensions().set(villager.getVillagerDimensions());
        this.setBreastSize(villager.getGenetics().getBreastSize());
        this.getBreastPart().visible = villager.getGenetics().getGender() == Gender.FEMALE;
        for (ModelPart part : this.getBreastParts()) {
            part.xRot = 0.9424779f + this.getBodyPart().xRot;
            float cy = 0.0f;
            float cz = 0.0f;
            if (isSneaking) {
                cy = 3.0f;
                cz = 1.5f;
            }
            part.setPos(0.25f, (float)(5.0 - Math.pow(this.getBreastSize(), 0.5) * 2.5 + (double)cy), -1.5f + this.getBreastSize() * 0.25f + cz);
        }
    }

    default public void copyCommonAttributes(CommonVillagerModel<T> target) {
        target.getDimensions().set(this.getDimensions());
        target.setBreastSize(this.getBreastSize());
    }
}

