/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.conczin.mca.Config;
import net.conczin.mca.client.gui.VillagerEditorScreen;
import net.conczin.mca.client.model.VillagerEntityBaseModelMCA;
import net.conczin.mca.client.model.VillagerEntityModelMCA;
import net.conczin.mca.entity.Infectable;
import net.conczin.mca.entity.VillagerLike;
import net.conczin.mca.entity.ai.relationship.AgeState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class VillagerLikeEntityMCARenderer<T extends Mob>
extends HumanoidMobRenderer<T, VillagerEntityModelMCA<T>> {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"textures/entity/steve.png");

    public VillagerLikeEntityMCARenderer(EntityRendererProvider.Context ctx, VillagerEntityModelMCA<T> model) {
        super(ctx, model, 0.5f);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, this.createArmorModel(0.3f), this.createArmorModel(0.55f), ctx.getModelManager()));
    }

    private VillagerEntityBaseModelMCA<T> createArmorModel(float modelSize) {
        return new VillagerEntityBaseModelMCA(LayerDefinition.create((MeshDefinition)VillagerEntityBaseModelMCA.getModelData(new CubeDeformation(modelSize)), (int)64, (int)32).bakeRoot());
    }

    protected void scale(T villager, PoseStack matrices, float tickDelta) {
        float height = ((VillagerLike)villager).getRawVerticalScaleFactor();
        float width = ((VillagerLike)villager).getRawHorizontalScaleFactor();
        matrices.scale(width, height, width);
        if (((VillagerLike)villager).getAgeState() == AgeState.BABY && !villager.isPassenger()) {
            matrices.translate(0.0f, 0.6f, 0.0f);
        }
    }

    @Nullable
    protected RenderType getRenderType(T entity, boolean showBody, boolean translucent, boolean showOutlines) {
        return null;
    }

    protected boolean shouldShowName(T villager) {
        LocalPlayer player = Minecraft.getInstance().player;
        return villager.getCustomName() != null && !(Minecraft.getInstance().screen instanceof VillagerEditorScreen) && player != null && Config.getInstance().showNameTags && player.distanceToSqr(villager) < Math.pow(Config.getInstance().nameTagDistance, 2.0) && !villager.isInvisibleTo((Player)player);
    }

    public ResourceLocation getTextureLocation(T mobEntity) {
        return TEXTURE;
    }

    protected boolean isShaking(T entity) {
        return ((Infectable)entity).getInfectionProgress() > 0.2f;
    }
}

