/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity;

import java.util.Arrays;
import net.conczin.mca.MCA;
import net.conczin.mca.entity.CribWoodType;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.relationship.AgeState;
import net.conczin.mca.item.BabyItem;
import net.conczin.mca.item.CribItem;
import net.conczin.mca.registry.ItemsMCA;
import net.conczin.mca.util.network.datasync.CDataManager;
import net.conczin.mca.util.network.datasync.CDataParameter;
import net.conczin.mca.util.network.datasync.CEnumParameter;
import net.conczin.mca.util.network.datasync.CParameter;
import net.conczin.mca.util.network.datasync.CTrackedEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class CribEntity
extends Entity
implements CTrackedEntity<CribEntity> {
    private static final CDataParameter<ItemStack> BABY = CParameter.create("BabyItem", ItemStack.EMPTY);
    private static final CEnumParameter<CribWoodType> WOOD = CParameter.create("Wood", CribWoodType.OAK);
    private static final CEnumParameter<DyeColor> COLOR = CParameter.create("Color", DyeColor.RED);
    private static final CDataManager<CribEntity> DATA = CribEntity.createTrackedData().build();
    VillagerEntityMCA infant;

    public CribEntity(EntityType<? extends CribEntity> type, Level world) {
        super(type, world);
    }

    static CDataManager.Builder<CribEntity> createTrackedData() {
        return new CDataManager.Builder<CribEntity>(CribEntity.class).addAll(BABY, WOOD, COLOR);
    }

    public CribWoodType getWoodType() {
        return (CribWoodType)((Object)this.getTrackedValue(WOOD));
    }

    public void setWoodType(CribWoodType wood) {
        this.setTrackedValue(WOOD, (Object)wood);
    }

    public DyeColor getColor() {
        return (DyeColor)this.getTrackedValue(COLOR);
    }

    public void setColor(DyeColor color) {
        this.setTrackedValue(COLOR, color);
    }

    public ItemStack getBabyItem() {
        return (ItemStack)this.getTrackedValue(BABY);
    }

    private boolean isOccupied() {
        return !((ItemStack)this.getTrackedValue(BABY)).equals(ItemStack.EMPTY) || this.infant != null;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        this.getTypeDataManager().register(builder);
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        if (nbt.contains("Baby")) {
            this.setTrackedValue(BABY, ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)nbt.getCompound("Baby")));
            if (((ItemStack)this.getTrackedValue(BABY)).equals(ItemStack.EMPTY)) {
                MCA.LOGGER.warn("Issue deserializing baby item from crib NBT!");
            }
        }
        if (nbt.contains("Wood")) {
            this.setTrackedValue(WOOD, (Object)CribWoodType.values()[nbt.getInt("Wood")]);
        }
        if (nbt.contains("Color")) {
            this.setTrackedValue(COLOR, DyeColor.values()[nbt.getInt("Color")]);
        }
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        if (!((ItemStack)this.getTrackedValue(BABY)).equals(ItemStack.EMPTY)) {
            Tag babyCompound = ((ItemStack)this.getTrackedValue(BABY)).save((HolderLookup.Provider)this.level().registryAccess(), (Tag)new CompoundTag());
            nbt.put("Baby", babyCompound);
        }
        nbt.putInt("Wood", Arrays.asList(CribWoodType.values()).indexOf(this.getTrackedValue(WOOD)));
        nbt.putInt("Color", Arrays.asList(DyeColor.values()).indexOf(this.getTrackedValue(COLOR)));
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float partialTick) {
        return new Vec3(0.0, 0.1, 0.0);
    }

    private void setEntityOccupant(VillagerEntityMCA occupant) {
        this.infant = occupant;
        this.infant.setInvulnerable(true);
    }

    private void unsetEntityOccupant() {
        if (this.infant != null) {
            this.infant.setInvulnerable(false);
            this.infant = null;
        }
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        Entity entity;
        if (this.isVehicle() && this.getFirstPassenger() instanceof VillagerEntityMCA && this.infant == null) {
            this.setEntityOccupant((VillagerEntityMCA)this.getFirstPassenger());
        }
        if (this.infant != null && this.infant.getVehicle() == this) {
            this.infant.startRiding((Entity)player, true);
            this.unsetEntityOccupant();
        } else if (!((ItemStack)this.getTrackedValue(BABY)).equals(ItemStack.EMPTY)) {
            player.getInventory().add((ItemStack)this.getTrackedValue(BABY));
            this.setTrackedValue(BABY, ItemStack.EMPTY);
        } else if (player.getInventory().getSelected() != ItemStack.EMPTY && player.getInventory().getSelected().getItem() instanceof BabyItem) {
            this.setTrackedValue(BABY, player.getInventory().getSelected());
            player.getInventory().removeItem((ItemStack)this.getTrackedValue(BABY));
        } else if (player.getFirstPassenger() != null && (entity = player.getFirstPassenger()) instanceof VillagerEntityMCA) {
            VillagerEntityMCA rider = (VillagerEntityMCA)entity;
            if (rider.getAgeState() == AgeState.BABY) {
                this.setEntityOccupant(rider);
                this.infant.startRiding(this, true);
            }
        } else {
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean skipAttackInteraction(Entity attacker) {
        return attacker instanceof Player && !this.level().mayInteract((Player)attacker, this.blockPosition());
    }

    public boolean isPickable() {
        return true;
    }

    public void tick() {
        super.tick();
        if (this.onGround()) {
            this.setDeltaMovement(Vec3.ZERO);
        } else if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (this.getTrackedValue(BABY) != ItemStack.EMPTY && ((ItemStack)this.getTrackedValue(BABY)).getItem() instanceof BabyItem) {
            ((ItemStack)this.getTrackedValue(BABY)).getItem().inventoryTick((ItemStack)this.getTrackedValue(BABY), this.level(), (Entity)this, 0, false);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.level().isClientSide || this.isRemoved()) {
            return false;
        }
        if (this.isOccupied()) {
            return false;
        }
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (source.is(DamageTypeTags.IS_EXPLOSION) || source.is(DamageTypeTags.IS_FIRE)) {
            this.kill();
            return false;
        }
        boolean bl = source.getDirectEntity() instanceof AbstractArrow;
        boolean bl2 = bl && ((AbstractArrow)source.getDirectEntity()).getPierceLevel() > 0;
        boolean bl3 = "player".equals(source.getMsgId());
        if (!bl3 && !bl) {
            return false;
        }
        if (source.getEntity() instanceof Player && !((Player)source.getEntity()).getAbilities().mayBuild) {
            return false;
        }
        if (source.isCreativePlayer()) {
            this.playBreakSound();
            this.spawnBreakParticles();
            this.kill();
            return bl2;
        }
        CribItem matchingType = ItemsMCA.CRIBS.stream().filter(c -> c.getColor() == this.getTrackedValue(COLOR) && c.getWood() == this.getTrackedValue(WOOD)).findFirst().get();
        Block.popResource((Level)this.level(), (BlockPos)this.blockPosition(), (ItemStack)new ItemStack((ItemLike)matchingType));
        this.spawnBreakParticles();
        this.kill();
        return true;
    }

    private void spawnBreakParticles() {
        if (this.level() instanceof ServerLevel) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.OAK_PLANKS.defaultBlockState()), this.getX(), this.getY(0.6666666666666666), this.getZ(), 10, (double)(this.getBbWidth() / 4.0f), (double)(this.getBbHeight() / 4.0f), (double)(this.getBbWidth() / 4.0f), 0.05);
        }
    }

    private void playBreakSound() {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ARMOR_STAND_BREAK, this.getSoundSource(), 1.0f, 1.0f);
    }

    @Override
    public CDataManager<CribEntity> getTypeDataManager() {
        return DATA;
    }
}

