/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity;

import net.conczin.mca.Config;
import net.conczin.mca.entity.ReaperAttackState;
import net.conczin.mca.entity.ai.goal.GrimReaperIdleGoal;
import net.conczin.mca.entity.ai.goal.GrimReaperMeleeGoal;
import net.conczin.mca.entity.ai.goal.GrimReaperRestGoal;
import net.conczin.mca.entity.ai.goal.GrimReaperTargetGoal;
import net.conczin.mca.registry.ItemsMCA;
import net.conczin.mca.registry.SoundsMCA;
import net.conczin.mca.util.network.datasync.CDataManager;
import net.conczin.mca.util.network.datasync.CEnumParameter;
import net.conczin.mca.util.network.datasync.CParameter;
import net.conczin.mca.util.network.datasync.CTrackedEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GrimReaperEntity
extends PathfinderMob
implements CTrackedEntity<GrimReaperEntity> {
    public static final CEnumParameter<ReaperAttackState> ATTACK_STAGE = CParameter.create("AttackStage", ReaperAttackState.IDLE);
    public static final CDataManager<GrimReaperEntity> DATA = new CDataManager.Builder<GrimReaperEntity>(GrimReaperEntity.class).addAll(ATTACK_STAGE).build();
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);

    public GrimReaperEntity(EntityType<? extends GrimReaperEntity> type, Level world) {
        super(type, world);
        this.xpReward = 100;
        this.moveControl = new FlyingMoveControl((Mob)this, 10, false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.MAX_HEALTH, 300.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.FLYING_SPEED, (double)0.3f).add(Attributes.FOLLOW_RANGE, 40.0);
    }

    @Override
    public CDataManager<GrimReaperEntity> getTypeDataManager() {
        return DATA;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.getTypeDataManager().register(builder);
    }

    public boolean isNoGravity() {
        return true;
    }

    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    public EntityType<?> getType() {
        return super.getType();
    }

    protected void registerGoals() {
        this.targetSelector.addGoal(1, (Goal)new GrimReaperTargetGoal(this));
        this.goalSelector.addGoal(0, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 24.0f, 1.0f));
        this.goalSelector.addGoal(1, (Goal)new GrimReaperRestGoal(this));
        this.goalSelector.addGoal(2, (Goal)new GrimReaperMeleeGoal(this));
        this.goalSelector.addGoal(3, (Goal)new GrimReaperIdleGoal(this, 1.0));
    }

    public MoveControl getMoveControl() {
        return this.moveControl;
    }

    public void checkDespawn() {
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && this.shouldDespawnInPeaceful()) {
            this.discard();
        }
    }

    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    protected PathNavigation createNavigation(Level world) {
        FlyingPathNavigation navigator = new FlyingPathNavigation(this, (Mob)this, world){

            public boolean isStableDestination(BlockPos pos) {
                return true;
            }
        };
        navigator.setCanOpenDoors(false);
        navigator.setCanFloat(false);
        navigator.setCanPassDoors(true);
        return navigator;
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource damageSource, boolean recentlyHit) {
        super.dropCustomDeathLoot(level, damageSource, recentlyHit);
        ItemEntity itemEntity = this.spawnAtLocation((ItemLike)ItemsMCA.SCYTHE);
        if (itemEntity != null) {
            itemEntity.setExtendedLifetime();
        }
    }

    public ReaperAttackState getAttackState() {
        return (ReaperAttackState)((Object)this.getTrackedValue(ATTACK_STAGE));
    }

    public void setAttackState(ReaperAttackState state) {
        if (this.getAttackState() == state) {
            return;
        }
        this.setTrackedValue(ATTACK_STAGE, (Object)state);
        switch (state) {
            case PRE: {
                this.playSound(SoundsMCA.REAPER_SCYTHE_OUT, 1.0f, 1.0f);
                break;
            }
            case POST: {
                this.playSound(SoundsMCA.REAPER_SCYTHE_SWING, 1.0f, 1.0f);
            }
        }
    }

    public boolean hurt(DamageSource source, float damage) {
        if (source.is(DamageTypes.IN_WALL) || source.is(DamageTypes.ON_FIRE) || source.is(DamageTypes.EXPLOSION) || source.is(DamageTypes.IN_FIRE)) {
            if (source.is(DamageTypes.IN_WALL)) {
                this.teleportTo(this.getX(), this.getY() + 3.0, this.getZ());
            }
            return false;
        }
        Entity entity = source.getDirectEntity();
        Entity attacker = source.getEntity();
        if (this.getAttackState() == ReaperAttackState.BLOCK && attacker != null) {
            this.playSound(SoundsMCA.REAPER_BLOCK, 1.0f, 1.0f);
            return false;
        }
        if (entity instanceof Projectile && this.getAttackState() != ReaperAttackState.REST && attacker != null && this.random.nextBoolean()) {
            double newX = attacker.getX() + (double)(this.random.nextFloat() >= 0.5f ? 4 : -4);
            double newZ = attacker.getZ() + (double)(this.random.nextFloat() >= 0.5f ? 4 : -4);
            this.teleportTo(newX, attacker.getY(), newZ);
            return false;
        }
        if (!this.level().isClientSide && this.random.nextFloat() >= 0.3f && attacker != null) {
            double deltaX = this.getX() - attacker.getX();
            double deltaZ = this.getZ() - attacker.getZ();
            double distance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            double length = Math.max(5.0, distance) / distance * 0.95;
            this.teleportTo(attacker.getX() - deltaX * length, attacker.getY() + 1.5, attacker.getZ() - deltaZ * length);
        }
        if (this.getAttackState() == ReaperAttackState.REST) {
            damage *= 0.25f;
        }
        return super.hurt(source, damage);
    }

    protected SoundEvent getAmbientSound() {
        return SoundsMCA.REAPER_IDLE;
    }

    protected SoundEvent getDeathSound() {
        return SoundsMCA.REAPER_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.WITHER_HURT;
    }

    public void tick() {
        super.tick();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
        if (!Config.getInstance().allowGrimReaper) {
            this.discard();
        }
        if (this.getHealth() <= 0.0f) {
            this.setDeltaMovement(Vec3.ZERO);
            return;
        }
        LivingEntity entityToAttack = this.getTarget();
        if (entityToAttack != null && entityToAttack.isDeadOrDying()) {
            this.setTarget(null);
            this.setAttackState(ReaperAttackState.IDLE);
        }
        this.fallDistance = 0.0f;
    }

    public void teleportTo(double x, double y, double z) {
        if (this.level() instanceof ServerLevel) {
            this.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
            super.teleportTo(x, y, z);
            this.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
        }
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }
}

