/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import net.conczin.mca.Config;
import net.conczin.mca.MCA;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.Memories;
import net.conczin.mca.entity.ai.Pregnancy;
import net.conczin.mca.entity.ai.Relationship;
import net.conczin.mca.entity.interaction.gifts.GiftType;
import net.conczin.mca.entity.interaction.gifts.Response;
import net.conczin.mca.item.SpecialCaseGift;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.s2c.AnalysisResults;
import net.conczin.mca.registry.CriterionMCA;
import net.conczin.mca.resources.data.Analysis;
import net.conczin.mca.util.InventoryUtils;
import net.conczin.mca.util.network.datasync.CDataManager;
import net.conczin.mca.util.network.datasync.CDataParameter;
import net.conczin.mca.util.network.datasync.CParameter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;

public class BreedableRelationship
extends Relationship<VillagerEntityMCA> {
    private static final CDataParameter<Boolean> IS_PROCREATING = CParameter.create("IsProcreating", false);
    private static final CDataParameter<Integer> LAST_PROCREATION = CParameter.create("LastProcreation", 0);
    private final Pregnancy pregnancy;
    private int procreateTick = -1;

    public BreedableRelationship(VillagerEntityMCA entity) {
        super(entity);
        this.pregnancy = new Pregnancy(entity);
    }

    public static <E extends Entity> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return Relationship.createTrackedData(builder).addAll(IS_PROCREATING, LAST_PROCREATION).add(Pregnancy::createTrackedData);
    }

    public Pregnancy getPregnancy() {
        return this.pregnancy;
    }

    public boolean isProcreating() {
        return (Boolean)((VillagerEntityMCA)this.entity).getTrackedValue(IS_PROCREATING);
    }

    public boolean mayProcreateAgain(long time) {
        int intTime = (int)time;
        Integer trackedValue = (Integer)((VillagerEntityMCA)this.entity).getTrackedValue(LAST_PROCREATION);
        int delta = intTime - trackedValue;
        return trackedValue == 0 || delta < 0 || delta > Config.getInstance().procreationCooldown;
    }

    public void startProcreating(long time) {
        this.procreateTick = 60;
        ((VillagerEntityMCA)this.entity).setTrackedValue(IS_PROCREATING, true);
        ((VillagerEntityMCA)this.entity).setTrackedValue(LAST_PROCREATION, (int)time);
    }

    public void tick(int age) {
        if (age % 20 == 0) {
            this.pregnancy.tick();
        }
        if (!this.isProcreating()) {
            return;
        }
        if (this.procreateTick > 0) {
            --this.procreateTick;
            ((VillagerEntityMCA)this.entity).getNavigation().stop();
            ((VillagerEntityMCA)this.entity).level().broadcastEntityEvent((Entity)this.entity, (byte)12);
        } else {
            this.getFamilyTree().getOrCreate((Entity)this.entity);
            this.getPartner().ifPresent(spouse -> {
                this.pregnancy.procreate((Entity)spouse);
                ((VillagerEntityMCA)this.entity).setTrackedValue(IS_PROCREATING, false);
            });
        }
    }

    public void giveGift(ServerPlayer player, Memories memory) {
        ItemStack stack = player.getMainHandItem();
        if (!stack.isEmpty() && !this.handleSpecialCaseGift(player, stack)) {
            Optional<GiftType> gift = GiftType.bestMatching((VillagerEntityMCA)this.entity, stack, player);
            if (gift.isPresent()) {
                this.acceptGift(stack, gift.get(), player, memory);
            } else {
                gift = this.handleDynamicGift(stack);
                if (gift.isPresent()) {
                    this.acceptGift(stack, gift.get(), player, memory);
                } else {
                    this.rejectGift((Player)player, "gift.fail");
                }
            }
        }
    }

    private Optional<GiftType> handleDynamicGift(ItemStack stack) {
        Item item = stack.getItem();
        Objects.requireNonNull(item);
        Item item2 = item;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SwordItem.class, ProjectileWeaponItem.class, TieredItem.class, ArmorItem.class}, (Object)item2, n)) {
            case 0: {
                SwordItem ignored = (SwordItem)item2;
                double satisfaction = InventoryUtils.approximateDamage(stack, (LivingEntity)this.entity);
                satisfaction = (float)(Math.pow(satisfaction, 1.25) * 2.0);
                return Optional.of(new GiftType(stack.getItem(), (int)satisfaction, MCA.locate("swords")));
            }
            case 1: {
                ProjectileWeaponItem ranged = (ProjectileWeaponItem)item2;
                float satisfaction = ranged.getDefaultProjectileRange();
                satisfaction = (float)(Math.pow(satisfaction, 1.25) * 2.0);
                return Optional.of(new GiftType(stack.getItem(), (int)satisfaction, MCA.locate("archery")));
            }
            case 2: {
                TieredItem tool = (TieredItem)item2;
                float satisfaction = tool.getTier().getSpeed();
                satisfaction = (float)(Math.pow(satisfaction, 1.25) * 2.0);
                return Optional.of(new GiftType(stack.getItem(), (int)satisfaction, MCA.locate(stack.getItem() instanceof AxeItem ? "swords" : (stack.getItem() instanceof HoeItem ? "hoes" : (stack.getItem() instanceof ShovelItem ? "shovels" : "pickaxes")))));
            }
            case 3: {
                ArmorItem armor = (ArmorItem)item2;
                int satisfaction = (int)(Math.pow(armor.getDefense(), 1.25) * 1.5 + (double)(armor.getToughness() * 5.0f));
                return Optional.of(new GiftType(stack.getItem(), satisfaction, MCA.locate("armor")));
            }
        }
        FoodProperties component = (FoodProperties)stack.get(DataComponents.FOOD);
        if (component != null) {
            int satisfaction = (int)((float)component.nutrition() + component.saturation() * 3.0f);
            return Optional.of(new GiftType(stack.getItem(), satisfaction, MCA.locate("food")));
        }
        return Optional.empty();
    }

    private void acceptGift(ItemStack stack, GiftType gift, ServerPlayer player, Memories memory) {
        if (!((VillagerEntityMCA)this.entity).getInventory().canAddItem(stack)) {
            this.rejectGift((Player)player, "villager.inventory.full");
            return;
        }
        Analysis analysis = gift.getSatisfactionFor((VillagerEntityMCA)this.entity, stack, player);
        int satisfaction = analysis.getTotal();
        Response response = gift.getResponse(satisfaction);
        int occurrences = this.getGiftSaturation().get(stack);
        int penalty = (int)((double)((float)occurrences * Config.getInstance().giftDesaturationFactor) * Math.pow(Math.max((double)satisfaction, 0.0), Config.getInstance().giftDesaturationExponent));
        if (penalty != 0) {
            analysis.add("desaturation", -penalty);
        }
        int desaturatedSatisfaction = analysis.getTotal();
        Response desaturatedResponse = gift.getResponse(desaturatedSatisfaction);
        desaturatedSatisfaction = (int)((double)desaturatedSatisfaction * Config.getInstance().giftSatisfactionFactor);
        Network.sendToPlayer(new AnalysisResults(analysis), player);
        if (response == Response.FAIL) {
            this.rejectGift((Player)player, gift.getDialogueFor(response));
        } else if (desaturatedResponse == Response.FAIL) {
            this.rejectGift((Player)player, "gift.saturated");
        } else {
            ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, gift.getDialogueFor(response), new Object[0]);
            if (response == Response.BEST) {
                ((VillagerEntityMCA)this.entity).playSurprisedSound();
            }
            this.getGiftSaturation().add(stack);
            ((VillagerEntityMCA)this.entity).level().broadcastEntityEvent((Entity)this.entity, (byte)16);
            ((VillagerEntityMCA)this.entity).getInventory().addItem(stack.split(1));
        }
        ((VillagerEntityMCA)this.entity).getVillagerBrain().modifyMoodValue((int)((float)desaturatedSatisfaction * Config.getInstance().giftMoodEffect + Config.getInstance().baseGiftMoodEffect * (float)Mth.sign((double)desaturatedSatisfaction)));
        CriterionMCA.HEARTS.trigger(player, memory.getHearts(), desaturatedSatisfaction, "gift");
        memory.modHearts(desaturatedSatisfaction);
    }

    private void rejectGift(Player player, String dialogue) {
        ((VillagerEntityMCA)this.entity).level().broadcastEntityEvent((Entity)this.entity, (byte)15);
        ((VillagerEntityMCA)this.entity).sendChatMessage(player, dialogue, new Object[0]);
    }

    private boolean handleSpecialCaseGift(ServerPlayer player, ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof SpecialCaseGift) {
            if (((SpecialCaseGift)item).handle(player, (VillagerEntityMCA)this.entity)) {
                stack.shrink(1);
            }
            return true;
        }
        if (item == Items.CAKE && !((VillagerEntityMCA)this.entity).isBaby()) {
            if (this.pregnancy.tryStartGestation()) {
                player.level().broadcastEntityEvent((Entity)this.entity, (byte)12);
                stack.shrink(1);
                ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "gift.cake.success", new Object[0]);
            } else {
                ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "gift.cake.fail", new Object[0]);
            }
            return true;
        }
        if (item == Items.GOLDEN_APPLE && ((VillagerEntityMCA)this.entity).isInfected()) {
            ((VillagerEntityMCA)this.entity).setInfected(false);
            ((VillagerEntityMCA)this.entity).eat(((VillagerEntityMCA)this.entity).level(), stack);
            stack.shrink(1);
            return true;
        }
        if (item instanceof DyeItem) {
            DyeItem dye = (DyeItem)item;
            ((VillagerEntityMCA)this.entity).setHairDye(dye.getDyeColor());
            stack.shrink(1);
            return true;
        }
        if (item == Items.WET_SPONGE) {
            ((VillagerEntityMCA)this.entity).clearHairDye();
            stack.shrink(1);
            return true;
        }
        if (item == Items.GOLDEN_APPLE && ((VillagerEntityMCA)this.entity).isBaby()) {
            ((VillagerEntityMCA)this.entity).ageUp(24000);
            stack.shrink(1);
            return true;
        }
        return false;
    }
}

