/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;

public class LongTermMemory {
    final HashMap<String, Long> memories = new HashMap();
    private final VillagerEntityMCA entity;

    public LongTermMemory(VillagerEntityMCA entity) {
        this.entity = entity;
    }

    public static String parseId(JsonObject json, ServerPlayer player) {
        Object id = json.get("id").getAsString();
        if (json.has("var")) {
            switch (json.get("var").getAsString()) {
                case "player": {
                    assert (player != null);
                    id = (String)id + "." + String.valueOf(player.getUUID());
                }
            }
        }
        return id;
    }

    public void writeToNbt(CompoundTag nbt) {
        CompoundTag memory = new CompoundTag();
        for (Map.Entry<String, Long> entry : this.memories.entrySet()) {
            memory.putLong(entry.getKey(), entry.getValue().longValue());
        }
        nbt.put("longTermMemory", (Tag)memory);
    }

    public void readFromNbt(CompoundTag nbt) {
        CompoundTag memory = nbt.getCompound("longTermMemory");
        this.memories.clear();
        for (String key : memory.getAllKeys()) {
            this.memories.put(key, memory.getLong(key));
        }
    }

    public void remember(String id) {
        this.remember(id, Integer.MAX_VALUE);
    }

    public void remember(String id, long time) {
        long currentTime = this.entity.level().getGameTime();
        if (this.memories.containsKey(id)) {
            currentTime = Math.max(currentTime, this.memories.get(id));
        }
        this.memories.put(id, currentTime + time);
    }

    public long getMemory(String id) {
        if (this.memories.containsKey(id)) {
            if (this.entity.level().getGameTime() > this.memories.get(id)) {
                this.memories.remove(id);
            } else {
                return this.memories.get(id) - this.entity.level().getGameTime();
            }
        }
        return 0L;
    }

    public boolean hasMemory(String id) {
        return this.getMemory(id) > 0L;
    }
}

