/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai;

import java.util.Objects;
import java.util.Optional;
import net.conczin.mca.Config;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.relationship.AgeState;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.conczin.mca.item.BabyItem;
import net.conczin.mca.registry.CriterionMCA;
import net.conczin.mca.server.world.data.Village;
import net.conczin.mca.util.WorldUtils;
import net.conczin.mca.util.network.datasync.CDataManager;
import net.conczin.mca.util.network.datasync.CDataParameter;
import net.conczin.mca.util.network.datasync.CParameter;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class Pregnancy {
    private static final CDataParameter<Boolean> HAS_BABY = CParameter.create("HasBaby", false);
    private static final CDataParameter<Boolean> IS_BABY_MALE = CParameter.create("IsBabyMale", false);
    private static final CDataParameter<Integer> BABY_AGE = CParameter.create("BabyAge", 0);
    private final VillagerEntityMCA mother;

    Pregnancy(VillagerEntityMCA entity) {
        this.mother = entity;
    }

    public static <E extends Entity> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return builder.addAll(HAS_BABY, IS_BABY_MALE, BABY_AGE);
    }

    public boolean isPregnant() {
        return (Boolean)this.mother.getTrackedValue(HAS_BABY);
    }

    public void setPregnant(boolean pregnant) {
        this.mother.setTrackedValue(HAS_BABY, pregnant);
    }

    public int getBabyAge() {
        return (Integer)this.mother.getTrackedValue(BABY_AGE);
    }

    public void setBabyAge(int age) {
        this.mother.setTrackedValue(BABY_AGE, age);
    }

    public Gender getGender() {
        return (Boolean)this.mother.getTrackedValue(IS_BABY_MALE) != false ? Gender.MALE : Gender.FEMALE;
    }

    public void tick() {
        if (!this.isPregnant()) {
            return;
        }
        this.setBabyAge(this.getBabyAge() + 60);
        if (this.getBabyAge() < Config.getInstance().babyItemGrowUpTime) {
            return;
        }
        this.setBabyAge(0);
        this.getFather().ifPresent(father -> {
            this.setPregnant(false);
            VillagerEntityMCA child = this.createChild(this.getGender(), (VillagerEntityMCA)father);
            child.setPos(this.mother.getX(), this.mother.getY(), this.mother.getZ());
            WorldUtils.spawnEntity(this.mother.level(), (Mob)child, MobSpawnType.BREEDING);
        });
    }

    public boolean tryStartGestation() {
        if (this.isPregnant()) {
            return false;
        }
        return this.getFather().map(father -> {
            if (this.mother.getGenetics().getGender() == Gender.MALE && father.getGenetics().getGender() != Gender.MALE) {
                return father.getRelationships().getPregnancy().tryStartGestation();
            }
            this.setPregnant(true);
            this.mother.setTrackedValue(IS_BABY_MALE, this.mother.level().random.nextBoolean());
            return true;
        }).orElse(false);
    }

    public VillagerEntityMCA createChild(Gender gender, VillagerEntityMCA partner) {
        VillagerEntityMCA child = Objects.requireNonNull((VillagerEntityMCA)gender.getVillagerType().create(this.mother.level()));
        child.getGenetics().combine(partner.getGenetics(), this.mother.getGenetics());
        child.getTraits().inherit(partner.getTraits());
        child.getTraits().inherit(this.mother.getTraits());
        child.setBaby(true);
        child.setAgeState(AgeState.TODDLER);
        child.getRelationships().getFamilyEntry().assignParents(this.mother.getRelationships(), partner.getRelationships());
        child.getRelationships().getFamily(2, 0).filter(ServerPlayer.class::isInstance).map(ServerPlayer.class::cast).forEach(CriterionMCA.FAMILY::trigger);
        this.mother.getResidency().getHomeVillage().flatMap(Village::getCivilRegistry).ifPresent(r -> r.addText((Component)Component.translatable((String)"events.baby", (Object[])new Object[]{this.mother.getName(), partner.getName()})));
        return child;
    }

    public VillagerEntityMCA createChild(Gender gender) {
        return this.createChild(gender, this.mother);
    }

    private Optional<VillagerEntityMCA> getFather() {
        return this.mother.getRelationships().getPartner().filter(VillagerEntityMCA.class::isInstance).map(VillagerEntityMCA.class::cast);
    }

    public void procreate(Entity spouse) {
        int count;
        RandomSource random = this.mother.getRandom();
        for (count = 1; random.nextFloat() < Config.getInstance().twinBabyChance && count < 8; ++count) {
        }
        if (spouse instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)spouse;
            CriterionMCA.BABY.trigger(player, count);
        }
        long seed = random.nextLong();
        for (int i = 0; i < count; ++i) {
            Player player;
            boolean flip = this.mother.getGenetics().getGender() == Gender.MALE;
            ItemStack stack = BabyItem.createItem((Entity)(flip ? spouse : this.mother), (Entity)(flip ? this.mother : spouse), seed);
            if (spouse instanceof Player && (player = (Player)spouse).addItem(stack)) continue;
            this.mother.getInventory().addItem(stack);
        }
    }
}

