/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.brain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.conczin.mca.Config;
import net.conczin.mca.entity.EquipmentSet;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.ActivitiesMCA;
import net.conczin.mca.entity.ai.MemoryModuleTypeMCA;
import net.conczin.mca.entity.ai.SchedulesMCA;
import net.conczin.mca.entity.ai.SensorsMCA;
import net.conczin.mca.entity.ai.brain.tasks.BowTask;
import net.conczin.mca.entity.ai.brain.tasks.ConditionalSingleTickTask;
import net.conczin.mca.entity.ai.brain.tasks.ConditionalTask;
import net.conczin.mca.entity.ai.brain.tasks.DeliverMessageTask;
import net.conczin.mca.entity.ai.brain.tasks.EnterBuildingTask;
import net.conczin.mca.entity.ai.brain.tasks.EnterFavoredBuildingTask;
import net.conczin.mca.entity.ai.brain.tasks.EquipmentTask;
import net.conczin.mca.entity.ai.brain.tasks.ExtendedFindPointOfInterestTask;
import net.conczin.mca.entity.ai.brain.tasks.ExtendedForgetCompletedPointOfInterestTask;
import net.conczin.mca.entity.ai.brain.tasks.ExtendedMeleeAttackTask;
import net.conczin.mca.entity.ai.brain.tasks.ExtendedWalkTowardsTask;
import net.conczin.mca.entity.ai.brain.tasks.FollowTask;
import net.conczin.mca.entity.ai.brain.tasks.GreetPlayerTask;
import net.conczin.mca.entity.ai.brain.tasks.GrieveTask;
import net.conczin.mca.entity.ai.brain.tasks.HoldItemTask;
import net.conczin.mca.entity.ai.brain.tasks.InteractTask;
import net.conczin.mca.entity.ai.brain.tasks.LambdaTask;
import net.conczin.mca.entity.ai.brain.tasks.LazyFindPointOfInterestTask;
import net.conczin.mca.entity.ai.brain.tasks.LoseUnimportantJobTask;
import net.conczin.mca.entity.ai.brain.tasks.PatrolVillageTask;
import net.conczin.mca.entity.ai.brain.tasks.SayTask;
import net.conczin.mca.entity.ai.brain.tasks.SequenceTask;
import net.conczin.mca.entity.ai.brain.tasks.SmarterOpenDoorsTask;
import net.conczin.mca.entity.ai.brain.tasks.StayTask;
import net.conczin.mca.entity.ai.brain.tasks.WanderOrTeleportToTargetTask;
import net.conczin.mca.entity.ai.brain.tasks.chore.ChoppingTask;
import net.conczin.mca.entity.ai.brain.tasks.chore.FishingTask;
import net.conczin.mca.entity.ai.brain.tasks.chore.HarvestingTask;
import net.conczin.mca.entity.ai.brain.tasks.chore.HuntingTask;
import net.conczin.mca.entity.ai.relationship.AgeState;
import net.conczin.mca.registry.EntitiesMCA;
import net.conczin.mca.registry.ProfessionsMCA;
import net.conczin.mca.server.world.data.VillageManager;
import net.conczin.mca.server.world.data.villageComponents.VillageGuardsManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AssignProfessionFromJobSite;
import net.minecraft.world.entity.ai.behavior.BackUpIfTooClose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.CelebrateVillagersSurvivedRaid;
import net.minecraft.world.entity.ai.behavior.CrossbowAttack;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.GiveGiftToHero;
import net.minecraft.world.entity.ai.behavior.GoToClosestVillage;
import net.minecraft.world.entity.ai.behavior.GoToPotentialJobSite;
import net.minecraft.world.entity.ai.behavior.GoToWantedItem;
import net.minecraft.world.entity.ai.behavior.HarvestFarmland;
import net.minecraft.world.entity.ai.behavior.InsideBrownianWalk;
import net.minecraft.world.entity.ai.behavior.InteractWith;
import net.minecraft.world.entity.ai.behavior.InteractWithDoor;
import net.minecraft.world.entity.ai.behavior.JumpOnBed;
import net.minecraft.world.entity.ai.behavior.LocateHidingPlace;
import net.minecraft.world.entity.ai.behavior.LookAndFollowTradingPlayerSink;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToSkySeeingSpot;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.PlayTagWithOtherKids;
import net.minecraft.world.entity.ai.behavior.PoiCompetitorScan;
import net.minecraft.world.entity.ai.behavior.ReactToBell;
import net.minecraft.world.entity.ai.behavior.ResetRaidStatus;
import net.minecraft.world.entity.ai.behavior.RingBell;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetClosestHomeAsWalkTarget;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetHiddenState;
import net.minecraft.world.entity.ai.behavior.SetLookAndInteract;
import net.minecraft.world.entity.ai.behavior.SetRaidStatus;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromBlockMemory;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.ShowTradesToPlayer;
import net.minecraft.world.entity.ai.behavior.SleepInBed;
import net.minecraft.world.entity.ai.behavior.SocializeAtBell;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.StrollAroundPoi;
import net.minecraft.world.entity.ai.behavior.StrollToPoi;
import net.minecraft.world.entity.ai.behavior.StrollToPoiList;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.TradeWithVillager;
import net.minecraft.world.entity.ai.behavior.UpdateActivityFromSchedule;
import net.minecraft.world.entity.ai.behavior.UseBonemeal;
import net.minecraft.world.entity.ai.behavior.ValidateNearbyPoi;
import net.minecraft.world.entity.ai.behavior.VillageBoundRandomStroll;
import net.minecraft.world.entity.ai.behavior.VillagerCalmDown;
import net.minecraft.world.entity.ai.behavior.VillagerPanicTrigger;
import net.minecraft.world.entity.ai.behavior.WakeUp;
import net.minecraft.world.entity.ai.behavior.WorkAtComposter;
import net.minecraft.world.entity.ai.behavior.WorkAtPoi;
import net.minecraft.world.entity.ai.behavior.YieldJobSite;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class VillagerTasksMCA {
    public static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.HOME, (Object)MemoryModuleType.JOB_SITE, (Object)MemoryModuleType.POTENTIAL_JOB_SITE, (Object)MemoryModuleType.MEETING_POINT, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.VISIBLE_VILLAGER_BABIES, (Object)MemoryModuleType.NEAREST_PLAYERS, (Object)MemoryModuleType.NEAREST_VISIBLE_PLAYER, (Object)MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, (Object)MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, (Object)MemoryModuleType.WALK_TARGET, (Object[])new MemoryModuleType[]{MemoryModuleType.LOOK_TARGET, MemoryModuleType.INTERACTION_TARGET, MemoryModuleType.BREED_TARGET, MemoryModuleType.PATH, MemoryModuleType.DOORS_TO_CLOSE, MemoryModuleType.NEAREST_BED, MemoryModuleType.HURT_BY, MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.NEAREST_HOSTILE, MemoryModuleType.SECONDARY_JOB_SITE, MemoryModuleType.HIDING_PLACE, MemoryModuleType.HEARD_BELL_TIME, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.LAST_SLEPT, MemoryModuleType.LAST_WOKEN, MemoryModuleType.LAST_WORKED_AT_POI, MemoryModuleType.GOLEM_DETECTED_RECENTLY, MemoryModuleType.ATTACK_TARGET, MemoryModuleType.ATTACK_COOLING_DOWN, MemoryModuleTypeMCA.PLAYER_FOLLOWING, MemoryModuleTypeMCA.STAYING, MemoryModuleTypeMCA.NEAREST_GUARD_ENEMY, MemoryModuleTypeMCA.WEARS_ARMOR, MemoryModuleTypeMCA.SMALL_BOUNTY, MemoryModuleTypeMCA.HIT_BY_PLAYER, MemoryModuleTypeMCA.LAST_GRIEVE, MemoryModuleTypeMCA.FORCED_HOME});
    public static final ImmutableList<SensorType<? extends Sensor<? super Villager>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.NEAREST_ITEMS, (Object)SensorType.NEAREST_BED, (Object)SensorType.HURT_BY, (Object)SensorType.VILLAGER_HOSTILES, (Object)SensorType.SECONDARY_POIS, (Object)SensorType.GOLEM_DETECTED, SensorsMCA.VILLAGER_BABIES, SensorsMCA.EXPLODING_CREEPER, SensorsMCA.GUARD_ENEMIES);

    public static Brain.Provider<VillagerEntityMCA> createProfile() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static Brain<VillagerEntityMCA> initializeTasks(VillagerEntityMCA villager, Brain<VillagerEntityMCA> brain) {
        VillagerProfession profession = villager.getVillagerData().getProfession();
        AgeState age = AgeState.byCurrentAge(villager.getAge());
        boolean noDefault = false;
        if (brain.getMemoryInternal(MemoryModuleTypeMCA.STAYING).isPresent()) {
            brain.addActivity(Activity.CORE, VillagerTasksMCA.getStayingPackage());
            brain.addActivity(Activity.CORE, VillagerTasksMCA.getImportantCorePackage(0.5f));
            brain.addActivity(Activity.CORE, VillagerTasksMCA.getSelfDefencePackage());
            brain.addActivity(Activity.PANIC, VillagerTasksMCA.getPanicPackage(0.5f));
            noDefault = true;
        } else if (brain.getMemoryInternal(MemoryModuleTypeMCA.PLAYER_FOLLOWING).isPresent()) {
            brain.addActivity(Activity.CORE, VillagerTasksMCA.getFollowingPackage());
            brain.addActivity(Activity.CORE, VillagerTasksMCA.getImportantCorePackage(0.5f));
            brain.addActivity(Activity.CORE, VillagerTasksMCA.getSelfDefencePackage());
            brain.addActivity(Activity.PANIC, VillagerTasksMCA.getPanicPackage(0.5f));
            noDefault = true;
        } else if (profession == ProfessionsMCA.MERCENARY) {
            brain.setSchedule(SchedulesMCA.GUESTS);
            brain.addActivity(Activity.CORE, VillagerTasksMCA.getImportantCorePackage(0.5f));
            brain.addActivity(Activity.IDLE, VillagerTasksMCA.getMercenaryPackage(0.5f));
            brain.addActivity(Activity.CORE, VillagerTasksMCA.getGuardCorePackage(villager));
            brain.addActivity(Activity.PANIC, VillagerTasksMCA.getPanicPackage(0.5f));
            brain.addActivity(Activity.REST, VillagerTasksMCA.getRestPackage(0.5f));
            brain.addActivity(ActivitiesMCA.CHORE, VillagerTasksMCA.getChorePackage());
            noDefault = true;
        } else if (!villager.requiresHome()) {
            brain.setSchedule(SchedulesMCA.GUESTS);
            brain.addActivity(Activity.CORE, VillagerTasksMCA.getImportantCorePackage(0.5f));
            brain.addActivity(Activity.IDLE, VillagerTasksMCA.getAdventurerPackage(0.5f));
            brain.addActivity(Activity.CORE, VillagerTasksMCA.getSelfDefencePackage());
            brain.addActivity(Activity.PANIC, VillagerTasksMCA.getPanicPackage(0.5f));
            brain.addActivity(Activity.REST, VillagerTasksMCA.getRestPackage(0.5f));
            noDefault = true;
        } else {
            if (age == AgeState.BABY) {
                brain.setSchedule(Schedule.VILLAGER_BABY);
                return brain;
            }
            if (age != AgeState.ADULT) {
                brain.setSchedule(Schedule.VILLAGER_BABY);
                brain.addActivity(Activity.PLAY, VillagerTasksMCA.getPlayPackage(1.0f));
                brain.addActivity(Activity.CORE, VillagerTasksMCA.getSelfDefencePackage());
            } else if (villager.isGuard()) {
                brain.setSchedule(SchedulesMCA.getTypeSchedule((LivingEntity)villager, SchedulesMCA.GUARD, SchedulesMCA.GUARD_NIGHT));
                brain.addActivity(Activity.CORE, VillagerTasksMCA.getGuardCorePackage(villager));
                brain.addActivity(Activity.WORK, VillagerTasksMCA.getGuardWorkPackage());
                brain.addActivity(Activity.PANIC, VillagerTasksMCA.getGuardPanicPackage(0.5f));
                brain.addActivity(Activity.RAID, VillagerTasksMCA.getGuardWorkPackage());
            } else {
                brain.setSchedule(SchedulesMCA.getTypeSchedule((LivingEntity)villager));
                brain.addActivity(Activity.CORE, VillagerTasksMCA.getWorkingCorePackage(profession, 0.5f));
                brain.addActivityWithConditions(Activity.WORK, VillagerTasksMCA.getWorkPackage(profession, 0.5f), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.JOB_SITE, (Object)MemoryStatus.VALUE_PRESENT)));
                brain.addActivity(Activity.CORE, VillagerTasksMCA.getSelfDefencePackage());
                brain.addActivity(Activity.RAID, VillagerTasksMCA.getRaidPackage(0.5f));
            }
        }
        brain.addActivity(ActivitiesMCA.GRIEVE, VillagerTasksMCA.getGrievingPackage());
        if (!noDefault) {
            brain.addActivity(Activity.CORE, VillagerTasksMCA.getImportantCorePackage(0.5f));
            brain.addActivity(Activity.CORE, VillagerTasksMCA.getCorePackage(0.5f));
            brain.addActivityWithConditions(Activity.MEET, VillagerTasksMCA.getMeetPackage(0.5f), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.MEETING_POINT, (Object)MemoryStatus.VALUE_PRESENT)));
            brain.addActivity(Activity.REST, VillagerTasksMCA.getRestPackage(0.5f));
            brain.addActivity(Activity.IDLE, VillagerTasksMCA.getIdlePackage(0.5f));
            brain.addActivity(Activity.PANIC, VillagerTasksMCA.getPanicPackage(0.5f));
            brain.addActivity(Activity.PRE_RAID, VillagerTasksMCA.getPreRaidPackage(0.5f));
            brain.addActivity(Activity.HIDE, VillagerTasksMCA.getHidePackage(0.5f));
            brain.addActivity(ActivitiesMCA.CHORE, VillagerTasksMCA.getChorePackage());
        }
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.setActiveActivityIfPossible(Activity.IDLE);
        brain.updateActivityFromSchedule(villager.level().getDayTime(), villager.level().getGameTime());
        return brain;
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super VillagerEntityMCA>>> getStayingPackage() {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new StayTask())), VillagerTasksMCA.getFullLookBehavior());
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super VillagerEntityMCA>>> getFollowingPackage() {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new FollowTask())), VillagerTasksMCA.getMinimalLookBehavior());
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super VillagerEntityMCA>>> getImportantCorePackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new Swim(0.8f)), (Object)(Config.getServerConfig().useSmarterDoorAI ? Pair.of((Object)0, (Object)((Object)new SmarterOpenDoorsTask())) : Pair.of((Object)0, (Object)InteractWithDoor.create())), (Object)Pair.of((Object)0, (Object)new LookAtTargetSink(45, 90)), (Object)Pair.of((Object)0, (Object)WakeUp.create()), (Object)Pair.of((Object)0, (Object)((Object)new DeliverMessageTask())), (Object)Pair.of((Object)1, (Object)((Object)new WanderOrTeleportToTargetTask())), (Object)Pair.of((Object)3, (Object)((Object)new InteractTask(speedModifier))), (Object)Pair.of((Object)10, (Object)((Object)new ExtendedFindPointOfInterestTask(registryEntry -> registryEntry.is(PoiTypes.HOME), (MemoryModuleType<GlobalPos>)MemoryModuleType.HOME, false, Optional.of((byte)14), villager -> villager.getResidency().seekHome(), (entity, pos) -> {
            VillageManager manager = VillageManager.get((ServerLevel)entity.level());
            if (entity.requiresHome()) {
                return manager.findNearestVillage((Entity)entity).filter(v -> !v.isPositionValidBed((BlockPos)pos)).isEmpty();
            }
            return manager.findNearestVillage((Entity)entity).filter(v -> v.getBuildingAt((Vec3i)pos).filter(b -> b.getBuildingType().name().equals("inn")).isPresent()).isPresent();
        }))));
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super VillagerEntityMCA>>> getCorePackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new GreetPlayerTask())), (Object)Pair.of((Object)0, (Object)ReactToBell.create()), (Object)Pair.of((Object)0, (Object)SetRaidStatus.create()), (Object)Pair.of((Object)5, (Object)GoToWantedItem.create((float)speedModifier, (boolean)false, (int)4)), (Object)Pair.of((Object)10, (Object)((Object)new ExtendedFindPointOfInterestTask(registryEntry -> registryEntry.is(PoiTypes.HOME), (MemoryModuleType<GlobalPos>)MemoryModuleType.HOME, false, Optional.of((byte)14), villager -> villager.getResidency().seekHome(), (entity, pos) -> {
            VillageManager manager = VillageManager.get((ServerLevel)entity.level());
            return manager.findNearestVillage((Entity)entity).filter(v -> v.getBuildingAt((Vec3i)pos).filter(b -> b.getBuildingType().noBeds()).isPresent()).isEmpty();
        }))), (Object)Pair.of((Object)10, (Object)((Object)new ExtendedFindPointOfInterestTask(registryEntry -> registryEntry.is(PoiTypes.MEETING), (MemoryModuleType<GlobalPos>)MemoryModuleType.MEETING_POINT, true, Optional.of((byte)14), villager -> villager.getBrain().getMemoryInternal(MemoryModuleType.MEETING_POINT).ifPresent(p -> {
            if (villager.level().dimension() == p.dimension()) {
                VillageManager manager = VillageManager.get((ServerLevel)villager.level());
                if (!manager.cache.contains(p.pos())) {
                    manager.cache.add(p.pos());
                    manager.processBuilding(p.pos());
                }
                villager.getResidency().seekHome();
            }
        })))));
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super VillagerEntityMCA>>> getWorkingCorePackage(VillagerProfession profession, float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)ValidateNearbyPoi.create((Predicate)profession.heldJobSite(), (MemoryModuleType)MemoryModuleType.JOB_SITE)), (Object)Pair.of((Object)0, (Object)ValidateNearbyPoi.create((Predicate)profession.acquirableJobSite(), (MemoryModuleType)MemoryModuleType.POTENTIAL_JOB_SITE)), (Object)Pair.of((Object)2, (Object)PoiCompetitorScan.create()), (Object)Pair.of((Object)3, (Object)new LookAndFollowTradingPlayerSink(speedModifier)), (Object)Pair.of((Object)6, LazyFindPointOfInterestTask.create(profession.acquirableJobSite(), (MemoryModuleType<GlobalPos>)MemoryModuleType.JOB_SITE, (MemoryModuleType<GlobalPos>)MemoryModuleType.POTENTIAL_JOB_SITE, true, Optional.empty())), (Object)Pair.of((Object)7, (Object)new GoToPotentialJobSite(speedModifier)), (Object)Pair.of((Object)8, (Object)YieldJobSite.create((float)speedModifier)), (Object)Pair.of((Object)10, (Object)AssignProfessionFromJobSite.create()), (Object)Pair.of((Object)10, LoseUnimportantJobTask.create()));
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super VillagerEntityMCA>>> getSelfDefencePackage() {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new VillagerPanicTrigger()), (Object)Pair.of((Object)1, (Object)((Object)new EquipmentTask(VillagerTasksMCA::isInDanger, v -> EquipmentSet.NAKED))), (Object)Pair.of((Object)2, (Object)((Object)new ExtendedMeleeAttackTask(15, 2.5f, (MemoryModuleType<? extends LivingEntity>)MemoryModuleType.NEAREST_HOSTILE))));
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super VillagerEntityMCA>>> getGuardCorePackage(VillagerEntityMCA villager) {
        return ImmutableList.of((Object)Pair.of((Object)0, new ConditionalTask<VillagerEntityMCA>((Behavior<VillagerEntityMCA>)new VillagerPanicTrigger(), VillagerTasksMCA::guardTooHurt)), (Object)Pair.of((Object)0, (Object)((Object)new SayTask("villager.retreat", 100, e -> VillagerTasksMCA.guardTooHurt(e) && e.getVillagerBrain().isPanicking()))), (Object)Pair.of((Object)0, (Object)((Object)new SayTask("villager.attack", 160, e -> !VillagerTasksMCA.guardTooHurt(e) && VillagerTasksMCA.getPreferredTarget(e).isPresent()))), (Object)Pair.of((Object)0, new ConditionalTask<VillagerEntityMCA>(new ExtendedMeleeAttackTask(15, 2.5f, (MemoryModuleType<? extends LivingEntity>)MemoryModuleType.NEAREST_HOSTILE), VillagerTasksMCA::guardTooHurt)), (Object)Pair.of((Object)1, (Object)((Object)new EquipmentTask(VillagerTasksMCA::isOnDuty, v -> v.getResidency().getHomeVillage().map(vil -> vil.getVillageGuardsManager().getGuardEquipment(v.getProfession(), v.getDominantHand())).orElse(VillageGuardsManager.getEquipmentFor(v.getDominantHand(), EquipmentSet.GUARD_0, EquipmentSet.GUARD_0_LEFT))))), (Object)Pair.of((Object)2, (Object)StartAttacking.create(t -> true, VillagerTasksMCA::getPreferredTarget)), (Object)Pair.of((Object)3, (Object)StopAttackingIfTargetInvalid.create(livingEntity -> !VillagerTasksMCA.isPreferredTarget(villager, livingEntity))), (Object)Pair.of((Object)4, new BowTask(20, 12)), (Object)Pair.of((Object)5, (Object)BehaviorBuilder.triggerIf(v -> v.isHolding(Items.CROSSBOW), (OneShot)BackUpIfTooClose.create((int)5, (float)0.75f))), (Object)Pair.of((Object)6, (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)0.75f)), (Object)Pair.of((Object)7, (Object)((Object)new ExtendedMeleeAttackTask(20, 2.0f))), (Object)Pair.of((Object)8, (Object)new CrossbowAttack()), (Object[])new Pair[0]);
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super VillagerEntityMCA>>> getGuardWorkPackage() {
        return ImmutableList.of((Object)Pair.of((Object)10, (Object)((Object)new PatrolVillageTask(4, 0.4f))), (Object)Pair.of((Object)99, (Object)UpdateActivityFromSchedule.create()));
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super VillagerEntityMCA>>> getGuardPanicPackage(float speedModifier) {
        float f = speedModifier * 1.5f;
        return ImmutableList.of((Object)Pair.of((Object)1, (Object)VillagerCalmDown.create()), (Object)Pair.of((Object)2, (Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.NEAREST_HOSTILE, (float)f, (int)6, (boolean)false)), (Object)Pair.of((Object)2, (Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.HURT_BY_ENTITY, (float)f, (int)6, (boolean)false)), (Object)Pair.of((Object)3, (Object)VillageBoundRandomStroll.create((float)f, (int)2, (int)2)), VillagerTasksMCA.getMinimalLookBehavior());
    }

    private static boolean guardTooHurt(VillagerEntityMCA villager) {
        return (double)villager.getHealth() < (double)villager.getMaxHealth() * 0.25;
    }

    private static Optional<? extends LivingEntity> getPreferredTarget(VillagerEntityMCA villager) {
        if (VillagerTasksMCA.guardTooHurt(villager)) {
            return Optional.empty();
        }
        Optional primary = villager.getBrain().getMemoryInternal(MemoryModuleTypeMCA.NEAREST_GUARD_ENEMY);
        if (primary.isPresent() && (VillagerTasksMCA.getActivity(villager) != Activity.REST || (double)((LivingEntity)primary.get()).distanceTo((Entity)villager) < 8.0)) {
            return primary;
        }
        return villager.getBrain().getMemoryInternal(MemoryModuleType.ATTACK_TARGET);
    }

    private static boolean isPreferredTarget(VillagerEntityMCA villager, LivingEntity entity) {
        Optional<? extends LivingEntity> target = VillagerTasksMCA.getPreferredTarget(villager);
        return target.filter(livingEntity -> livingEntity == entity).isPresent();
    }

    public static boolean isOnDuty(VillagerEntityMCA villager) {
        return VillagerTasksMCA.getActivity(villager) == Activity.WORK || villager.getBrain().getMemoryInternal(MemoryModuleType.ATTACK_TARGET).isPresent();
    }

    public static boolean isInDanger(VillagerEntityMCA villager) {
        return villager.getVillagerBrain().isPanicking() || villager.getBrain().getMemoryInternal(MemoryModuleType.ATTACK_TARGET).isPresent();
    }

    private static Activity getActivity(VillagerEntityMCA villager) {
        return villager.getBrain().getSchedule().getActivityAt((int)(villager.level().getDayTime() % 24000L));
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super VillagerEntityMCA>>> getGrievingPackage() {
        return ImmutableList.of((Object)Pair.of((Object)0, new SequenceTask((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), ImmutableList.of((Object)((Object)new EnterBuildingTask("graveyard", 0.5f)), (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)((Object)new HoldItemTask(InteractionHand.MAIN_HAND, Items.WHITE_TULIP)), (Object)1), (Object)Pair.of((Object)((Object)new HoldItemTask(InteractionHand.MAIN_HAND, Items.RED_TULIP)), (Object)1), (Object)Pair.of((Object)((Object)new HoldItemTask(InteractionHand.MAIN_HAND, Items.ORANGE_TULIP)), (Object)1), (Object)Pair.of((Object)((Object)new HoldItemTask(InteractionHand.MAIN_HAND, Items.PINK_TULIP)), (Object)1))), (Object)((Object)new WanderOrTeleportToTargetTask()), (Object)new DoNothing(100, 300), (Object)((Object)new SayTask("villager.grieving")), (Object)new DoNothing(100, 300), (Object)((Object)new SayTask("villager.grieving")), (Object)new DoNothing(100, 300), (Object)((Object)new SayTask("villager.grieving")), (Object)((Object)new HoldItemTask(InteractionHand.MAIN_HAND, ItemStack.EMPTY)), new LambdaTask<VillagerEntityMCA>(v -> {
            v.getVillagerBrain().justGrieved();
            v.getBrain().updateActivityFromSchedule(v.level().getDayTime(), v.level().getGameTime());
        })))));
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super VillagerEntityMCA>>> getWorkPackage(VillagerProfession profession, float speedModifier) {
        Object villagerWorkTask = profession == VillagerProfession.FARMER ? new WorkAtComposter() : new WorkAtPoi();
        return ImmutableList.of(VillagerTasksMCA.getMinimalLookBehavior(), (Object)Pair.of((Object)5, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)villagerWorkTask, (Object)7), (Object)Pair.of((Object)StrollAroundPoi.create((MemoryModuleType)MemoryModuleType.JOB_SITE, (float)0.4f, (int)4), (Object)2), (Object)Pair.of((Object)StrollToPoi.create((MemoryModuleType)MemoryModuleType.JOB_SITE, (float)0.4f, (int)1, (int)10), (Object)5), (Object)Pair.of((Object)StrollToPoiList.create((MemoryModuleType)MemoryModuleType.SECONDARY_JOB_SITE, (float)speedModifier, (int)1, (int)6, (MemoryModuleType)MemoryModuleType.JOB_SITE), (Object)5), (Object)Pair.of((Object)new HarvestFarmland(), (Object)(profession == VillagerProfession.FARMER ? 2 : 5)), (Object)Pair.of((Object)new UseBonemeal(), (Object)(profession == VillagerProfession.FARMER ? 4 : 7))))), (Object)Pair.of((Object)10, (Object)new ShowTradesToPlayer(400, 1600)), (Object)Pair.of((Object)10, (Object)SetLookAndInteract.create((EntityType)EntityType.PLAYER, (int)4)), (Object)Pair.of((Object)2, (Object)SetWalkTargetFromBlockMemory.create((MemoryModuleType)MemoryModuleType.JOB_SITE, (float)speedModifier, (int)9, (int)100, (int)1200)), (Object)Pair.of((Object)3, (Object)new GiveGiftToHero(100)), (Object)Pair.of((Object)99, (Object)UpdateActivityFromSchedule.create()));
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super VillagerEntityMCA>>> getPlayPackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new MoveToTargetSink(80, 120)), VillagerTasksMCA.getFullLookBehavior(), (Object)Pair.of((Object)5, (Object)PlayTagWithOtherKids.create()), (Object)Pair.of((Object)5, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.VISIBLE_VILLAGER_BABIES, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)InteractWith.of((EntityType)EntityType.VILLAGER, (int)8, (MemoryModuleType)MemoryModuleType.INTERACTION_TARGET, (float)speedModifier, (int)2), (Object)2), (Object)Pair.of((Object)InteractWith.of((EntityType)EntityType.CAT, (int)8, (MemoryModuleType)MemoryModuleType.INTERACTION_TARGET, (float)speedModifier, (int)2), (Object)1), (Object)Pair.of((Object)VillageBoundRandomStroll.create((float)speedModifier), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)speedModifier, (int)2), (Object)1), (Object)Pair.of((Object)new JumpOnBed(speedModifier), (Object)2), (Object)Pair.of((Object)new DoNothing(20, 40), (Object)2)))), (Object)Pair.of((Object)99, (Object)UpdateActivityFromSchedule.create()));
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super VillagerEntityMCA>>> getRestPackage(float speed) {
        return ImmutableList.of((Object)Pair.of((Object)2, ExtendedWalkTowardsTask.create((MemoryModuleType<GlobalPos>)MemoryModuleType.HOME, speed, 1, 192, 1200, v -> {
            boolean forced;
            Optional memory = v.getBrain().getMemoryInternal(MemoryModuleTypeMCA.FORCED_HOME);
            boolean bl = forced = memory != null && memory.isPresent();
            if (forced) {
                v.sendChatToAllAround("villager.cant_find_bed", new Object[0]);
            }
            return !forced;
        }, v -> v.getResidency().seekHome())), (Object)Pair.of((Object)3, new ConditionalSingleTickTask<VillagerEntityMCA>(ExtendedForgetCompletedPointOfInterestTask.create(registryEntry -> registryEntry.is(PoiTypes.HOME), (MemoryModuleType<GlobalPos>)MemoryModuleType.HOME, entity -> {
            if (entity instanceof VillagerEntityMCA) {
                VillagerEntityMCA villager = (VillagerEntityMCA)entity;
                villager.getResidency().seekHome();
            }
        }), v -> {
            Optional memory = v.getBrain().getMemoryInternal(MemoryModuleTypeMCA.FORCED_HOME);
            return memory == null || memory.isEmpty();
        })), (Object)Pair.of((Object)3, (Object)new SleepInBed()), (Object)Pair.of((Object)5, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.HOME, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)SetClosestHomeAsWalkTarget.create((float)speed), (Object)1), (Object)Pair.of((Object)InsideBrownianWalk.create((float)speed), (Object)4), (Object)Pair.of((Object)GoToClosestVillage.create((float)speed, (int)4), (Object)2), (Object)Pair.of((Object)new DoNothing(20, 40), (Object)2)))), (Object)Pair.of((Object)99, (Object)UpdateActivityFromSchedule.create()));
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super VillagerEntityMCA>>> getMeetPackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)2, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)StrollAroundPoi.create((MemoryModuleType)MemoryModuleType.MEETING_POINT, (float)0.4f, (int)40), (Object)2), (Object)Pair.of((Object)SocializeAtBell.create(), (Object)2)))), (Object)Pair.of((Object)10, (Object)new ShowTradesToPlayer(400, 1600)), (Object)Pair.of((Object)10, (Object)SetLookAndInteract.create((EntityType)EntityType.PLAYER, (int)4)), (Object)Pair.of((Object)2, (Object)SetWalkTargetFromBlockMemory.create((MemoryModuleType)MemoryModuleType.MEETING_POINT, (float)speedModifier, (int)6, (int)100, (int)200)), (Object)Pair.of((Object)3, (Object)new GiveGiftToHero(100)), (Object)Pair.of((Object)3, (Object)ValidateNearbyPoi.create(registryEntry -> registryEntry.is(PoiTypes.MEETING), (MemoryModuleType)MemoryModuleType.MEETING_POINT)), (Object)Pair.of((Object)3, (Object)new GateBehavior((Map)ImmutableMap.of(), (Set)ImmutableSet.of((Object)MemoryModuleType.INTERACTION_TARGET), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.RUN_ONE, (List)ImmutableList.of((Object)Pair.of((Object)new TradeWithVillager(), (Object)1)))), VillagerTasksMCA.getFullLookBehavior(), (Object)Pair.of((Object)99, (Object)UpdateActivityFromSchedule.create()));
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super VillagerEntityMCA>>> getIdlePackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)1, (Object)((Object)new EnterFavoredBuildingTask(0.5f))), (Object)Pair.of((Object)2, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)InteractWith.of(EntitiesMCA.FEMALE_VILLAGER, (int)8, (MemoryModuleType)MemoryModuleType.INTERACTION_TARGET, (float)speedModifier, (int)2), (Object)2), (Object)Pair.of((Object)InteractWith.of(EntitiesMCA.MALE_VILLAGER, (int)8, (MemoryModuleType)MemoryModuleType.INTERACTION_TARGET, (float)speedModifier, (int)2), (Object)2), (Object)Pair.of((Object)InteractWith.of((EntityType)EntityType.CAT, (int)8, (MemoryModuleType)MemoryModuleType.INTERACTION_TARGET, (float)speedModifier, (int)2), (Object)1), (Object)Pair.of((Object)VillageBoundRandomStroll.create((float)speedModifier), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)speedModifier, (int)2), (Object)1), (Object)Pair.of((Object)new JumpOnBed(speedModifier), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)))), (Object)Pair.of((Object)3, (Object)new GiveGiftToHero(100)), (Object)Pair.of((Object)3, (Object)SetLookAndInteract.create((EntityType)EntityType.PLAYER, (int)4)), (Object)Pair.of((Object)3, (Object)new ShowTradesToPlayer(400, 1600)), (Object)Pair.of((Object)3, (Object)((Object)new GrieveTask())), (Object)Pair.of((Object)3, (Object)new GateBehavior((Map)ImmutableMap.of(), (Set)ImmutableSet.of((Object)MemoryModuleType.INTERACTION_TARGET), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.RUN_ONE, (List)ImmutableList.of((Object)Pair.of((Object)new TradeWithVillager(), (Object)1)))), VillagerTasksMCA.getFullLookBehavior(), (Object)Pair.of((Object)99, (Object)UpdateActivityFromSchedule.create()));
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super VillagerEntityMCA>>> getPanicPackage(float speedModifier) {
        float f = speedModifier * 1.5f;
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)VillagerCalmDown.create()), (Object)Pair.of((Object)1, (Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.NEAREST_HOSTILE, (float)f, (int)6, (boolean)false)), (Object)Pair.of((Object)1, (Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.HURT_BY_ENTITY, (float)f, (int)6, (boolean)false)), (Object)Pair.of((Object)3, (Object)VillageBoundRandomStroll.create((float)f, (int)2, (int)2)), VillagerTasksMCA.getMinimalLookBehavior());
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super VillagerEntityMCA>>> getPreRaidPackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)RingBell.create()), (Object)Pair.of((Object)0, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetWalkTargetFromBlockMemory.create((MemoryModuleType)MemoryModuleType.MEETING_POINT, (float)(speedModifier * 1.5f), (int)2, (int)150, (int)200), (Object)6), (Object)Pair.of((Object)VillageBoundRandomStroll.create((float)(speedModifier * 1.5f)), (Object)2)))), VillagerTasksMCA.getMinimalLookBehavior(), (Object)Pair.of((Object)99, (Object)ResetRaidStatus.create()));
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super VillagerEntityMCA>>> getRaidPackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)MoveToSkySeeingSpot.create((float)speedModifier), (Object)5), (Object)Pair.of((Object)VillageBoundRandomStroll.create((float)(speedModifier * 1.1f)), (Object)2)))), (Object)Pair.of((Object)0, (Object)new CelebrateVillagersSurvivedRaid(600, 600)), (Object)Pair.of((Object)2, (Object)LocateHidingPlace.create((int)24, (float)(speedModifier * 1.4f), (int)1)), VillagerTasksMCA.getMinimalLookBehavior(), (Object)Pair.of((Object)99, (Object)ResetRaidStatus.create()));
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super VillagerEntityMCA>>> getHidePackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)SetHiddenState.create((int)15, (int)3)), (Object)Pair.of((Object)1, (Object)LocateHidingPlace.create((int)32, (float)(speedModifier * 1.25f), (int)2)), VillagerTasksMCA.getMinimalLookBehavior());
    }

    public static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super VillagerEntityMCA>>> getChorePackage() {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new ChoppingTask())), (Object)Pair.of((Object)0, (Object)((Object)new FishingTask())), (Object)Pair.of((Object)0, (Object)((Object)new HarvestingTask())), (Object)Pair.of((Object)0, (Object)((Object)new HuntingTask())));
    }

    private static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super VillagerEntityMCA>>> getAdventurerPackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)5, (Object)InteractWith.of(EntitiesMCA.FEMALE_VILLAGER, (int)8, (MemoryModuleType)MemoryModuleType.INTERACTION_TARGET, (float)speedModifier, (int)2)), (Object)Pair.of((Object)5, (Object)InteractWith.of(EntitiesMCA.MALE_VILLAGER, (int)8, (MemoryModuleType)MemoryModuleType.INTERACTION_TARGET, (float)speedModifier, (int)2)), (Object)Pair.of((Object)5, (Object)InteractWith.of((EntityType)EntityType.CAT, (int)8, (MemoryModuleType)MemoryModuleType.INTERACTION_TARGET, (float)speedModifier, (int)2)), (Object)Pair.of((Object)5, (Object)VillageBoundRandomStroll.create((float)speedModifier)), (Object)Pair.of((Object)5, (Object)SetWalkTargetFromLookTarget.create((float)speedModifier, (int)2)), (Object)Pair.of((Object)5, (Object)((Object)new EnterBuildingTask("inn", 0.5f))));
    }

    private static ImmutableList<Pair<Integer, ? extends BehaviorControl<? super VillagerEntityMCA>>> getMercenaryPackage(float speedModifier) {
        return ImmutableList.of((Object)Pair.of((Object)5, (Object)VillageBoundRandomStroll.create((float)speedModifier)), (Object)Pair.of((Object)5, (Object)SetWalkTargetFromLookTarget.create((float)speedModifier, (int)2)));
    }

    private static Pair<Integer, BehaviorControl<LivingEntity>> getFullLookBehavior() {
        return Pair.of((Object)5, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.CAT, (float)8.0f), (Object)8), (Object)Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.VILLAGER, (float)8.0f), (Object)2), (Object)Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.PLAYER, (float)8.0f), (Object)2), (Object)Pair.of((Object)SetEntityLookTarget.create((MobCategory)MobCategory.CREATURE, (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.create((MobCategory)MobCategory.WATER_CREATURE, (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.create((MobCategory)MobCategory.WATER_AMBIENT, (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.create((MobCategory)MobCategory.MONSTER, (float)8.0f), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)2))));
    }

    private static Pair<Integer, BehaviorControl<LivingEntity>> getMinimalLookBehavior() {
        return Pair.of((Object)5, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.VILLAGER, (float)8.0f), (Object)2), (Object)Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.PLAYER, (float)8.0f), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)8))));
    }
}

