/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.brain.sensor;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import net.conczin.mca.Config;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.MemoryModuleTypeMCA;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.monster.Enemy;

public class GuardEnemiesSensor
extends Sensor<LivingEntity> {
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleTypeMCA.NEAREST_GUARD_ENEMY);
    }

    protected void doTick(ServerLevel world, LivingEntity entity) {
        entity.getBrain().setMemory(MemoryModuleTypeMCA.NEAREST_GUARD_ENEMY, this.getNearestHostile(entity));
    }

    private Optional<LivingEntity> getNearestHostile(LivingEntity entity) {
        return this.getVisibleMobs(entity).flatMap(list -> list.find(this::isHostile).min((a, b) -> this.compareEntities(entity, (LivingEntity)a, (LivingEntity)b)));
    }

    private Optional<NearestVisibleLivingEntities> getVisibleMobs(LivingEntity entity) {
        return entity.getBrain().getMemoryInternal(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
    }

    private int compareEntities(LivingEntity entity, LivingEntity hostile1, LivingEntity hostile2) {
        int i = this.getPriority(hostile2, entity) - this.getPriority(hostile1, entity);
        return i == 0 ? this.compareDistances(entity, hostile1, hostile2) : i;
    }

    private int compareDistances(LivingEntity entity, LivingEntity hostile1, LivingEntity hostile2) {
        return Mth.floor((double)(hostile1.distanceToSqr((Entity)entity) - hostile2.distanceToSqr((Entity)entity)));
    }

    private int getPriority(LivingEntity entity, LivingEntity guard) {
        Mob mob;
        if (entity instanceof VillagerEntityMCA) {
            VillagerEntityMCA villager = (VillagerEntityMCA)entity;
            return villager.isHostile() ? 10 : -1;
        }
        if (guard != null && entity instanceof Mob && (mob = (Mob)entity).getTarget() == guard) {
            return 9;
        }
        ResourceLocation id = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
        if (Config.getInstance().guardsTargetEntities.containsKey(id.toString())) {
            return Config.getInstance().guardsTargetEntities.get(id.toString());
        }
        if (Config.getInstance().guardsTargetMonsters && entity instanceof Enemy) {
            return 3;
        }
        return -1;
    }

    private boolean isHostile(LivingEntity entity) {
        return this.getPriority(entity, null) >= 0;
    }
}

