/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.Items;

public class BowTask<E extends Mob>
extends Behavior<E> {
    private final int fireInterval;
    private final int squaredRange;
    private int lastShot;

    public BowTask(int fireInterval, int range) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT));
        this.fireInterval = fireInterval;
        this.squaredRange = range * range;
    }

    private static LivingEntity getAttackTarget(LivingEntity entity) {
        return entity.getBrain().getMemoryInternal(MemoryModuleType.ATTACK_TARGET).orElse(null);
    }

    protected boolean checkExtraStartConditions(ServerLevel serverWorld, E entity) {
        LivingEntity livingEntity = BowTask.getAttackTarget(entity);
        return livingEntity != null && entity.isHolding(Items.BOW) && BehaviorUtils.canSee(entity, (LivingEntity)livingEntity) && BehaviorUtils.isWithinAttackRange(entity, (LivingEntity)livingEntity, (int)0);
    }

    protected void tick(ServerLevel world, E entity, long time) {
        super.tick(world, entity, time);
        LivingEntity target = BowTask.getAttackTarget(entity);
        double d = entity.distanceToSqr((Entity)target);
        float backward = 0.0f;
        if (d > (double)((float)this.squaredRange * 1.25f)) {
            backward = 0.5f;
        } else if (d < (double)((float)this.squaredRange * 0.75f)) {
            backward = -0.5f;
        }
        float strafe = (float)(Math.cos((float)time / 20.0f) * 0.5);
        entity.getMoveControl().strafe(backward, strafe);
        entity.lookAt((Entity)target, 30.0f, 30.0f);
        if (((Mob)entity).tickCount - this.lastShot > this.fireInterval) {
            ((RangedAttackMob)entity).performRangedAttack(target, 1.0f);
            this.lastShot = ((Mob)entity).tickCount;
        }
    }

    protected boolean canStillUse(ServerLevel world, E entity, long time) {
        return this.checkExtraStartConditions(world, entity);
    }

    protected void start(ServerLevel world, E entity, long time) {
        entity.setAggressive(true);
    }

    protected void stop(ServerLevel world, E entity, long time) {
        super.stop(world, entity, time);
        entity.setAggressive(false);
    }
}

