/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.ConversationManager;
import net.conczin.mca.entity.ai.MemoryModuleTypeMCA;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.Vec3;

public class DeliverMessageTask
extends Behavior<VillagerEntityMCA> {
    private static final int TALKING_TIME_MIN = 100;
    private static final int TALKING_TIME_MAX = 500;
    private static final long MIN_TIME_BETWEEN_SOUND = 6000L;
    private ConversationManager.Message message = null;
    private Entity receiver = null;
    private int talked;
    private long lastInteraction = Long.MIN_VALUE;
    private Vec3 lastInteractionPos;

    public DeliverMessageTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.INTERACTION_TARGET, (Object)MemoryStatus.REGISTERED), 600);
    }

    private static Optional<ConversationManager.Message> getMessage(VillagerEntityMCA villager) {
        return villager.conversationManager.getCurrentMessage();
    }

    private static boolean isWithinRange(VillagerEntityMCA villager, Entity player) {
        if (villager.getBrain().getMemoryInternal(MemoryModuleTypeMCA.STAYING).isPresent()) {
            return true;
        }
        return villager.blockPosition().closerThan((Vec3i)player.blockPosition(), 3.0);
    }

    private static boolean isWithinSeeRange(VillagerEntityMCA villager, Entity player) {
        return villager.blockPosition().closerThan((Vec3i)player.blockPosition(), 64.0);
    }

    protected boolean checkExtraStartConditions(ServerLevel world, VillagerEntityMCA villager) {
        Optional<ConversationManager.Message> optionalMessage = DeliverMessageTask.getMessage(villager);
        optionalMessage.ifPresent(m -> {
            this.message = m;
            this.receiver = this.message.getReceiver();
        });
        return optionalMessage.isPresent() && DeliverMessageTask.isWithinSeeRange(villager, this.receiver);
    }

    protected void start(ServerLevel world, VillagerEntityMCA villager, long time) {
        this.talked = 0;
    }

    protected boolean canStillUse(ServerLevel world, VillagerEntityMCA villager, long time) {
        return this.message != null && this.talked < this.getMaxTalkingTime() && !villager.getVillagerBrain().isPanicking() && !villager.isSleeping();
    }

    private int getMaxTalkingTime() {
        Vec3 pos;
        if (this.lastInteractionPos != null && this.lastInteractionPos.closerThan((Position)(pos = this.receiver.position()), 1.0)) {
            return 500;
        }
        return 100;
    }

    protected void tick(ServerLevel world, VillagerEntityMCA villager, long time) {
        Entity entity = this.receiver;
        if (entity instanceof LivingEntity) {
            LivingEntity e = (LivingEntity)entity;
            villager.getBrain().setMemory(MemoryModuleType.INTERACTION_TARGET, (Object)e);
            BehaviorUtils.lookAtEntity((LivingEntity)villager, (LivingEntity)e);
        }
        BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)villager, (Entity)this.receiver, (float)0.5f, (int)2);
        if (this.message.getReceiver() != this.receiver) {
            return;
        }
        if (this.message.stillValid() && DeliverMessageTask.isWithinRange(villager, this.receiver)) {
            if (time - this.lastInteraction > 6000L) {
                villager.playWelcomeSound();
            }
            this.lastInteraction = time;
            this.lastInteractionPos = this.receiver.position();
            this.message.deliver();
        } else if (!this.message.stillValid() && DeliverMessageTask.isWithinRange(villager, this.receiver)) {
            ++this.talked;
            Optional<ConversationManager.Message> optionalMessage = DeliverMessageTask.getMessage(villager);
            optionalMessage.ifPresent(m -> {
                this.message = m;
                if (m.getReceiver() == this.receiver) {
                    this.talked = 0;
                }
            });
        }
    }

    protected void stop(ServerLevel world, VillagerEntityMCA villager, long time) {
        this.message = null;
        this.receiver = null;
        villager.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
        villager.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        villager.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
    }
}

