/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.conczin.mca.entity.EquipmentSet;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.MemoryModuleTypeMCA;
import net.conczin.mca.util.InventoryUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;

public class EquipmentTask
extends Behavior<VillagerEntityMCA> {
    private static final int COOLDOWN = 100;
    private final Predicate<VillagerEntityMCA> condition;
    private final Function<VillagerEntityMCA, EquipmentSet> equipmentSet;
    private int lastEquipTime;
    private boolean lastArmorWearState;

    public EquipmentTask(Predicate<VillagerEntityMCA> condition, Function<VillagerEntityMCA, EquipmentSet> set) {
        super((Map)ImmutableMap.of(MemoryModuleTypeMCA.WEARS_ARMOR, (Object)MemoryStatus.REGISTERED));
        this.condition = condition;
        this.equipmentSet = set;
    }

    protected boolean checkExtraStartConditions(ServerLevel world, VillagerEntityMCA villager) {
        if (this.lastArmorWearState != villager.getVillagerBrain().getArmorWear()) {
            return true;
        }
        boolean present = villager.getBrain().getMemoryInternal(MemoryModuleTypeMCA.WEARS_ARMOR).isPresent();
        if (this.condition.test(villager)) {
            this.lastEquipTime = villager.tickCount;
            return !present || this.equipmentSet.apply(villager).getMainHand() != null && villager.getMainHandItem().isEmpty();
        }
        if (villager.tickCount - this.lastEquipTime > 100) {
            return present;
        }
        return false;
    }

    private void equipBestArmor(VillagerEntityMCA villager, EquipmentSlot slot, Item fallback) {
        ItemStack stack = InventoryUtils.getBestArmor((Container)villager.getInventory(), slot).orElse(fallback == null ? ItemStack.EMPTY : new ItemStack((ItemLike)fallback));
        villager.setItemSlot(slot, stack);
    }

    private void equipBestWeapon(VillagerEntityMCA villager, Item fallback) {
        ItemStack stack = InventoryUtils.getBestSword((Container)villager.getInventory()).orElse(fallback == null ? ItemStack.EMPTY : new ItemStack((ItemLike)fallback));
        villager.setItemSlot(villager.getDominantSlot(), stack);
    }

    private void equipBestRanged(VillagerEntityMCA villager, Item fallback) {
        ItemStack stack = InventoryUtils.getBestRanged((Container)villager.getInventory()).orElse(fallback == null ? ItemStack.EMPTY : new ItemStack((ItemLike)fallback));
        villager.setItemSlot(villager.getDominantSlot(), stack);
    }

    protected void start(ServerLevel world, VillagerEntityMCA villager, long time) {
        super.start(world, (LivingEntity)villager, time);
        this.lastArmorWearState = villager.getVillagerBrain().getArmorWear();
        EquipmentSet set = this.equipmentSet.apply(villager);
        boolean wear = this.condition.test(villager);
        if (wear) {
            villager.getBrain().setMemory(MemoryModuleTypeMCA.WEARS_ARMOR, (Object)true);
        } else {
            villager.getBrain().eraseMemory(MemoryModuleTypeMCA.WEARS_ARMOR);
        }
        if (wear) {
            if (set.getMainHand() instanceof ProjectileWeaponItem) {
                this.equipBestRanged(villager, set.getMainHand());
            } else {
                this.equipBestWeapon(villager, set.getMainHand());
            }
            villager.setItemSlot(villager.getOpposingSlot(), new ItemStack((ItemLike)set.getGetOffHand()));
        } else {
            villager.setItemInHand(villager.getDominantHand(), ItemStack.EMPTY);
            villager.setItemInHand(villager.getOpposingHand(), ItemStack.EMPTY);
        }
        if (wear || villager.getVillagerBrain().getArmorWear()) {
            this.equipBestArmor(villager, EquipmentSlot.HEAD, set.getHead());
            this.equipBestArmor(villager, EquipmentSlot.CHEST, set.getChest());
            this.equipBestArmor(villager, EquipmentSlot.LEGS, set.getLegs());
            this.equipBestArmor(villager, EquipmentSlot.FEET, set.getFeet());
        } else {
            villager.setItemSlot(EquipmentSlot.HEAD, ItemStack.EMPTY);
            villager.setItemSlot(EquipmentSlot.CHEST, ItemStack.EMPTY);
            villager.setItemSlot(EquipmentSlot.LEGS, ItemStack.EMPTY);
            villager.setItemSlot(EquipmentSlot.FEET, ItemStack.EMPTY);
        }
    }
}

