/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.AcquirePoi;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Path;

public class ExtendedFindPointOfInterestTask
extends Behavior<VillagerEntityMCA> {
    public static final int POI_SORTING_RADIUS = 48;
    private static final int MAX_POSITIONS_PER_RUN = 5;
    private static final int POSITION_EXPIRE_INTERVAL = 200;
    private final Consumer<VillagerEntityMCA> onFinish;
    private final BiPredicate<VillagerEntityMCA, BlockPos> predicate;
    private final Predicate<Holder<PoiType>> poiType;
    private final MemoryModuleType<GlobalPos> targetMemoryModuleType;
    private final boolean onlyRunIfAdult;
    private final Optional<Byte> entityStatus;
    private final Long2ObjectMap<RetryMarker> foundPositionsToExpiry = new Long2ObjectOpenHashMap();
    private long positionExpireTimeLimit;

    public ExtendedFindPointOfInterestTask(Predicate<Holder<PoiType>> poiType, MemoryModuleType<GlobalPos> moduleType, boolean onlyRunIfAdult, Optional<Byte> entityStatus, Consumer<VillagerEntityMCA> onFinish) {
        this(poiType, moduleType, onlyRunIfAdult, entityStatus, onFinish, (e, p) -> true);
    }

    public ExtendedFindPointOfInterestTask(Predicate<Holder<PoiType>> poiType, MemoryModuleType<GlobalPos> moduleType, boolean onlyRunIfAdult, Optional<Byte> entityStatus, Consumer<VillagerEntityMCA> onFinish, BiPredicate<VillagerEntityMCA, BlockPos> predicate) {
        super(ExtendedFindPointOfInterestTask.create(moduleType));
        this.onFinish = onFinish;
        this.predicate = predicate;
        this.poiType = poiType;
        this.targetMemoryModuleType = moduleType;
        this.onlyRunIfAdult = onlyRunIfAdult;
        this.entityStatus = entityStatus;
    }

    private static ImmutableMap<MemoryModuleType<?>, MemoryStatus> create(MemoryModuleType<GlobalPos> firstModule) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(firstModule, (Object)MemoryStatus.VALUE_ABSENT);
        return builder.build();
    }

    protected boolean checkExtraStartConditions(ServerLevel serverWorld, VillagerEntityMCA pathAwareEntity) {
        if (this.onlyRunIfAdult && pathAwareEntity.isBaby()) {
            return false;
        }
        if (this.positionExpireTimeLimit == 0L) {
            this.positionExpireTimeLimit = pathAwareEntity.level().getGameTime() + (long)serverWorld.random.nextInt(200);
            return false;
        }
        return serverWorld.getGameTime() >= this.positionExpireTimeLimit;
    }

    protected void start(ServerLevel serverWorld, VillagerEntityMCA villager, long l) {
        this.positionExpireTimeLimit = l + 200L + (long)serverWorld.getRandom().nextInt(200);
        PoiManager pointOfInterestStorage = serverWorld.getPoiManager();
        this.foundPositionsToExpiry.long2ObjectEntrySet().removeIf(entry -> !((RetryMarker)entry.getValue()).isAttempting(l));
        Predicate<BlockPos> predicate = blockPos -> {
            RetryMarker retryMarker = (RetryMarker)this.foundPositionsToExpiry.get(blockPos.asLong());
            if (retryMarker != null) {
                if (!retryMarker.shouldRetry(l)) {
                    return false;
                }
                retryMarker.setAttemptTime(l);
            }
            if (this.isBedOccupiedByOthers(serverWorld, (BlockPos)blockPos, (LivingEntity)villager)) {
                return false;
            }
            return this.predicate.test(villager, (BlockPos)blockPos);
        };
        Set set = pointOfInterestStorage.findAllClosestFirstWithType(this.poiType, predicate, villager.blockPosition(), 48, PoiManager.Occupancy.HAS_SPACE).limit(5L).collect(Collectors.toSet());
        Path path = AcquirePoi.findPathToPois((Mob)villager, set);
        if (path != null && path.canReach()) {
            BlockPos blockPos2 = path.getTarget();
            pointOfInterestStorage.getType(blockPos2).ifPresent(pointOfInterestType -> {
                pointOfInterestStorage.take(this.poiType, (typeRegistryEntry, otherPos) -> otherPos.equals((Object)blockPos2), blockPos2, 1);
                villager.getBrain().setMemory(this.targetMemoryModuleType, (Object)GlobalPos.of((ResourceKey)serverWorld.dimension(), (BlockPos)blockPos2));
                this.entityStatus.ifPresent(statusByte -> serverWorld.broadcastEntityEvent((Entity)villager, statusByte.byteValue()));
                this.foundPositionsToExpiry.clear();
                DebugPackets.sendPoiTicketCountPacket((ServerLevel)serverWorld, (BlockPos)blockPos2);
                this.onFinish.accept(villager);
            });
        } else {
            for (Pair blockPos2 : set) {
                this.foundPositionsToExpiry.computeIfAbsent(((BlockPos)blockPos2.getSecond()).asLong(), m -> new RetryMarker(villager.level().random, l));
            }
        }
    }

    private boolean isBedOccupiedByOthers(ServerLevel world, BlockPos pos, LivingEntity entity) {
        BlockState blockState = world.getBlockState(pos);
        return blockState.is(BlockTags.BEDS) && (Boolean)blockState.getValue((Property)BedBlock.OCCUPIED) != false && !entity.isSleeping();
    }

    static class RetryMarker {
        private static final int MIN_DELAY = 40;
        private static final int ATTEMPT_DURATION = 400;
        private final RandomSource random;
        private long previousAttemptAt;
        private long nextScheduledAttemptAt;
        private int currentDelay;

        RetryMarker(RandomSource random, long time) {
            this.random = random;
            this.setAttemptTime(time);
        }

        public void setAttemptTime(long time) {
            this.previousAttemptAt = time;
            int i = this.currentDelay + this.random.nextInt(40) + 40;
            this.currentDelay = Math.min(i, 400);
            this.nextScheduledAttemptAt = time + (long)this.currentDelay;
        }

        public boolean isAttempting(long time) {
            return time - this.previousAttemptAt < 400L;
        }

        public boolean shouldRetry(long time) {
            return time >= this.nextScheduledAttemptAt;
        }
    }
}

