/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.brain.tasks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.AcquirePoi;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.pathfinder.Path;
import org.apache.commons.lang3.mutable.MutableLong;

public class LazyFindPointOfInterestTask
extends AcquirePoi {
    private static final int MIN_DELAY = 200;

    public static BehaviorControl<PathfinderMob> create(Predicate<Holder<PoiType>> poiPredicate, MemoryModuleType<GlobalPos> poiPosModule, MemoryModuleType<GlobalPos> potentialPoiPosModule, boolean onlyRunIfChild, Optional<Byte> entityStatus) {
        MutableLong cooldown = new MutableLong(0L);
        Long2ObjectOpenHashMap long2ObjectMap = new Long2ObjectOpenHashMap();
        OneShot singleTickTask = BehaviorBuilder.create(arg_0 -> LazyFindPointOfInterestTask.lambda$create$8(potentialPoiPosModule, onlyRunIfChild, cooldown, (Long2ObjectMap)long2ObjectMap, poiPredicate, entityStatus, arg_0));
        return potentialPoiPosModule == poiPosModule ? singleTickTask : BehaviorBuilder.create(context -> context.group((App)context.absent(poiPosModule)).apply((Applicative)context, poiPos -> singleTickTask));
    }

    private static /* synthetic */ App lambda$create$8(MemoryModuleType potentialPoiPosModule, boolean onlyRunIfChild, MutableLong cooldown, Long2ObjectMap long2ObjectMap, Predicate poiPredicate, Optional entityStatus, BehaviorBuilder.Instance taskContext) {
        return taskContext.group((App)taskContext.absent(potentialPoiPosModule)).apply((Applicative)taskContext, queryResult -> (world, entity, time) -> {
            if (onlyRunIfChild && entity.isBaby()) {
                return false;
            }
            if (cooldown.getValue() == 0L) {
                cooldown.setValue(world.getGameTime() + (long)world.random.nextInt(200));
                return false;
            }
            if (world.getGameTime() < cooldown.getValue()) {
                return false;
            }
            cooldown.setValue(time + 200L + (long)world.getRandom().nextInt(200));
            PoiManager pointOfInterestStorage = world.getPoiManager();
            long2ObjectMap.long2ObjectEntrySet().removeIf(entry -> !((RetryMarker)entry.getValue()).isAttempting(time));
            Predicate<BlockPos> predicate2 = pos -> {
                RetryMarker retryMarker = (RetryMarker)long2ObjectMap.get(pos.asLong());
                if (retryMarker == null) {
                    return true;
                }
                if (!retryMarker.shouldRetry(time)) {
                    return false;
                }
                retryMarker.setAttemptTime(time);
                return true;
            };
            Set set = pointOfInterestStorage.findAllClosestFirstWithType(poiPredicate, predicate2, entity.blockPosition(), 48, PoiManager.Occupancy.HAS_SPACE).limit(5L).collect(Collectors.toSet());
            Path path = LazyFindPointOfInterestTask.findPathToPois((Mob)entity, set);
            if (path != null && path.canReach()) {
                BlockPos blockPos = path.getTarget();
                pointOfInterestStorage.getType(blockPos).ifPresent(poiType -> {
                    pointOfInterestStorage.take(poiPredicate, (registryEntry, blockPos2) -> blockPos2.equals((Object)blockPos), blockPos, 1);
                    queryResult.set((Object)GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)blockPos));
                    entityStatus.ifPresent(status -> world.broadcastEntityEvent((Entity)entity, status.byteValue()));
                    long2ObjectMap.clear();
                    DebugPackets.sendPoiTicketCountPacket((ServerLevel)world, (BlockPos)blockPos);
                });
            } else {
                for (Pair registryEntryBlockPosPair : set) {
                    long2ObjectMap.computeIfAbsent(((BlockPos)registryEntryBlockPosPair.getSecond()).asLong(), m -> new RetryMarker(world.random, time));
                }
            }
            return true;
        });
    }

    private static class RetryMarker {
        private static final int MIN_DELAY = 40;
        private static final int ATTEMPT_DURATION = 400;
        private final RandomSource random;
        private long previousAttemptAt;
        private long nextScheduledAttemptAt;
        private int currentDelay;

        RetryMarker(RandomSource random, long time) {
            this.random = random;
            this.setAttemptTime(time);
        }

        public void setAttemptTime(long time) {
            this.previousAttemptAt = time;
            int i = this.currentDelay + this.random.nextInt(40) + 40;
            this.currentDelay = Math.min(i, 400);
            this.nextScheduledAttemptAt = time + (long)this.currentDelay;
        }

        public boolean isAttempting(long time) {
            return time - this.previousAttemptAt < 400L;
        }

        public boolean shouldRetry(long time) {
            return time >= this.nextScheduledAttemptAt;
        }

        public String toString() {
            return "RetryMarker{, previousAttemptAt=" + this.previousAttemptAt + ", nextScheduledAttemptAt=" + this.nextScheduledAttemptAt + ", currentDelay=" + this.currentDelay + "}";
        }
    }
}

