/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.Nullable;

public class SmarterOpenDoorsTask
extends Behavior<LivingEntity> {
    private static final int RUN_TIME = 20;
    private static final double PATHING_DISTANCE = 2.0;
    private static final double REACH_DISTANCE = 2.0;
    @Nullable
    private Node pathNode;
    private int ticks;

    public SmarterOpenDoorsTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.PATH, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.DOORS_TO_CLOSE, (Object)MemoryStatus.REGISTERED));
    }

    public static boolean setOpen(@Nullable Entity entity, Level world, BlockState state, BlockPos pos, boolean open) {
        if (state.hasProperty((Property)BlockStateProperties.OPEN) && (Boolean)state.getValue((Property)BlockStateProperties.OPEN) != open) {
            world.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(open)), 10);
            world.gameEvent(entity, (Holder)(open ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
            SmarterOpenDoorsTask.playOpenCloseSound(entity, world, pos, open);
            return true;
        }
        return false;
    }

    private static void playOpenCloseSound(@Nullable Entity entity, Level world, BlockPos pos, boolean open) {
        world.playSound(entity, pos, open ? SoundEvents.WOODEN_DOOR_OPEN : SoundEvents.WOODEN_DOOR_CLOSE, SoundSource.BLOCKS, 0.75f, world.getRandom().nextFloat() * 0.1f + 0.9f);
    }

    private static boolean isDoor(BlockState blockState) {
        return blockState.is(BlockTags.WOODEN_DOORS, state -> state.getBlock() instanceof DoorBlock) || blockState.is(BlockTags.FENCE_GATES, state -> state.getBlock() instanceof FenceGateBlock);
    }

    public static void closeDoors(ServerLevel world, LivingEntity entity, @Nullable Node lastNode, @Nullable Node currentNode) {
        Brain brain = entity.getBrain();
        if (brain.hasMemoryValue(MemoryModuleType.DOORS_TO_CLOSE)) {
            Iterator iterator = ((Set)brain.getMemoryInternal(MemoryModuleType.DOORS_TO_CLOSE).get()).iterator();
            while (iterator.hasNext()) {
                GlobalPos globalPos = (GlobalPos)iterator.next();
                BlockPos blockPos = globalPos.pos();
                if (lastNode != null && lastNode.asBlockPos().equals((Object)blockPos) || currentNode != null && currentNode.asBlockPos().equals((Object)blockPos)) continue;
                if (SmarterOpenDoorsTask.cannotReachDoor(world, entity, globalPos)) {
                    iterator.remove();
                    continue;
                }
                BlockState blockState = world.getBlockState(blockPos);
                if (!SmarterOpenDoorsTask.isDoor(blockState)) {
                    iterator.remove();
                    continue;
                }
                if (blockState.hasProperty((Property)BlockStateProperties.OPEN) && !((Boolean)blockState.getValue((Property)BlockStateProperties.OPEN)).booleanValue()) {
                    iterator.remove();
                    continue;
                }
                if (SmarterOpenDoorsTask.hasOtherMobReachedDoor(entity, blockPos)) {
                    iterator.remove();
                    continue;
                }
                SmarterOpenDoorsTask.setOpen((Entity)entity, (Level)world, blockState, blockPos, false);
                iterator.remove();
            }
        }
    }

    private static boolean hasOtherMobReachedDoor(LivingEntity entity, BlockPos pos) {
        Brain brain = entity.getBrain();
        if (!brain.hasMemoryValue(MemoryModuleType.NEAREST_LIVING_ENTITIES)) {
            return false;
        }
        return ((List)brain.getMemoryInternal(MemoryModuleType.NEAREST_LIVING_ENTITIES).get()).stream().filter(livingEntity2 -> livingEntity2.getType() == entity.getType()).filter(livingEntity -> pos.closerToCenterThan((Position)livingEntity.position(), 2.0)).anyMatch(livingEntity -> SmarterOpenDoorsTask.hasReached(livingEntity, pos));
    }

    private static boolean hasReached(LivingEntity entity, BlockPos pos) {
        if (!entity.getBrain().hasMemoryValue(MemoryModuleType.PATH)) {
            return false;
        }
        Path path = (Path)entity.getBrain().getMemoryInternal(MemoryModuleType.PATH).get();
        if (path.isDone()) {
            return false;
        }
        Node pathNode = path.getPreviousNode();
        if (pathNode == null) {
            return false;
        }
        return pos.equals((Object)pathNode.asBlockPos()) || pos.equals((Object)path.getNextNode().asBlockPos());
    }

    private static boolean cannotReachDoor(ServerLevel world, LivingEntity entity, GlobalPos doorPos) {
        return doorPos.dimension() != world.dimension() || !doorPos.pos().closerToCenterThan((Position)entity.position(), 2.0);
    }

    protected boolean checkExtraStartConditions(ServerLevel world, LivingEntity entity) {
        Optional optionalMemory = entity.getBrain().getMemoryInternal(MemoryModuleType.PATH);
        if (optionalMemory.isEmpty()) {
            return false;
        }
        Path path = (Path)optionalMemory.get();
        if (path.isDone()) {
            return false;
        }
        if (!Objects.equals(this.pathNode, path.getNextNode())) {
            this.ticks = 20;
            return true;
        }
        if (this.ticks > 0) {
            --this.ticks;
        }
        return this.ticks == 0;
    }

    private void openDoor(ServerLevel world, LivingEntity entity, Node pathNode) {
        BlockPos blockPos;
        BlockState blockState;
        if (pathNode != null && SmarterOpenDoorsTask.isDoor(blockState = world.getBlockState(blockPos = pathNode.asBlockPos())) && SmarterOpenDoorsTask.setOpen((Entity)entity, (Level)world, blockState, blockPos, true)) {
            this.rememberToCloseDoor(world, entity, blockPos);
        }
    }

    protected void start(ServerLevel world, LivingEntity entity, long time) {
        Path path = (Path)entity.getBrain().getMemoryInternal(MemoryModuleType.PATH).get();
        this.pathNode = path.getNextNode();
        this.openDoor(world, entity, path.getPreviousNode());
        this.openDoor(world, entity, path.getNextNode());
        SmarterOpenDoorsTask.closeDoors(world, entity, path.getPreviousNode(), path.getNextNode());
    }

    private void rememberToCloseDoor(ServerLevel world, LivingEntity entity, BlockPos pos) {
        Brain brain = entity.getBrain();
        GlobalPos globalPos = GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)pos);
        if (brain.getMemoryInternal(MemoryModuleType.DOORS_TO_CLOSE).isPresent()) {
            ((Set)brain.getMemoryInternal(MemoryModuleType.DOORS_TO_CLOSE).get()).add(globalPos);
        } else {
            brain.setMemory(MemoryModuleType.DOORS_TO_CLOSE, (Object)Sets.newHashSet((Object[])new GlobalPos[]{globalPos}));
        }
    }
}

