/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.brain.tasks.chore;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.conczin.mca.Config;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.Chore;
import net.conczin.mca.entity.ai.TaskUtils;
import net.conczin.mca.entity.ai.brain.tasks.chore.AbstractChoreTask;
import net.conczin.mca.util.InventoryUtils;
import net.conczin.mca.util.RegistryHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ChoppingTask
extends AbstractChoreTask {
    private int chopTicks;
    private int targetTreeTicks;
    private BlockPos targetTree;

    public ChoppingTask() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel world, VillagerEntityMCA villager) {
        return villager.getVillagerBrain().getCurrentJob() == Chore.CHOP && super.checkExtraStartConditions(world, villager);
    }

    protected boolean canStillUse(ServerLevel world, VillagerEntityMCA villager, long time) {
        return this.checkExtraStartConditions(world, villager);
    }

    protected void stop(ServerLevel world, VillagerEntityMCA villager, long time) {
        ItemStack stack = villager.getItemInHand(villager.getDominantHand());
        if (!stack.isEmpty()) {
            villager.setItemInHand(villager.getDominantHand(), ItemStack.EMPTY);
        }
    }

    @Override
    protected void start(ServerLevel world, VillagerEntityMCA villager, long time) {
        super.start(world, villager, time);
        if (!villager.hasItemInSlot(villager.getDominantSlot())) {
            int i = InventoryUtils.getFirstSlotContainingItem((Container)villager.getInventory(), stack -> stack.getItem() instanceof AxeItem);
            if (i == -1) {
                this.abandonJobWithMessage("chore.chopping.noaxe");
            } else {
                villager.setItemInHand(villager.getDominantHand(), villager.getInventory().getItem(i));
            }
        }
    }

    @Override
    protected void tick(ServerLevel world, VillagerEntityMCA villager, long time) {
        if (this.villager == null) {
            this.villager = villager;
        }
        if (!InventoryUtils.contains((Container)villager.getInventory(), AxeItem.class) && !villager.hasItemInSlot(villager.getDominantSlot())) {
            this.abandonJobWithMessage("chore.chopping.noaxe");
        } else if (!villager.hasItemInSlot(villager.getDominantSlot())) {
            int i = InventoryUtils.getFirstSlotContainingItem((Container)villager.getInventory(), stack -> stack.getItem() instanceof AxeItem);
            ItemStack stack2 = villager.getInventory().getItem(i);
            villager.setItemInHand(villager.getDominantHand(), stack2);
        }
        if (this.targetTree == null) {
            List<BlockPos> nearbyLogs = TaskUtils.getNearbyBlocks(villager.blockPosition(), (Level)world, blockState -> blockState.is(BlockTags.LOGS), 15, 5);
            ArrayList<BlockPos> nearbyTrees = new ArrayList<BlockPos>();
            nearbyLogs.stream().filter(log -> this.isTreeStartLog(world, (BlockPos)log)).forEach(nearbyTrees::add);
            this.targetTree = TaskUtils.getNearestPoint(villager.blockPosition(), nearbyTrees);
            if (this.targetTree != null) {
                BlockState state;
                ItemStack stack3 = villager.getItemInHand(villager.getDominantHand());
                BlockPos pos = this.targetTree;
                while ((state = world.getBlockState(pos)).is(BlockTags.LOGS)) {
                    this.targetTreeTicks += (int)((float)this.getTicksFor(state, 60) / stack3.getDestroySpeed(state));
                    pos = pos.offset(0, 1, 0);
                }
            }
            this.failedTicks = 100;
            return;
        }
        villager.moveTowards(this.targetTree);
        BlockState state = world.getBlockState(this.targetTree);
        if (state.is(BlockTags.LOGS)) {
            villager.swing(villager.getDominantHand());
            ++this.chopTicks;
            if (this.chopTicks >= this.targetTreeTicks) {
                this.chopTicks = 0;
                this.destroyTree(world, this.targetTree);
            }
        } else {
            this.targetTree = null;
            this.targetTreeTicks = 0;
        }
        super.tick(world, villager, time);
    }

    private boolean isTreeStartLog(ServerLevel world, BlockPos origin) {
        if (!world.getBlockState(origin).is(BlockTags.LOGS)) {
            return false;
        }
        if (!this.isValidTree(world, origin.below())) {
            return false;
        }
        BlockPos.MutableBlockPos posUp = origin.mutable();
        for (int y = 0; y < Config.getInstance().maxTreeHeight; ++y) {
            BlockState up = world.getBlockState((BlockPos)posUp.setY(posUp.getY() + 1));
            if (up.is(BlockTags.LOGS)) continue;
            return up.is(BlockTags.LEAVES);
        }
        return false;
    }

    private void destroyTree(ServerLevel world, BlockPos origin) {
        BlockState state;
        ItemStack stack = this.villager.getItemInHand(this.villager.getDominantHand());
        BlockPos pos = origin;
        while ((state = world.getBlockState(pos)).is(BlockTags.LOGS) && world.destroyBlock(pos, false, (Entity)this.villager)) {
            pos = pos.offset(0, 1, 0);
            this.villager.getInventory().addItem(new ItemStack((ItemLike)state.getBlock(), 1));
            stack.hurtAndBreak(1, (LivingEntity)this.villager, EquipmentSlot.MAINHAND);
        }
    }

    private boolean isValidTree(ServerLevel world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        ResourceLocation stateId = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        for (String blockId : Config.getInstance().validTreeSources) {
            if (blockId.equals(stateId.toString())) {
                return true;
            }
            if (blockId.charAt(0) != '#') continue;
            ResourceLocation identifier = ResourceLocation.parse((String)blockId.substring(1));
            TagKey tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)identifier);
            if (!RegistryHelper.isTagEmpty(tag)) {
                if (!state.is(tag)) continue;
                return true;
            }
            throw new JsonSyntaxException("Unknown block tag in validTreeSources '" + String.valueOf(identifier) + "'");
        }
        return false;
    }

    private int getTicksFor(BlockState state, int fallback) {
        Map<String, Integer> sources = Config.getInstance().maxTreeTicks;
        ResourceLocation stateId = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        for (String blockId : sources.keySet()) {
            if (blockId.equals(stateId.toString())) {
                return sources.get(blockId);
            }
            if (blockId.charAt(0) != '#') continue;
            ResourceLocation identifier = ResourceLocation.parse((String)blockId.substring(1));
            TagKey tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)identifier);
            if (!RegistryHelper.isTagEmpty(tag)) {
                if (!state.is(tag)) continue;
                return sources.get(blockId);
            }
            throw new JsonSyntaxException("Unknown block tag in maxTreeTicks '" + String.valueOf(identifier) + "'");
        }
        return fallback;
    }
}

