/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.brain.tasks.chore;

import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.Chore;
import net.conczin.mca.entity.ai.TaskUtils;
import net.conczin.mca.entity.ai.brain.tasks.chore.AbstractChoreTask;
import net.conczin.mca.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class FishingTask
extends AbstractChoreTask {
    private BlockPos targetWater;
    private boolean hasCastRod;
    private int ticks;
    private List<ItemStack> list;

    public FishingTask() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel world, VillagerEntityMCA villager) {
        return villager.getVillagerBrain().getCurrentJob() == Chore.FISH && super.checkExtraStartConditions(world, villager);
    }

    protected boolean canStillUse(ServerLevel world, VillagerEntityMCA villager, long time) {
        return this.checkExtraStartConditions(world, villager);
    }

    @Override
    protected void start(ServerLevel world, VillagerEntityMCA villager, long time) {
        super.start(world, villager, time);
        if (!villager.hasItemInSlot(villager.getDominantSlot())) {
            int i = InventoryUtils.getFirstSlotContainingItem((Container)villager.getInventory(), stack -> stack.getItem() instanceof FishingRodItem);
            if (i == -1) {
                this.abandonJobWithMessage("chore.fishing.norod");
            } else {
                villager.setItemInHand(villager.getDominantHand(), villager.getInventory().getItem(i));
            }
        }
        LootTable loottable = world.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.FISHING);
        LootParams.Builder lootcontext$builder = new LootParams.Builder(world).withParameter(LootContextParams.ORIGIN, (Object)villager.position()).withParameter(LootContextParams.TOOL, (Object)new ItemStack((ItemLike)Items.FISHING_ROD)).withParameter(LootContextParams.THIS_ENTITY, (Object)villager).withLuck(0.0f);
        this.list = loottable.getRandomItems(lootcontext$builder.create(LootContextParamSets.FISHING));
    }

    @Override
    protected void tick(ServerLevel world, VillagerEntityMCA villager, long time) {
        super.tick(world, villager, time);
        if (!InventoryUtils.contains((Container)villager.getInventory(), FishingRodItem.class) && !villager.hasItemInSlot(villager.getDominantSlot())) {
            this.abandonJobWithMessage("chore.fishing.norod");
        } else if (!villager.hasItemInSlot(villager.getDominantSlot())) {
            int i = InventoryUtils.getFirstSlotContainingItem((Container)villager.getInventory(), stack -> stack.getItem() instanceof FishingRodItem);
            ItemStack stack2 = villager.getInventory().getItem(i);
            villager.setItemInHand(villager.getDominantHand(), stack2);
        }
        if (this.targetWater == null) {
            List<BlockPos> nearbyStaticLiquid = TaskUtils.getNearbyBlocks(villager.blockPosition(), villager.level(), blockState -> blockState.is(Blocks.WATER), 12, 3);
            this.targetWater = nearbyStaticLiquid.stream().filter(p -> villager.level().getBlockState(p).getBlock() == Blocks.WATER).min(Comparator.comparingDouble(d -> villager.distanceToSqr(d.getX(), d.getY(), d.getZ()))).orElse(null);
            if (this.targetWater == null) {
                this.failedTicks = 100;
            }
        } else if (villager.distanceToSqr(this.targetWater.getX(), this.targetWater.getY(), this.targetWater.getZ()) < 5.0) {
            villager.getNavigation().stop();
            villager.lookAt(this.targetWater);
            if (!this.hasCastRod) {
                villager.swing(villager.getDominantHand());
                this.hasCastRod = true;
            }
            ++this.ticks;
            if (this.ticks >= villager.level().random.nextInt(200) + 200) {
                if (villager.level().random.nextFloat() >= 0.35f) {
                    ItemStack stack3 = this.list.get(villager.getRandom().nextInt(this.list.size())).copy();
                    villager.swing(villager.getDominantHand());
                    villager.getInventory().addItem(stack3);
                    villager.getMainHandItem().hurtAndBreak(1, (LivingEntity)villager, EquipmentSlot.MAINHAND);
                }
                this.ticks = 0;
            }
        } else {
            villager.moveTowards(this.targetWater);
        }
    }

    protected void stop(ServerLevel world, VillagerEntityMCA villager, long time) {
        ItemStack stack = villager.getItemInHand(villager.getDominantHand());
        if (!stack.isEmpty()) {
            villager.setItemInHand(villager.getDominantHand(), ItemStack.EMPTY);
        }
    }
}

