/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.chatAI;

import java.text.Normalizer;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import net.conczin.mca.Config;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.chatAI.ChatAIStrategy;
import net.conczin.mca.entity.ai.chatAI.InworldAI;
import net.conczin.mca.entity.ai.chatAI.OpenAIChatAI;
import net.conczin.mca.util.WorldUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class ChatAI {
    private static final int VILLAGER_SEARCH_RANGE = 32;
    private static final int CONVERSATION_TIME = 1200;
    private static final int CONVERSATION_DISTANCE = 16;
    private static final Map<UUID, ChatAIStrategy> strategies = new HashMap<UUID, ChatAIStrategy>();
    private static final Map<UUID, OpenConversation> currentConversations = new ConcurrentHashMap<UUID, OpenConversation>();

    public static Optional<String> answer(ServerPlayer player, VillagerEntityMCA villager, String msg) {
        ChatAIStrategy strategy = ChatAI.computeStrategyIfAbsent(villager.getUUID());
        long time = villager.level().getGameTime();
        currentConversations.put(player.getUUID(), new OpenConversation(villager.getUUID(), time));
        return strategy.answer(player, villager, msg);
    }

    private static ChatAIStrategy computeStrategyIfAbsent(UUID villagerID) {
        return strategies.computeIfAbsent(villagerID, v -> {
            String inworldResourceName = Config.getInstance().inworldAIResourceNames.getOrDefault(v, "");
            return inworldResourceName.isEmpty() ? new OpenAIChatAI() : new InworldAI(inworldResourceName);
        });
    }

    public static void clearStrategy(UUID villagerID) {
        strategies.remove(villagerID);
    }

    private static String getName(VillagerEntityMCA villager) {
        return ChatAI.normalizeString(villager.getName().getString());
    }

    public static Optional<VillagerEntityMCA> getVillagerForConversation(ServerPlayer player, String msg) {
        UUID playerUUID = player.getUUID();
        List<VillagerEntityMCA> nearbyVillagers = WorldUtils.getCloseEntities(player.level(), (Entity)player, 32.0, VillagerEntityMCA.class);
        String normalizedMsg = ChatAI.normalizeString(msg);
        for (VillagerEntityMCA villager : nearbyVillagers) {
            String[] nameParts;
            String normalizedName = ChatAI.getName(villager);
            for (String part : nameParts = normalizedName.split(" ")) {
                if (!Pattern.compile("\\b" + Pattern.quote(part) + "\\b").matcher(normalizedMsg).find()) continue;
                return Optional.of(villager);
            }
        }
        OpenConversation conv = currentConversations.getOrDefault(playerUUID, new OpenConversation(playerUUID, 0L));
        Optional<VillagerEntityMCA> optionalVillager = nearbyVillagers.stream().filter(v -> conv.villagerUUID.equals(v.getUUID())).findFirst();
        if (optionalVillager.isPresent() && ChatAI.isInConversationWith(player, optionalVillager.get())) {
            return optionalVillager;
        }
        return Optional.empty();
    }

    private static boolean isInConversationWith(ServerPlayer player, VillagerEntityMCA villager) {
        OpenConversation conversation = currentConversations.getOrDefault(player.getUUID(), new OpenConversation(villager.getUUID(), 0L));
        return villager.distanceTo((Entity)player) < 16.0f && villager.level().getGameTime() < conversation.lastInteractionTime + 1200L;
    }

    public static Optional<VillagerEntityMCA> findVillagerInArea(ServerPlayer player, String searchName) {
        List<VillagerEntityMCA> entities = WorldUtils.getCloseEntities(player.level(), (Entity)player, 32.0, VillagerEntityMCA.class);
        String normalizedSearchName = ChatAI.normalizeString(searchName);
        for (VillagerEntityMCA villager : entities) {
            String villagerName = ChatAI.getName(villager);
            if (!normalizedSearchName.equals(villagerName)) continue;
            return Optional.of(villager);
        }
        return Optional.empty();
    }

    private static String normalizeString(String string) {
        return Normalizer.normalize(string, Normalizer.Form.NFD).replaceAll("\\p{M}", "").toLowerCase(Locale.ROOT);
    }

    private record OpenConversation(UUID villagerUUID, Long lastInteractionTime) {
    }
}

