/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.chatAI;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.conczin.mca.Config;
import net.conczin.mca.MCA;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.Messenger;
import net.conczin.mca.entity.ai.chatAI.ChatAIStrategy;
import net.conczin.mca.entity.ai.chatAI.TriggerCommandInfo;
import net.conczin.mca.entity.ai.chatAI.TriggerCommandInfos;
import net.conczin.mca.entity.ai.chatAI.modules.EnvironmentModule;
import net.conczin.mca.entity.ai.chatAI.modules.PersonalityModule;
import net.conczin.mca.entity.ai.chatAI.modules.PlayerModule;
import net.conczin.mca.entity.ai.chatAI.modules.RelationModule;
import net.conczin.mca.entity.ai.chatAI.modules.TraitsModule;
import net.conczin.mca.entity.ai.chatAI.modules.VillageModule;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class OpenAIChatAI
implements ChatAIStrategy {
    private static final int MAX_MEMORY = 500;
    private static final int MAX_MEMORY_TIME = 54000;
    private static final Map<UUID, List<Tuple<String, String>>> memory = new HashMap<UUID, List<Tuple<String, String>>>();
    private static final Map<UUID, Long> lastInteractions = new HashMap<UUID, Long>();

    public static String translate(String phrase) {
        return phrase.replace("_", " ").toLowerCase(Locale.ROOT).replace("mca.", "");
    }

    private static HttpURLConnection getHttpURLConnection(String url, String token) throws IOException {
        HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.toString());
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("Accept", "application/json");
        con.setRequestProperty("Authorization", "Bearer " + token);
        con.setDoOutput(true);
        return con;
    }

    private static Answer parseAnswer(String body) {
        StructuredResponse structuredReply;
        String error;
        JsonObject map = JsonParser.parseString((String)body).getAsJsonObject();
        String message = map.has("choices") ? map.getAsJsonArray("choices").get(0).getAsJsonObject().getAsJsonObject("message").getAsJsonPrimitive("content").getAsString() : null;
        String string = error = map.has("error") ? map.get("error").getAsString().trim().replace("\n", " ") : null;
        if (message != null) {
            message = message.replaceAll("```", "");
            int bracketStart = message.indexOf("{");
            int bracketEnd = message.lastIndexOf("}");
            if (bracketEnd > bracketStart && bracketStart != -1) {
                message = message.substring(bracketStart, bracketEnd + 1);
            }
        }
        try {
            structuredReply = (StructuredResponse)new Gson().fromJson(message, StructuredResponse.class);
        }
        catch (JsonSyntaxException e) {
            MCA.LOGGER.warn("Error parsing answer: {} ({})", (Object)message, (Object)e.getMessage());
            structuredReply = new StructuredResponse(OpenAIChatAI.cleanupAnswer(message), "");
        }
        return new Answer(structuredReply, error);
    }

    public static Answer post(String url, String requestBody, String token) {
        try {
            HttpURLConnection con = OpenAIChatAI.getHttpURLConnection(url, token);
            try (DataOutputStream wr = new DataOutputStream(con.getOutputStream());){
                wr.write(requestBody.getBytes(StandardCharsets.UTF_8));
                wr.flush();
            }
            InputStream response = con.getInputStream();
            String body = IOUtils.toString((InputStream)response, (Charset)StandardCharsets.UTF_8);
            return OpenAIChatAI.parseAnswer(body);
        }
        catch (Exception e) {
            MCA.LOGGER.error((Object)e);
            return new Answer(null, "Unknown error, check log!");
        }
    }

    public static String verify(String encodedURL) {
        try {
            HttpURLConnection con = (HttpURLConnection)new URL(encodedURL).openConnection();
            con.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.toString());
            InputStream response = con.getInputStream();
            String body = IOUtils.toString((InputStream)response, (Charset)StandardCharsets.UTF_8);
            JsonObject map = JsonParser.parseString((String)body).getAsJsonObject();
            return map.has("answer") ? map.get("answer").getAsString().trim().replace("\n", " ") : "";
        }
        catch (Exception e) {
            MCA.LOGGER.error((Object)e);
            return "error";
        }
    }

    static String jsonStringQuote(String string) {
        StringBuilder sb = new StringBuilder("\"");
        for (char c : string.toCharArray()) {
            sb.append(switch (c) {
                case '\"', '/', '\\' -> "\\" + c;
                case '\b' -> "\\b";
                case '\t' -> "\\t";
                case '\n' -> "\\n";
                case '\f' -> "\\f";
                case '\r' -> "\\r";
                default -> c < ' ' ? String.format(Locale.ROOT, "\\u%04x", Character.valueOf(c)) : Character.valueOf(c);
            });
        }
        return sb.append('\"').toString();
    }

    static String cleanupAnswer(String answer) {
        if (answer == null) {
            return null;
        }
        answer = answer.replace("\"", "");
        answer = answer.replace("\n", " ");
        String[] parts = answer.split(":", 2);
        return parts[parts.length - 1].strip();
    }

    @Override
    public Optional<String> answer(ServerPlayer player, VillagerEntityMCA villager, String msg) {
        try {
            List<Object> validCommands;
            Config config = Config.getInstance();
            boolean isInHouse = config.villagerChatAIEndpoint.contains("conczin.net");
            String playerName = Messenger.getName(player);
            String villagerName = villager.getName().getString();
            long time = villager.level().getGameTime();
            if (time > lastInteractions.getOrDefault(villager.getUUID(), 0L) + 54000L) {
                memory.remove(villager.getUUID());
            }
            lastInteractions.put(villager.getUUID(), time);
            List pastDialogue = memory.computeIfAbsent(villager.getUUID(), key -> new LinkedList());
            while (pastDialogue.stream().mapToInt(v -> ((String)v.getB()).length() / 4).sum() > 500) {
                pastDialogue.removeFirst();
            }
            LinkedList<String> input = new LinkedList<String>();
            PersonalityModule.apply(input, villager, player);
            TraitsModule.apply(input, villager, player);
            RelationModule.apply(input, villager, player);
            VillageModule.apply(input, villager, player);
            EnvironmentModule.apply(input, villager, player);
            PlayerModule.apply(input, villager, player);
            Map<String, String> variables = Map.of("player", playerName, "villager", villagerName);
            StringBuilder sb = new StringBuilder();
            if (isInHouse || config.villagerChatAIIncludeSessionInformation) {
                long seed = player.serverLevel().getSeed();
                sb.append("[world_id:").append(seed).append("]");
                sb.append("[player_id:").append(player.getUUID()).append("]");
                sb.append("[character_id:").append(villager.getUUID()).append("]");
                if (config.villagerChatAIUseLongTermMemory) {
                    sb.append("[use_memory:true]");
                }
                if (config.villagerChatAIUseSharedLongTermMemory) {
                    sb.append("[shared_memory:true]");
                }
            }
            if (!config.villagerChatAISystemPrompt.isEmpty()) {
                sb.append(config.villagerChatAISystemPrompt);
                sb.append("\n");
            } else if (!isInHouse) {
                String defaultPrompt = "You are a Minecraft villager, fully immersed in their virtual world, unaware of its artificial nature. You respond based on your description, your role, and your knowledge of the world. You have no knowledge of the real world, and do not realize that you are within Minecraft. You are no assistant! You can be sarcastic, funny, or even rude when appropriate.";
                sb.append(defaultPrompt);
                sb.append("\n");
            }
            for (String s2 : input) {
                for (Map.Entry<String, String> entry : variables.entrySet()) {
                    s2 = s2.replaceAll("\\$" + entry.getKey(), entry.getValue());
                }
                sb.append(s2);
            }
            if (MCA.language != null) {
                sb.append("Match the language of the player, and use ").append(MCA.language).append(" when unsure.");
            }
            if (config.villagerChatAIUseTools) {
                validCommands = TriggerCommandInfos.triggerCommands.stream().filter(c -> c.isActive == null || c.isActive.test(player, villager)).toList();
                MCA.LOGGER.info("Valid commands: {}", validCommands.stream().map(c -> c.command).toList());
            } else {
                validCommands = List.of();
            }
            if (!validCommands.isEmpty()) {
                String structureExample = new Gson().toJson((Object)new StructuredResponse("example message to say", ((TriggerCommandInfo)validCommands.getFirst()).command));
                sb.append("\n\n");
                sb.append("The reply MUST be in this JSON format: ").append(structureExample).append("\n");
                sb.append("The following commands are valid:\n");
                for (Object command : validCommands) {
                    sb.append("  * ").append(((TriggerCommandInfo)command).command).append(": ").append(((TriggerCommandInfo)command).description).append("\n");
                }
                sb.append("Only use a command when the player asks for it.");
            }
            String system = sb.toString();
            StringBuilder body = new StringBuilder();
            body.append("{");
            body.append("\"model\": \"").append(config.villagerChatAIModel).append("\",");
            body.append("\"messages\": [");
            body.append("{\"role\": \"system\", \"content\": ").append(OpenAIChatAI.jsonStringQuote(system)).append("},");
            for (Tuple pair : pastDialogue) {
                String role = (String)pair.getA();
                String content = (String)pair.getB();
                String name = role.equals("user") ? playerName : villagerName;
                body.append("{\"role\": \"").append(role).append("\", \"name\": \"").append(name).append("\", \"content\": ").append(OpenAIChatAI.jsonStringQuote(content)).append("},");
            }
            body.append("{\"role\": \"user\", \"name\": \"").append(playerName).append("\", \"content\": ").append(OpenAIChatAI.jsonStringQuote(msg)).append("}");
            body.append("]");
            body.append("}");
            String token = config.villagerChatAIToken;
            if (token.isEmpty() || config.villagerChatAIEndpoint.contains("conczin.net")) {
                token = variables.get("player");
            }
            Answer message = OpenAIChatAI.post(config.villagerChatAIEndpoint, body.toString(), token);
            if (message.error == null) {
                if (message.answer != null) {
                    pastDialogue.add(new Tuple((Object)"user", (Object)msg));
                    pastDialogue.add(new Tuple((Object)"assistant", (Object)(message.answer.message != null ? message.answer.message : "...")));
                    if (message.answer.optionalCommand() != null && !message.answer.optionalCommand().isEmpty()) {
                        Optional<TriggerCommandInfo> command = TriggerCommandInfos.findCommand(message.answer.optionalCommand(), player, villager);
                        command.ifPresent(triggerCommandInfo -> triggerCommandInfo.call.accept(player, villager));
                    }
                }
                return Optional.ofNullable(message.answer != null ? message.answer.message : null);
            }
            if (message.error.equals("invalid_model")) {
                player.displayClientMessage((Component)Component.literal((String)"Invalid model!").withStyle(ChatFormatting.RED), false);
            } else if (message.error.equals("limit")) {
                MutableComponent styled = Component.translatable((String)"mca.limit.patreon").withStyle(s -> s.withColor(ChatFormatting.GOLD).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Luke100000/minecraft-comes-alive/wiki/GPT3-based-conversations#increase-conversation-limit")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"mca.limit.patreon.hover"))));
                player.displayClientMessage((Component)styled, false);
            } else if (message.error.equals("limit_premium")) {
                player.displayClientMessage((Component)Component.translatable((String)"mca.limit.premium").withStyle(ChatFormatting.RED), false);
            } else {
                player.displayClientMessage((Component)Component.literal((String)message.error).withStyle(ChatFormatting.RED), false);
            }
        }
        catch (Exception e) {
            MCA.LOGGER.error("Failed to parse LLM response!", (Throwable)e);
            player.displayClientMessage((Component)Component.translatable((String)"mca.ai_broken").withStyle(ChatFormatting.RED), false);
        }
        return Optional.empty();
    }

    public record StructuredResponse(@Nullable String message, String optionalCommand) {
    }

    public record Answer(StructuredResponse answer, String error) {
    }
}

