/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.interaction;

import java.util.Comparator;
import java.util.Optional;
import net.conczin.mca.Config;
import net.conczin.mca.MCA;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.Chore;
import net.conczin.mca.entity.ai.Memories;
import net.conczin.mca.entity.ai.MoveState;
import net.conczin.mca.entity.ai.relationship.RelationshipState;
import net.conczin.mca.entity.interaction.EntityCommandHandler;
import net.conczin.mca.mixin.MixinVillagerInvoker;
import net.conczin.mca.registry.CriterionMCA;
import net.conczin.mca.registry.ItemsMCA;
import net.conczin.mca.registry.ProfessionsMCA;
import net.conczin.mca.server.world.data.FamilyTree;
import net.conczin.mca.server.world.data.FamilyTreeNode;
import net.conczin.mca.server.world.data.PlayerSaveData;
import net.conczin.mca.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class VillagerCommandHandler
extends EntityCommandHandler<VillagerEntityMCA> {
    public VillagerCommandHandler(VillagerEntityMCA entity) {
        super(entity);
    }

    @Override
    public boolean handle(ServerPlayer player, String command) {
        Memories memory = ((VillagerEntityMCA)this.entity).getVillagerBrain().getMemoriesForPlayer((Player)player);
        if (MoveState.byCommand(command).filter(state -> {
            ((VillagerEntityMCA)this.entity).getVillagerBrain().setMoveState((MoveState)((Object)state), (Player)player);
            return true;
        }).isPresent()) {
            return true;
        }
        if (Chore.byCommand(command).filter(chore -> {
            ((VillagerEntityMCA)this.entity).getVillagerBrain().assignJob((Chore)((Object)chore), (Player)player);
            CriterionMCA.GENERIC_EVENT.trigger(player, "chores");
            ((VillagerEntityMCA)this.entity).sendChatMessage((Component)Component.translatable((String)"chore.success"), (Entity)player);
            return true;
        }).isPresent()) {
            return true;
        }
        String arg = "";
        String[] split = command.split("\\.");
        if (split.length > 1) {
            command = split[0];
            arg = split[1];
        }
        switch (command) {
            case "pick_up": {
                if (player.getPassengers().size() >= 3) {
                    ((Entity)player.getPassengers().getFirst()).stopRiding();
                }
                if (((VillagerEntityMCA)this.entity).isPassenger()) {
                    ((VillagerEntityMCA)this.entity).stopRiding();
                } else {
                    ((VillagerEntityMCA)this.entity).startRiding((Entity)player, true);
                }
                player.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)player));
                return false;
            }
            case "ridehorse": {
                if (((VillagerEntityMCA)this.entity).isPassenger()) {
                    ((VillagerEntityMCA)this.entity).stopRiding();
                } else {
                    ((VillagerEntityMCA)this.entity).level().getEntities((Entity)player, player.getBoundingBox().inflate(10.0), e -> e instanceof Saddleable && ((Saddleable)e).isSaddled()).stream().filter(horse -> !horse.isVehicle()).min(Comparator.comparingDouble(a -> a.distanceToSqr(this.entity))).ifPresentOrElse(horse -> {
                        ((VillagerEntityMCA)this.entity).startRiding((Entity)horse, false);
                        ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "interaction.ridehorse.success", new Object[0]);
                    }, () -> ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "interaction.ridehorse.fail.notnearby", new Object[0]));
                }
                return true;
            }
            case "sethome": {
                ((VillagerEntityMCA)this.entity).getResidency().setHome(player);
                return true;
            }
            case "gohome": {
                ((VillagerEntityMCA)this.entity).getResidency().goHome((Player)player);
                this.stopInteracting();
                return false;
            }
            case "setworkplace": {
                ((VillagerEntityMCA)this.entity).getResidency().setWorkplace(player);
                return true;
            }
            case "trade": {
                ((VillagerEntityMCA)this.entity).getInteractions().stopInteracting();
                MixinVillagerInvoker invoker = (MixinVillagerInvoker)this.entity;
                invoker.invokeStartTrading((Player)player);
                return false;
            }
            case "inventory": {
                player.openMenu((MenuProvider)this.entity);
                return false;
            }
            case "gift": {
                ((VillagerEntityMCA)this.entity).getRelationships().giveGift(player, memory);
                return true;
            }
            case "adopt": {
                ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "interaction.adopt.success", new Object[0]);
                FamilyTreeNode parentNode = FamilyTree.get((ServerLevel)player.level()).getOrCreate((Entity)player);
                ((VillagerEntityMCA)this.entity).getRelationships().getFamilyEntry().assignParent(parentNode);
                Optional<FamilyTreeNode> parentSpouse = FamilyTree.get((ServerLevel)player.level()).getOrEmpty(parentNode.partner());
                parentSpouse.ifPresent(p -> ((VillagerEntityMCA)this.entity).getRelationships().getFamilyEntry().assignParent((FamilyTreeNode)p));
                break;
            }
            case "procreate": {
                if (memory.getHearts() < 100) {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "interaction.procreate.fail.lowhearts", new Object[0]);
                } else if (((VillagerEntityMCA)this.entity).getRelationships().mayProcreateAgain(player.level().getGameTime())) {
                    ((VillagerEntityMCA)this.entity).getRelationships().startProcreating(player.level().getGameTime());
                } else {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "interaction.procreate.fail.toosoon", new Object[0]);
                }
                return true;
            }
            case "divorcePapers": {
                player.getInventory().add(new ItemStack((ItemLike)ItemsMCA.DIVORCE_PAPERS));
                return true;
            }
            case "divorceConfirm": {
                ItemStack papers = ItemsMCA.DIVORCE_PAPERS.getDefaultInstance();
                Memories memories = ((VillagerEntityMCA)this.entity).getVillagerBrain().getMemoriesForPlayer((Player)player);
                if (player.getInventory().contains(papers)) {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "divorcePaper", new Object[0]);
                    player.getInventory().removeItem(papers);
                    memories.modHearts(-20);
                } else {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "divorce", new Object[0]);
                    memories.modHearts(-200);
                }
                ((VillagerEntityMCA)this.entity).getVillagerBrain().modifyMoodValue(-5);
                ((VillagerEntityMCA)this.entity).getRelationships().endRelationShip(RelationshipState.SINGLE);
                PlayerSaveData playerData = PlayerSaveData.get(player);
                playerData.endRelationShip(RelationshipState.SINGLE);
                return true;
            }
            case "execute": {
                ((VillagerEntityMCA)this.entity).setProfession(ProfessionsMCA.OUTLAW);
                return true;
            }
            case "pardon": {
                ((VillagerEntityMCA)this.entity).setProfession(VillagerProfession.NONE);
                return true;
            }
            case "stay_in_village": {
                ((VillagerEntityMCA)this.entity).setProfession(VillagerProfession.NONE);
                ((VillagerEntityMCA)this.entity).setDespawnDelay(0);
                return true;
            }
            case "hire_short": {
                this.payEmeralds(player, 5);
                ((VillagerEntityMCA)this.entity).makeMercenary();
                ((VillagerEntityMCA)this.entity).setDespawnDelay(72000);
                return true;
            }
            case "hire_long": {
                this.payEmeralds(player, 10);
                ((VillagerEntityMCA)this.entity).makeMercenary();
                ((VillagerEntityMCA)this.entity).setDespawnDelay(168000);
                return true;
            }
            case "infected": {
                ((VillagerEntityMCA)this.entity).setInfected(!((VillagerEntityMCA)this.entity).isInfected());
                return true;
            }
            case "stopworking": {
                ((VillagerEntityMCA)this.entity).getVillagerBrain().abandonJob();
                return true;
            }
            case "armor": {
                ((VillagerEntityMCA)this.entity).getVillagerBrain().setArmorWear(!((VillagerEntityMCA)this.entity).getVillagerBrain().getArmorWear());
                if (((VillagerEntityMCA)this.entity).getVillagerBrain().getArmorWear()) {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "armor.enabled", new Object[0]);
                } else {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "armor.disabled", new Object[0]);
                }
                return true;
            }
            case "profession": {
                switch (arg) {
                    case "none": {
                        ((VillagerEntityMCA)this.entity).setProfession(VillagerProfession.NONE);
                        ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "profession.set.none", new Object[0]);
                        break;
                    }
                    case "guard": {
                        ((VillagerEntityMCA)this.entity).setProfession(ProfessionsMCA.GUARD);
                        ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "profession.set.guard", new Object[0]);
                        break;
                    }
                    case "archer": {
                        ((VillagerEntityMCA)this.entity).setProfession(ProfessionsMCA.ARCHER);
                        ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "profession.set.archer", new Object[0]);
                    }
                }
                return true;
            }
            case "apologize": {
                Vec3 pos = ((VillagerEntityMCA)this.entity).position();
                ((VillagerEntityMCA)this.entity).level().getEntitiesOfClass(VillagerEntityMCA.class, new AABB(pos, pos).inflate(32.0)).forEach(v -> {
                    double d = ((VillagerEntityMCA)this.entity).distanceToSqr((Entity)v);
                    int n = v.getTarget() == null ? 1024 : 64;
                    if (d <= (double)n) {
                        v.pardonPlayers(99);
                    }
                });
                break;
            }
            case "location": {
                if (!Config.getInstance().structuresInRumors.isEmpty()) {
                    if (arg.isEmpty()) {
                        arg = Config.getInstance().structuresInRumors.get(((VillagerEntityMCA)this.entity).getRandom().nextInt(Config.getInstance().structuresInRumors.size()));
                    }
                    ServerLevel world = (ServerLevel)((VillagerEntityMCA)this.entity).level();
                    String finalArg = arg;
                    MCA.executorService.execute(() -> {
                        ResourceLocation identifier = ResourceLocation.parse((String)finalArg);
                        BlockPos pos = RandomPos.generateRandomDirection((RandomSource)((VillagerEntityMCA)this.entity).getRandom(), (int)1024, (int)0).offset((Vec3i)((VillagerEntityMCA)this.entity).blockPosition());
                        Optional<BlockPos> position = WorldUtils.getClosestStructurePosition(world, pos, identifier, 64);
                        if (position.isPresent()) {
                            String posString = position.get().getX() + "," + position.get().getY() + "," + position.get().getZ();
                            ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "dialogue.location." + identifier.getPath(), new Object[]{posString});
                        } else {
                            ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "dialogue.location.forgot", new Object[0]);
                        }
                    });
                    break;
                }
                ((VillagerEntityMCA)this.entity).sendChatMessage((Player)player, "dialogue.location.forgot", new Object[0]);
                break;
            }
            case "slap": {
                player.hurt(player.level().damageSources().cramming(), 1.0f);
            }
        }
        return super.handle(player, command);
    }

    private void payEmeralds(ServerPlayer player, int emeralds) {
        Inventory inventory = player.getInventory();
        for (int j = 0; j < inventory.getContainerSize(); ++j) {
            ItemStack itemStack = inventory.getItem(j);
            if (!itemStack.getItem().equals(Items.EMERALD)) continue;
            int c = Math.min(itemStack.getCount(), emeralds);
            itemStack.shrink(c);
            if ((emeralds -= c) > 0) continue;
            return;
        }
    }
}

