/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.interaction.gifts;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.util.Map;
import net.conczin.mca.MCA;
import net.conczin.mca.entity.interaction.gifts.GiftType;
import net.conczin.mca.resources.Resources;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

public class GiftLoader
extends SimpleJsonResourceReloadListener {
    protected static final ResourceLocation ID = MCA.locate("gifts");

    public GiftLoader() {
        super(Resources.GSON, "gifts");
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager manager, ProfilerFiller profiler) {
        GiftType.REGISTRY.clear();
        data.forEach((id, json) -> {
            try {
                GiftType.REGISTRY.add(GiftType.fromJson(id, GsonHelper.convertToJsonObject((JsonElement)json, (String)"root")));
            }
            catch (JsonParseException e) {
                MCA.LOGGER.error("Could not load gift type for id {}", id, (Object)e);
            }
        });
        block0: for (GiftType type : GiftType.REGISTRY) {
            if (type.getId().getNamespace().equals("mca") || !type.getConditions().isEmpty()) continue;
            for (GiftType extendingType : GiftType.REGISTRY) {
                if (!extendingType.getId().getNamespace().equals("mca") || !extendingType.getId().getPath().equals(type.getId().getPath())) continue;
                type.extendFrom(extendingType);
                continue block0;
            }
        }
    }
}

