/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.interaction.gifts;

import java.util.LinkedList;
import java.util.List;
import net.conczin.mca.Config;
import net.conczin.mca.util.NbtHelper;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class GiftSaturation {
    private List<ResourceLocation> values = new LinkedList<ResourceLocation>();

    public void add(ItemStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        this.values.add(id);
        while (this.values.size() > Config.getInstance().giftDesaturationQueueLength) {
            this.pop();
        }
    }

    public int get(ItemStack stack) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        return (int)this.values.stream().filter(v -> v.equals((Object)id)).count();
    }

    public void readFromNbt(ListTag nbt) {
        this.values = NbtHelper.toList((Tag)nbt, v -> ResourceLocation.parse((String)v.getAsString()));
    }

    public ListTag toNbt() {
        return NbtHelper.fromList(this.values, v -> StringTag.valueOf((String)v.toString()));
    }

    public void pop() {
        if (!this.values.isEmpty()) {
            this.values.remove(0);
        }
    }
}

