/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.item;

import net.conczin.mca.Config;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.Relationship;
import net.conczin.mca.entity.ai.relationship.CompassionateEntity;
import net.conczin.mca.item.RelationshipItem;
import net.conczin.mca.server.world.data.PlayerSaveData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class EngagementRingItem
extends RelationshipItem {
    public EngagementRingItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected int getHeartsRequired() {
        return Config.getInstance().engagementHeartsRequirement;
    }

    @Override
    public boolean handle(ServerPlayer player, VillagerEntityMCA villager) {
        String response;
        PlayerSaveData playerData = PlayerSaveData.get(player);
        boolean consume = false;
        if (super.handle(player, villager)) {
            return false;
        }
        if (Relationship.IS_ENGAGED.test((CompassionateEntity<?>)villager, (Entity)player)) {
            response = "interaction.engage.fail.engaged";
        } else {
            response = "interaction.engage.success";
            playerData.engage((Entity)villager);
            villager.getRelationships().engage((Entity)player);
            villager.getVillagerBrain().modifyMoodValue(10);
            consume = true;
        }
        villager.sendChatMessage((Player)player, response, new Object[0]);
        return consume;
    }
}

