/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.item;

import java.util.List;
import net.conczin.mca.client.book.Book;
import net.conczin.mca.client.book.pages.TextPage;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.s2c.OpenGuiRequest;
import net.conczin.mca.registry.DataComponentsMCA;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.Level;

public class ExtendedWrittenBookItem
extends WrittenBookItem {
    private final Book book;

    public ExtendedWrittenBookItem(Item.Properties settings, Book book) {
        super(settings);
        this.book = book;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (this.book.getBookAuthor() != null) {
            tooltipComponents.add(this.book.getBookAuthor());
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Network.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.BOOK), serverPlayer);
        }
        return InteractionResultHolder.success((Object)itemStack);
    }

    public boolean isFoil(ItemStack stack) {
        return false;
    }

    public Book getBook(ItemStack item) {
        List content = (List)item.get(DataComponentsMCA.BOOK_PAGES);
        if (content != null) {
            Book book = this.book.copy();
            for (Component page : content) {
                book.addPage(new TextPage(page));
            }
            return book;
        }
        return this.book;
    }
}

