/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.mixin;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.conczin.mca.Config;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.chatAI.ChatAI;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ServerboundChatPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerGamePacketListenerImpl.class})
public class MixinServerGamePacketListenerImpl {
    @Shadow
    public ServerPlayer player;

    @Inject(method={"handleChat"}, at={@At(value="HEAD")})
    public void mca$injectHandleChat(ServerboundChatPacket message, CallbackInfo ci) {
        String msg;
        if (Config.getInstance().enableVillagerChatAI && !(msg = StringUtils.normalizeSpace((String)message.message())).startsWith("/")) {
            Optional<VillagerEntityMCA> villager = ChatAI.getVillagerForConversation(this.player, msg);
            villager.ifPresent(villagerEntityMCA -> this.mca$runAsyncAnswerRequest(this.player, (VillagerEntityMCA)villagerEntityMCA, msg));
        }
    }

    @Unique
    private void mca$runAsyncAnswerRequest(ServerPlayer player, VillagerEntityMCA villager, String msg) {
        CompletableFuture.runAsync(() -> {
            Optional<String> answer = ChatAI.answer(player, villager, msg);
            answer.ifPresent(a -> villager.conversationManager.addMessage((Entity)player, Component.literal((String)a)));
        });
    }
}

