/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.mixin;

import net.conczin.mca.ducks.IVillagerEntity;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ZombieVillager.class})
abstract class MixinZombieVillager
implements IVillagerEntity {
    @Unique
    @Nullable
    private transient MobSpawnType mca$reason;

    MixinZombieVillager() {
    }

    @Override
    public MobSpawnType mca$getSpawnReason() {
        return this.mca$reason == null ? MobSpawnType.NATURAL : this.mca$reason;
    }

    @Inject(method={"finalizeSpawn"}, at={@At(value="HEAD")})
    private void mca$injectFinalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, SpawnGroupData spawnGroupData, CallbackInfoReturnable<SpawnGroupData> cir) {
        this.mca$reason = spawnType;
    }

    @ModifyVariable(method={"setVillagerData"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private VillagerData setVillagerData(VillagerData villagerData) {
        VillagerProfession profession = villagerData.getProfession();
        if (profession.toString().startsWith("mca.")) {
            villagerData = villagerData.setProfession(VillagerProfession.NONE);
        }
        return villagerData;
    }
}

