/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.conczin.mca.MCAClient;
import net.conczin.mca.client.model.CommonVillagerModel;
import net.conczin.mca.client.model.PlayerEntityExtendedModel;
import net.conczin.mca.client.model.VillagerEntityModelMCA;
import net.conczin.mca.client.render.layer.ClothingLayer;
import net.conczin.mca.client.render.layer.FaceLayer;
import net.conczin.mca.client.render.layer.HairLayer;
import net.conczin.mca.client.render.layer.SkinLayer;
import net.conczin.mca.client.render.layer.VillagerLayer;
import net.conczin.mca.entity.ai.relationship.AgeState;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class MixinPlayerRenderer
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    @Unique
    SkinLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> mca$skinLayer;
    @Unique
    ClothingLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> mca$clothingLayer;
    @Unique
    private PlayerModel<AbstractClientPlayer> mca$villagerModel;
    @Unique
    private PlayerModel<AbstractClientPlayer> mca$vanillaModel;

    public MixinPlayerRenderer(EntityRendererProvider.Context ctx, PlayerModel<AbstractClientPlayer> model, float shadowRadius) {
        super(ctx, model, shadowRadius);
    }

    @Unique
    private static PlayerEntityExtendedModel<AbstractClientPlayer> mca$createModel(MeshDefinition data) {
        return new PlayerEntityExtendedModel<AbstractClientPlayer>(LayerDefinition.create((MeshDefinition)data, (int)64, (int)64).bakeRoot());
    }

    @Shadow
    protected abstract void setModelProperties(AbstractClientPlayer var1);

    @Inject(method={"<init>(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;Z)V"}, at={@At(value="TAIL")})
    private void mca$injectInit(EntityRendererProvider.Context ctx, boolean slim, CallbackInfo ci) {
        if (MCAClient.isPlayerRendererAllowed()) {
            this.mca$villagerModel = MixinPlayerRenderer.mca$createModel(VillagerEntityModelMCA.bodyData(new CubeDeformation(0.0f), slim));
            this.mca$vanillaModel = (PlayerModel)this.model;
            this.mca$skinLayer = new SkinLayer(this, MixinPlayerRenderer.mca$createModel(VillagerEntityModelMCA.bodyData(new CubeDeformation(0.0f))));
            this.addLayer(this.mca$skinLayer);
            this.addLayer(new FaceLayer(this, MixinPlayerRenderer.mca$createModel(VillagerEntityModelMCA.bodyData(new CubeDeformation(0.01f))), "normal"));
            this.mca$clothingLayer = new ClothingLayer(this, MixinPlayerRenderer.mca$createModel(VillagerEntityModelMCA.bodyData(new CubeDeformation(0.0625f))), "normal");
            this.addLayer(this.mca$clothingLayer);
            this.addLayer(new HairLayer(this, MixinPlayerRenderer.mca$createModel(VillagerEntityModelMCA.hairData(new CubeDeformation(0.125f)))));
        }
    }

    @Inject(method={"scale(Lnet/minecraft/client/player/AbstractClientPlayer;Lcom/mojang/blaze3d/vertex/PoseStack;F)V"}, at={@At(value="TAIL")}, cancellable=true)
    private void mca$injectScale(AbstractClientPlayer player, PoseStack matrices, float f, CallbackInfo ci) {
        if (MCAClient.useGeneticsRenderer(player.getUUID())) {
            float height = CommonVillagerModel.getVillager((Entity)player).getRawVerticalScaleFactor();
            float width = CommonVillagerModel.getVillager((Entity)player).getRawHorizontalScaleFactor();
            matrices.scale(width, height, width);
            if (CommonVillagerModel.getVillager((Entity)player).getAgeState() == AgeState.BABY && !player.isPassenger()) {
                matrices.translate(0.0f, 0.6f, 0.0f);
            }
            ci.cancel();
            this.model = this.mca$villagerModel;
        } else if (MCAClient.isPlayerRendererAllowed()) {
            this.model = this.mca$vanillaModel;
        }
    }

    @Inject(method={"renderRightHand(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/player/AbstractClientPlayer;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void mca$injectRenderRightArm(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer player, CallbackInfo ci) {
        if (MCAClient.renderArms(player.getUUID(), "right_arm")) {
            this.mca$renderCustomArm(matrices, vertexConsumers, light, player, ((PlayerModel)this.mca$skinLayer.model).rightArm, ((PlayerModel)this.mca$skinLayer.model).rightSleeve, this.mca$skinLayer);
            this.mca$renderCustomArm(matrices, vertexConsumers, light, player, ((PlayerModel)this.mca$clothingLayer.model).rightArm, ((PlayerModel)this.mca$clothingLayer.model).rightSleeve, this.mca$clothingLayer);
            ci.cancel();
        }
    }

    @Inject(method={"renderLeftHand(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/player/AbstractClientPlayer;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void mca$injectRenderLeftArm(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer player, CallbackInfo ci) {
        if (MCAClient.renderArms(player.getUUID(), "left_arm")) {
            this.mca$renderCustomArm(matrices, vertexConsumers, light, player, ((PlayerModel)this.mca$skinLayer.model).leftArm, ((PlayerModel)this.mca$skinLayer.model).leftSleeve, this.mca$skinLayer);
            this.mca$renderCustomArm(matrices, vertexConsumers, light, player, ((PlayerModel)this.mca$clothingLayer.model).leftArm, ((PlayerModel)this.mca$clothingLayer.model).leftSleeve, this.mca$clothingLayer);
            ci.cancel();
        }
    }

    @Unique
    private void mca$renderCustomArm(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer player, ModelPart arm, ModelPart sleeve, VillagerLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> layer) {
        PlayerEntityExtendedModel model = (PlayerEntityExtendedModel)layer.model;
        this.setModelProperties(player);
        model.attackTime = 0.0f;
        model.crouching = false;
        model.swimAmount = 0.0f;
        model.setupAnim(player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        model.applyVillagerDimensions(CommonVillagerModel.getVillager((Entity)player), player.isCrouching());
        ResourceLocation skin = layer.getSkin(player);
        if (skin != null && layer.canUse(skin)) {
            VertexConsumer buffer = vertexConsumers.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)skin));
            int color = layer.getColor(player, 0.0f);
            arm.xRot = 0.0f;
            arm.render(matrices, buffer, light, OverlayTexture.NO_OVERLAY, color);
            sleeve.xRot = 0.0f;
            sleeve.render(matrices, buffer, light, OverlayTexture.NO_OVERLAY, color);
        }
    }
}

