/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import java.util.function.Consumer;
import net.conczin.mca.MCA;
import net.conczin.mca.block.BlockEntityTypesMCA;
import net.conczin.mca.entity.ai.ActivitiesMCA;
import net.conczin.mca.entity.ai.MemoryModuleTypeMCA;
import net.conczin.mca.entity.ai.SensorsMCA;
import net.conczin.mca.entity.interaction.gifts.GiftLoader;
import net.conczin.mca.neoforge.NeoforgePlatformHelper;
import net.conczin.mca.network.HandleablePayload;
import net.conczin.mca.network.MessagesMCA;
import net.conczin.mca.network.Network;
import net.conczin.mca.registry.BlocksMCA;
import net.conczin.mca.registry.CriterionMCA;
import net.conczin.mca.registry.DataComponentsMCA;
import net.conczin.mca.registry.EntitiesMCA;
import net.conczin.mca.registry.ItemsMCA;
import net.conczin.mca.registry.ParticleTypesMCA;
import net.conczin.mca.registry.ProfessionsMCA;
import net.conczin.mca.registry.SoundsMCA;
import net.conczin.mca.resources.ApiReloadListener;
import net.conczin.mca.resources.BuildingTypes;
import net.conczin.mca.resources.ClothingList;
import net.conczin.mca.resources.Dialogues;
import net.conczin.mca.resources.HairList;
import net.conczin.mca.resources.Names;
import net.conczin.mca.resources.Tasks;
import net.conczin.mca.server.ServerInteractionManager;
import net.conczin.mca.server.command.AdminCommand;
import net.conczin.mca.server.command.Command;
import net.conczin.mca.server.world.data.VillageManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod(value="mca")
@EventBusSubscriber(modid="mca")
public final class CommonNeoForge {
    private static <T> void registerHelper(RegisterEvent event, Registry<T> register, Consumer<MCA.RegisterHelper<T>> consumer) {
        event.register(register.key(), registry -> consumer.accept((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)registry).register(arg_0, arg_1)));
    }

    @SubscribeEvent
    public static void register(RegisterEvent event) {
        CommonNeoForge.registerHelper(event, BuiltInRegistries.ITEM, ItemsMCA::registerItems);
        CommonNeoForge.registerHelper(event, BuiltInRegistries.BLOCK, BlocksMCA::registerBlocks);
        CommonNeoForge.registerHelper(event, BuiltInRegistries.SOUND_EVENT, SoundsMCA::registerSounds);
        CommonNeoForge.registerHelper(event, BuiltInRegistries.PARTICLE_TYPE, ParticleTypesMCA::registerParticles);
        CommonNeoForge.registerHelper(event, BuiltInRegistries.ENTITY_TYPE, EntitiesMCA::registerEntities);
        CommonNeoForge.registerHelper(event, BuiltInRegistries.SENSOR_TYPE, SensorsMCA::registerSensors);
        CommonNeoForge.registerHelper(event, BuiltInRegistries.ACTIVITY, ActivitiesMCA::registerActivities);
        CommonNeoForge.registerHelper(event, BuiltInRegistries.MEMORY_MODULE_TYPE, MemoryModuleTypeMCA::registerTypes);
        CommonNeoForge.registerHelper(event, BuiltInRegistries.VILLAGER_PROFESSION, ProfessionsMCA::registerProfessions);
        CommonNeoForge.registerHelper(event, BuiltInRegistries.DATA_COMPONENT_TYPE, DataComponentsMCA::registerProfessions);
        CommonNeoForge.registerHelper(event, BuiltInRegistries.TRIGGER_TYPES, CriterionMCA::registerCriteria);
        if (event.getRegistryKey() == Registries.BLOCK_ENTITY_TYPE) {
            event.register(Registries.BLOCK_ENTITY_TYPE, helper -> BlockEntityTypesMCA.registerBlockEntityTypes((name, factory, block) -> {
                BlockEntityType build = BlockEntityType.Builder.of(factory::create, (Block[])block).build(null);
                helper.register(name, (Object)build);
                return build;
            }));
        }
        if (event.getRegistryKey() == Registries.CREATIVE_MODE_TAB) {
            CreativeModeTab tab = CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.mca.mca_tab")).icon(() -> new ItemStack((ItemLike)ItemsMCA.ENGAGEMENT_RING)).displayItems((params, output) -> {
                for (Item item : ItemsMCA.ITEMS.values()) {
                    output.accept(new ItemStack((ItemLike)item));
                }
            }).build();
            event.register(Registries.CREATIVE_MODE_TAB, helper -> helper.register(MCA.locate("mca_tab"), (Object)tab));
        }
    }

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ApiReloadListener());
        event.addListener((PreparableReloadListener)new ClothingList());
        event.addListener((PreparableReloadListener)new HairList());
        event.addListener((PreparableReloadListener)new GiftLoader());
        event.addListener((PreparableReloadListener)new Dialogues());
        event.addListener((PreparableReloadListener)new Tasks());
        event.addListener((PreparableReloadListener)new Names());
        event.addListener((PreparableReloadListener)new BuildingTypes());
    }

    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        AdminCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        Command.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            VillageManager.get(serverLevel).tick();
        }
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        ServerInteractionManager.getInstance().tick();
        MCA.setServer(event.getServer());
    }

    @SubscribeEvent
    public static void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ServerInteractionManager.getInstance().onPlayerJoin(player2);
        }
    }

    @SubscribeEvent
    public static void createDefaultAttributes(EntityAttributeCreationEvent event) {
        EntitiesMCA.registerAttributes((type, supplier) -> event.put(type, supplier.build()));
    }

    @SubscribeEvent
    public static void registerNetwork(RegisterPayloadHandlersEvent event) {
        MessagesMCA.register(new NeoForgeRegistrar(event.registrar("1")));
        Network.registerSender((x$0, x$1) -> PacketDistributor.sendToPlayer((ServerPlayer)x$0, (CustomPacketPayload)x$1, (CustomPacketPayload[])new CustomPacketPayload[0]));
        Network.registerClientSender(x$0 -> PacketDistributor.sendToServer((CustomPacketPayload)x$0, (CustomPacketPayload[])new CustomPacketPayload[0]));
    }

    static {
        MCA.platformHelper = new NeoforgePlatformHelper();
    }

    static class NeoForgeRegistrar
    implements Network.Registrar {
        PayloadRegistrar registrar;

        public NeoForgeRegistrar(PayloadRegistrar registrar) {
            this.registrar = registrar;
        }

        @Override
        public <T extends HandleablePayload> void register(CustomPacketPayload.Type<T> type, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, boolean isServer) {
            if (isServer) {
                this.registrar.playToServer(type, codec, (payload, ctx) -> ctx.enqueueWork(() -> payload.handle(ctx.player())));
            } else {
                this.registrar.playToClient(type, codec, (payload, ctx) -> ctx.enqueueWork(() -> payload.handle(ctx.player())));
            }
        }
    }
}

