/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.network.c2s;

import java.util.UUID;
import net.conczin.mca.MCA;
import net.conczin.mca.network.HandleablePayload;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.s2c.PlayerDataMessage;
import net.conczin.mca.server.world.data.PlayerSaveData;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record PlayerDataRequest(UUID uuid) implements HandleablePayload
{
    public static final CustomPacketPayload.Type<PlayerDataRequest> TYPE = new CustomPacketPayload.Type(MCA.locate("player_data_request"));
    public static final StreamCodec<FriendlyByteBuf, PlayerDataRequest> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, PlayerDataRequest::uuid, PlayerDataRequest::new);

    @Override
    public void handleServer(ServerPlayer player) {
        ServerPlayer serverTarget;
        PlayerSaveData data;
        Player target = player.level().getPlayerByUUID(this.uuid);
        if (target instanceof ServerPlayer && (data = PlayerSaveData.get(serverTarget = (ServerPlayer)target)).isEntityDataSet()) {
            CompoundTag nbt = data.getEntityData();
            Network.sendToPlayer(new PlayerDataMessage(this.uuid, nbt), player);
        }
    }

    public CustomPacketPayload.Type<PlayerDataRequest> type() {
        return TYPE;
    }
}

