/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.network.c2s;

import java.util.Arrays;
import java.util.UUID;
import net.conczin.mca.MCA;
import net.conczin.mca.network.HandleablePayload;
import net.conczin.mca.registry.DataComponentsMCA;
import net.conczin.mca.registry.ItemsMCA;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public record SetTargetMessage(String targetName, UUID targetUUID) implements HandleablePayload
{
    public static final CustomPacketPayload.Type<SetTargetMessage> TYPE = new CustomPacketPayload.Type(MCA.locate("set_target"));
    public static final StreamCodec<FriendlyByteBuf, SetTargetMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, SetTargetMessage::targetName, (StreamCodec)UUIDUtil.STREAM_CODEC, SetTargetMessage::targetUUID, SetTargetMessage::new);

    @Override
    public void handleServer(ServerPlayer player) {
        Arrays.stream(InteractionHand.values()).forEach(hand -> {
            ItemStack stack = player.getItemInHand(hand);
            if (stack.is(ItemsMCA.VILLAGER_TRACKER)) {
                stack.set(DataComponentsMCA.TRACKER_NAME, (Object)this.targetName);
                stack.set(DataComponentsMCA.TRACKER_UUID, (Object)this.targetUUID);
            }
        });
    }

    public CustomPacketPayload.Type<SetTargetMessage> type() {
        return TYPE;
    }
}

