/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.network.s2c;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.conczin.mca.ClientProxy;
import net.conczin.mca.MCA;
import net.conczin.mca.network.HandleablePayload;
import net.conczin.mca.resources.BuildingTypes;
import net.conczin.mca.resources.Rank;
import net.conczin.mca.resources.Tasks;
import net.conczin.mca.resources.data.BuildingType;
import net.conczin.mca.resources.data.tasks.Task;
import net.conczin.mca.resources.data.tasks.TaskRegistry;
import net.conczin.mca.server.world.data.Village;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;

public record GetVillageResponse(CompoundTag data, Rank rank, int reputation, boolean isVillage, Set<String> ids, Map<Rank, List<Task>> tasks, Map<String, BuildingType> buildingTypes) implements HandleablePayload
{
    public static final CustomPacketPayload.Type<GetVillageResponse> TYPE = new CustomPacketPayload.Type(MCA.locate("get_village_response"));
    private static final StreamCodec<FriendlyByteBuf, Set<String>> IDS_CODEC = ByteBufCodecs.collection(HashSet::new, (StreamCodec)ByteBufCodecs.STRING_UTF8);
    private static final StreamCodec<FriendlyByteBuf, Map<Rank, List<Task>>> TASKS_CODEC = ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.idMapper(i -> Rank.values()[i], Enum::ordinal), (StreamCodec)TaskRegistry.CODEC.apply(ByteBufCodecs.list()));
    private static final StreamCodec<FriendlyByteBuf, Map<String, BuildingType>> BUILDING_TYPES_CODEC = ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, BuildingType.STREAM_CODEC);
    public static final StreamCodec<FriendlyByteBuf, GetVillageResponse> STREAM_CODEC = StreamCodec.of((buf, value) -> {
        ByteBufCodecs.COMPOUND_TAG.encode(buf, (Object)value.data());
        ByteBufCodecs.idMapper(i -> Rank.values()[i], Enum::ordinal).encode(buf, (Object)value.rank());
        ByteBufCodecs.VAR_INT.encode(buf, (Object)value.reputation());
        ByteBufCodecs.BOOL.encode(buf, (Object)value.isVillage());
        IDS_CODEC.encode(buf, value.ids());
        TASKS_CODEC.encode(buf, value.tasks());
        BUILDING_TYPES_CODEC.encode(buf, value.buildingTypes());
    }, buf -> new GetVillageResponse((CompoundTag)ByteBufCodecs.COMPOUND_TAG.decode(buf), (Rank)((Object)((Object)ByteBufCodecs.idMapper(i -> Rank.values()[i], Enum::ordinal).decode(buf))), (Integer)ByteBufCodecs.VAR_INT.decode(buf), (Boolean)ByteBufCodecs.BOOL.decode(buf), (Set)IDS_CODEC.decode(buf), (Map)TASKS_CODEC.decode(buf), (Map)BUILDING_TYPES_CODEC.decode(buf)));

    public GetVillageResponse(Village data, Rank rank, int reputation, boolean isVillage, Set<String> ids) {
        this(data.save(), rank, reputation, isVillage, ids, Tasks.getInstance().tasks, BuildingTypes.getInstance().getServerBuildingTypes());
    }

    public CompoundTag getData() {
        return this.data;
    }

    @Override
    public void handle(Player player) {
        ClientProxy.getNetworkHandler().handleVillageDataResponse(this);
    }

    public CustomPacketPayload.Type<GetVillageResponse> type() {
        return TYPE;
    }
}

