/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.registry;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.conczin.mca.MCA;
import net.conczin.mca.item.components.BabyParentsComponent;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.component.CustomData;

public interface DataComponentsMCA {
    public static final Map<ResourceLocation, DataComponentType<?>> COMPONENTS = new HashMap();
    public static final DataComponentType<GlobalPos> TRACKER_POS = DataComponentsMCA.register("tracker_pos", b -> b.persistent(GlobalPos.CODEC).networkSynchronized(GlobalPos.STREAM_CODEC));
    public static final DataComponentType<String> TRACKER_NAME = DataComponentsMCA.register("tracker_name", b -> b.persistent((Codec)Codec.STRING).networkSynchronized(ByteBufCodecs.STRING_UTF8));
    public static final DataComponentType<UUID> TRACKER_UUID = DataComponentsMCA.register("tracker_uuid", b -> b.persistent(UUIDUtil.CODEC).networkSynchronized(UUIDUtil.STREAM_CODEC));
    public static final DataComponentType<BabyParentsComponent> BABY_PARENTS = DataComponentsMCA.register("baby_parents", b -> b.persistent(BabyParentsComponent.CODEC).networkSynchronized(BabyParentsComponent.STREAM_CODEC));
    public static final DataComponentType<Integer> BABY_AGE = DataComponentsMCA.register("baby_age", b -> b.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT));
    public static final DataComponentType<Integer> BABY_DROP_ATTEMPTS = DataComponentsMCA.register("baby_drop_attempts", b -> b.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT));
    public static final DataComponentType<Boolean> BABY_INVALIDATED = DataComponentsMCA.register("baby_invalidated", b -> b.persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
    public static final DataComponentType<CustomData> BABY_NBT = DataComponentsMCA.register("baby_nbt", b -> b.persistent(CustomData.CODEC_WITH_ID).networkSynchronized(CustomData.STREAM_CODEC));
    public static final DataComponentType<Boolean> SCYTHE_ACTIVE = DataComponentsMCA.register("scythe_active", b -> b.persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
    public static final DataComponentType<Boolean> SCYTHE_HAS_SOUL = DataComponentsMCA.register("scythe_has_soul", b -> b.persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
    public static final DataComponentType<List<Component>> BOOK_PAGES = DataComponentsMCA.register("book_pages", b -> b.persistent(ComponentSerialization.FLAT_CODEC.listOf()).networkSynchronized(ComponentSerialization.STREAM_CODEC.apply(ByteBufCodecs.list())));

    private static <T> DataComponentType<T> register(String name, UnaryOperator<DataComponentType.Builder<T>> builder) {
        DataComponentType component = ((DataComponentType.Builder)builder.apply(DataComponentType.builder())).build();
        COMPONENTS.put(MCA.locate(name), component);
        return component;
    }

    public static void registerProfessions(MCA.RegisterHelper<DataComponentType<?>> helper) {
        COMPONENTS.forEach(helper::register);
    }
}

