/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.resources;

import com.google.gson.JsonElement;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.conczin.mca.MCA;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.s2c.AnalysisResults;
import net.conczin.mca.resources.Resources;
import net.conczin.mca.resources.data.Analysis;
import net.conczin.mca.resources.data.SerializablePair;
import net.conczin.mca.resources.data.dialogue.Actions;
import net.conczin.mca.resources.data.dialogue.Answer;
import net.conczin.mca.resources.data.dialogue.Question;
import net.conczin.mca.resources.data.dialogue.Result;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class Dialogues
extends SimpleJsonResourceReloadListener {
    protected static final ResourceLocation ID = MCA.locate("dialogues");
    private static Dialogues INSTANCE;
    private final Map<String, Question> questions = new HashMap<String, Question>();

    public Dialogues() {
        super(Resources.GSON, "dialogues");
        INSTANCE = this;
    }

    public static Dialogues getInstance() {
        return INSTANCE;
    }

    @NotNull
    private static Analysis getFinalAnalysis(List<Analysis> analysis, Answer answer) {
        Analysis finalAnalysis = new Analysis();
        for (int i = 0; i < analysis.size(); ++i) {
            boolean positive = answer.getResults().get(i).getActions().isPositive();
            boolean negative = answer.getResults().get(i).getActions().isNegative();
            for (SerializablePair<String, Integer> value : analysis.get(i).getSummands()) {
                finalAnalysis.add(value.left(), value.right() * (positive ? 1 : (negative ? -1 : 0)));
            }
        }
        return finalAnalysis;
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager manager, ProfilerFiller profiler) {
        this.questions.clear();
        data.forEach(this::loadDialogue);
    }

    private void loadDialogue(ResourceLocation identifier, JsonElement element) {
        String id = identifier.getPath().substring(identifier.getPath().lastIndexOf(47) + 1);
        if (!this.checkIsMcaDialogue(element)) {
            MCA.LOGGER.warn("Dialogue {} is not properly formatted, not loading", (Object)identifier);
            return;
        }
        Question q = Question.fromJson(id, element.getAsJsonObject());
        if (this.questions.containsKey(id)) {
            q.merge(this.questions.get(id));
        }
        q.getAnswers().sort(Comparator.comparingInt(Answer::getPriority));
        this.questions.put(id, q);
    }

    private boolean checkIsMcaDialogue(JsonElement element) {
        JsonElement answersElement = element.getAsJsonObject().get("answers");
        return answersElement != null && answersElement.isJsonArray();
    }

    public Question getQuestion(String i) {
        return this.questions.get(i);
    }

    public void selectAnswer(VillagerEntityMCA villager, ServerPlayer player, String questionId, String answerId) {
        Actions actions;
        Question question = this.getQuestion(questionId);
        Answer answer = question.getAnswer(answerId);
        int total = 0;
        LinkedList<Analysis> analysis = new LinkedList<Analysis>();
        for (Result result : answer.getResults()) {
            Analysis a = result.getChances(villager, player);
            analysis.add(a);
            total += Math.max(0, a.getTotal());
        }
        int chosen = -1;
        total = total == 0 ? 0 : villager.getRandom().nextInt(total);
        for (Analysis a : analysis) {
            ++chosen;
            if ((total -= Math.max(0, a.getTotal())) >= 0) continue;
            break;
        }
        if ((actions = answer.getResults().get(chosen).getActions()).isNegative() || actions.isPositive()) {
            Analysis finalAnalysis = Dialogues.getFinalAnalysis(analysis, answer);
            Network.sendToPlayer(new AnalysisResults(finalAnalysis), player);
        }
        actions.trigger(villager, player);
    }
}

