/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.server;

import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.conczin.mca.Config;
import net.conczin.mca.entity.ai.relationship.EntityRelationship;
import net.conczin.mca.entity.ai.relationship.RelationshipState;
import net.conczin.mca.item.BabyItem;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.s2c.OpenDestinyGuiRequest;
import net.conczin.mca.network.s2c.ShowToastRequest;
import net.conczin.mca.server.world.data.PlayerSaveData;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class ServerInteractionManager {
    private static final ServerInteractionManager INSTANCE = new ServerInteractionManager();
    private final Map<UUID, List<UUID>> proposals = new HashMap<UUID, List<UUID>>();
    private final Object2LongArrayMap<UUID> procreateMap = new Object2LongArrayMap();

    private ServerInteractionManager() {
    }

    public static ServerInteractionManager getInstance() {
        return INSTANCE;
    }

    public static void launchDestiny(ServerPlayer player) {
        Network.sendToPlayer(new OpenDestinyGuiRequest(player), player);
    }

    public void tick() {
        ArrayList removals = new ArrayList();
        this.procreateMap.keySet().stream().filter(k -> this.procreateMap.getLong(k) < System.currentTimeMillis()).forEach(removals::add);
        removals.forEach(arg_0 -> this.procreateMap.removeLong(arg_0));
    }

    public void onPlayerJoin(ServerPlayer player) {
        PlayerSaveData playerData = PlayerSaveData.get(player);
        if (!playerData.isEntityDataSet()) {
            if (Config.getInstance().launchIntoDestiny) {
                ServerInteractionManager.launchDestiny(player);
                player.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 3600));
                player.addEffect(new MobEffectInstance(MobEffects.HEALTH_BOOST, 3600));
            } else if (Config.getInstance().allowDestinyCommandOnce) {
                Network.sendToPlayer(new ShowToastRequest("server.destinyNotSet.title", "server.destinyNotSet.description"), player);
            } else if (Config.getInstance().allowFullPlayerEditor) {
                Network.sendToPlayer(new ShowToastRequest("server.playerNotCustomized.title", "server.playerNotCustomized.description"), player);
            }
        }
        if (playerData.hasMail()) {
            PlayerSaveData.showMailNotification(player);
        }
    }

    private boolean hasProposalFrom(ServerPlayer sender, ServerPlayer receiver) {
        return this.getProposalsFor(receiver).contains(sender.getUUID());
    }

    private List<UUID> getProposalsFor(ServerPlayer player) {
        return this.proposals.getOrDefault(player.getUUID(), new ArrayList());
    }

    private void removeProposalFor(ServerPlayer target, ServerPlayer proposer) {
        List<UUID> list = this.getProposalsFor(target);
        list.remove(proposer.getUUID());
        this.proposals.put(target.getUUID(), list);
    }

    public void listProposals(ServerPlayer sender) {
        List<UUID> proposals = this.getProposalsFor(sender);
        if (proposals.isEmpty()) {
            this.infoMessage((Player)sender, Component.translatable((String)"server.noProposals"));
        } else {
            this.infoMessage((Player)sender, Component.translatable((String)"server.proposals"));
        }
        proposals.forEach(uuid -> {
            Player player = sender.level().getPlayerByUUID(uuid);
            if (player != null) {
                this.infoMessage((Player)sender, Component.literal((String)"- ").append((Component)Component.literal((String)player.getScoreboardName())));
            }
        });
    }

    public void sendProposal(ServerPlayer sender, ServerPlayer receiver) {
        if (!Config.getInstance().allowPlayerMarriage) {
            this.failMessage((Player)sender, Component.translatable((String)"notify.playerMarriage.disabled"));
            return;
        }
        if (PlayerSaveData.get(sender).isMarried()) {
            this.failMessage((Player)sender, Component.translatable((String)"server.alreadyMarried"));
            return;
        }
        if (sender == receiver) {
            this.failMessage((Player)sender, Component.translatable((String)"server.proposedToYourself"));
            return;
        }
        if (this.hasProposalFrom(sender, receiver)) {
            this.failMessage((Player)sender, Component.translatable((String)"server.sentProposal", (Object[])new Object[]{receiver.getScoreboardName()}));
        } else {
            this.successMessage((Player)sender, Component.translatable((String)"server.proposalSent", (Object[])new Object[]{receiver.getScoreboardName()}));
            this.infoMessage((Player)receiver, Component.translatable((String)"server.proposedMarriage", (Object[])new Object[]{sender.getScoreboardName()}));
            List<UUID> list = this.getProposalsFor(receiver);
            list.add(sender.getUUID());
            this.proposals.put(receiver.getUUID(), list);
        }
    }

    public void rejectProposal(ServerPlayer sender, ServerPlayer receiver) {
        if (!this.hasProposalFrom(receiver, sender)) {
            this.failMessage((Player)sender, Component.translatable((String)"server.noProposal", (Object[])new Object[]{receiver.getDisplayName()}));
        } else {
            this.successMessage((Player)sender, Component.translatable((String)"server.proposalRejectionSent"));
            this.failMessage((Player)receiver, Component.translatable((String)"server.proposalRejected", (Object[])new Object[]{sender.getScoreboardName()}));
            this.removeProposalFor(sender, receiver);
        }
    }

    public void acceptProposal(ServerPlayer sender, ServerPlayer receiver) {
        if (!this.hasProposalFrom(receiver, sender)) {
            this.failMessage((Player)sender, Component.translatable((String)"server.noProposal", (Object[])new Object[]{receiver.getDisplayName()}));
        } else {
            this.successMessage((Player)receiver, Component.translatable((String)"server.proposalAccepted", (Object[])new Object[]{sender.getDisplayName()}));
            PlayerSaveData.get(sender).marry((Entity)receiver);
            PlayerSaveData.get(receiver).marry((Entity)sender);
            this.successMessage((Player)sender, Component.translatable((String)"server.married", (Object[])new Object[]{receiver.getDisplayName()}));
            this.successMessage((Player)receiver, Component.translatable((String)"server.married", (Object[])new Object[]{sender.getDisplayName()}));
            this.removeProposalFor(sender, receiver);
        }
    }

    public void endMarriage(ServerPlayer sender) {
        EntityRelationship.of((Entity)sender).ifPresent(senderData -> {
            if (!senderData.isMarried()) {
                this.failMessage((Player)sender, Component.translatable((String)"server.endMarriageNotMarried"));
                return;
            }
            if (senderData.getRelationshipState() != RelationshipState.MARRIED_TO_PLAYER) {
                this.failMessage((Player)sender, Component.translatable((String)"server.marriedToVillager"));
                return;
            }
            senderData.getPartnerName().ifPresent(name -> this.successMessage((Player)sender, Component.translatable((String)"server.endMarriage", (Object[])new Object[]{name.getString()})));
            senderData.getPartner().ifPresent(spouse -> {
                if (spouse instanceof Player) {
                    Player player = (Player)spouse;
                    this.failMessage(player, Component.translatable((String)"server.marriageEnded", (Object[])new Object[]{sender.getScoreboardName()}));
                }
            });
            senderData.endRelationShip(RelationshipState.SINGLE);
            senderData.getPartnerUUID().map(id -> PlayerSaveData.get(sender)).ifPresent(r -> r.endRelationShip(RelationshipState.SINGLE));
        });
    }

    public void procreate(ServerPlayer sender) {
        PlayerSaveData senderData = PlayerSaveData.get(sender);
        if (!senderData.isMarried()) {
            this.failMessage((Player)sender, Component.translatable((String)"server.notMarried"));
            return;
        }
        if (senderData.getRelationshipState() != RelationshipState.MARRIED_TO_PLAYER) {
            this.failMessage((Player)sender, Component.translatable((String)"server.marriedToVillager"));
            return;
        }
        senderData.getPartner().filter(e -> e instanceof Player).map(Player.class::cast).ifPresentOrElse(spouse -> {
            if (!this.procreateMap.containsKey((Object)spouse.getUUID())) {
                this.procreateMap.put((Object)sender.getUUID(), System.currentTimeMillis() + 10000L);
                this.infoMessage((Player)spouse, Component.translatable((String)"server.procreationRequest", (Object[])new Object[]{sender.getScoreboardName()}));
            } else {
                this.successMessage((Player)sender, Component.translatable((String)"server.procreationSuccessful"));
                this.successMessage((Player)spouse, Component.translatable((String)"server.procreationSuccessful"));
                spouse.addItem(BabyItem.createItem((Entity)spouse, (Entity)sender, spouse.getRandom().nextLong()));
            }
        }, () -> this.failMessage((Player)sender, Component.translatable((String)"server.spouseNotPresent")));
    }

    private void successMessage(Player player, MutableComponent message) {
        player.sendSystemMessage((Component)message.withStyle(ChatFormatting.GREEN));
    }

    private void failMessage(Player player, MutableComponent message) {
        player.sendSystemMessage((Component)message.withStyle(ChatFormatting.RED));
    }

    private void infoMessage(Player player, MutableComponent message) {
        player.sendSystemMessage((Component)message.withStyle(ChatFormatting.YELLOW));
    }
}

