/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.server;

import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.conczin.mca.Config;
import net.conczin.mca.ducks.IVillagerEntity;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.VillagerFactory;
import net.conczin.mca.entity.ZombieVillagerEntityMCA;
import net.conczin.mca.entity.ZombieVillagerFactory;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.conczin.mca.server.world.data.Nationality;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;

public class SpawnQueue {
    private static final SpawnQueue INSTANCE = new SpawnQueue();
    private final ConcurrentLinkedQueue<Villager> villagerSpawnQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<ZombieVillager> zombieVillagerSpawnQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Zombie> zombieSpawnList = new ConcurrentLinkedQueue();

    public static SpawnQueue getInstance() {
        return INSTANCE;
    }

    public static boolean shouldGetConverted(Entity entity) {
        if (Config.getInstance().fractionOfVanillaVillages <= 0.0f) {
            return true;
        }
        int i = Nationality.get((ServerLevel)entity.level()).getRegionId(entity.blockPosition());
        return (double)Math.floorMod(i, 100) >= (double)Config.getInstance().fractionOfVanillaVillages * 100.0;
    }

    public void tick() {
        Zombie ze;
        ZombieVillager zve;
        Villager ve = this.villagerSpawnQueue.poll();
        if (ve != null) {
            ve.discard();
            VillagerEntityMCA villager = VillagerFactory.newVillager(ve.level()).withName(ve.hasCustomName() ? ve.getName().getString() : null).withGender(Gender.getRandom()).withAge(ve.getAge()).withPosition((Entity)ve).withType(ve.getVillagerData().getType()).withProfession(ve.getVillagerData().getProfession(), ve.getVillagerData().getLevel(), ve.getOffers()).spawn(((IVillagerEntity)ve).mca$getSpawnReason());
            this.copyPastaIntensifies((PathfinderMob)villager, (PathfinderMob)ve);
        }
        if ((zve = this.zombieVillagerSpawnQueue.poll()) != null) {
            zve.discard();
            ZombieVillagerEntityMCA villager = ZombieVillagerFactory.newVillager(zve.level()).withName(zve.hasCustomName() ? zve.getName().getString() : null).withGender(Gender.getRandom()).withPosition((Entity)zve).withType(zve.getVillagerData().getType()).withProfession(zve.getVillagerData().getProfession(), zve.getVillagerData().getLevel()).spawn(((IVillagerEntity)zve).mca$getSpawnReason());
            this.copyPastaIntensifies((PathfinderMob)villager, (PathfinderMob)zve);
        }
        if ((ze = this.zombieSpawnList.poll()) != null) {
            ze.discard();
            ZombieVillagerEntityMCA villager = ZombieVillagerFactory.newVillager(ze.level()).withName(ze.hasCustomName() ? ze.getName().getString() : null).withGender(Gender.getRandom()).withPosition((Entity)ze).withType(VillagerType.byBiome((Holder)ze.level().getBiome(ze.blockPosition()))).withProfession(BuiltInRegistries.VILLAGER_PROFESSION.getRandom(ze.getRandom()).map(Holder::value).orElse(VillagerProfession.NONE)).spawn(MobSpawnType.NATURAL);
            this.copyPastaIntensifies((PathfinderMob)villager, (PathfinderMob)ze);
        }
    }

    private void copyPastaIntensifies(PathfinderMob villager, PathfinderMob entity) {
        if (entity.isPersistenceRequired()) {
            villager.setPersistenceRequired();
        }
        if (entity.isInvulnerable()) {
            villager.setInvulnerable(true);
        }
        if (entity.isNoAi()) {
            villager.setNoAi(true);
        }
        for (String tag : entity.getTags()) {
            villager.addTag(tag);
        }
    }

    public boolean addVillager(Entity entity) {
        IVillagerEntity villagerEntity;
        if (entity instanceof IVillagerEntity && !this.handlesSpawnReason((villagerEntity = (IVillagerEntity)entity).mca$getSpawnReason())) {
            return false;
        }
        if (Config.getInstance().villagerDimensionBlacklist.contains(entity.getCommandSenderWorld().dimension().location().toString())) {
            return false;
        }
        if (Config.getInstance().overwriteOriginalVillagers && (entity.getClass().equals(Villager.class) || Config.getInstance().moddedVillagerWhitelist.contains(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString()) && entity instanceof Villager) && SpawnQueue.shouldGetConverted(entity) && !this.villagerSpawnQueue.contains(entity)) {
            return this.villagerSpawnQueue.add((Villager)entity);
        }
        if (Config.getInstance().overwriteOriginalZombieVillagers && (entity.getClass().equals(ZombieVillager.class) || Config.getInstance().moddedZombieVillagerWhitelist.contains(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString()) && entity instanceof ZombieVillager) && Config.getInstance().fractionOfVanillaZombies < entity.getRandom().nextFloat() && !this.zombieVillagerSpawnQueue.contains(entity)) {
            return this.zombieVillagerSpawnQueue.add((ZombieVillager)entity);
        }
        if (Config.getInstance().overwriteAllZombiesWithZombieVillagers && entity.getClass().equals(Zombie.class) && !this.zombieSpawnList.contains(entity)) {
            return this.zombieSpawnList.add((Zombie)entity);
        }
        return false;
    }

    private boolean handlesSpawnReason(MobSpawnType reason) {
        return Config.getInstance().allowedSpawnReasons.contains(reason.name().toLowerCase(Locale.ROOT));
    }

    public void convert(Villager villager) {
        this.villagerSpawnQueue.add(villager);
    }
}

