/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.server.world.data;

import java.util.LinkedList;
import java.util.List;
import net.conczin.mca.server.world.data.Village;
import net.conczin.mca.util.NbtHelper;
import net.conczin.mca.util.WorldUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class CivilRegistryManager
extends SavedData {
    private final LinkedList<Component> entries = new LinkedList();

    CivilRegistryManager(ServerLevel world) {
    }

    CivilRegistryManager(CompoundTag nbt, HolderLookup.Provider provider) {
        this.entries.addAll(NbtHelper.toList(nbt.get("entries"), element -> Component.Serializer.fromJson((String)element.getAsString(), (HolderLookup.Provider)provider)));
    }

    public static CivilRegistryManager get(ServerLevel world, Village village) {
        return WorldUtils.loadData(world.getServer().overworld(), CivilRegistryManager::new, CivilRegistryManager::new, "mca_civil_registry_" + village.getId());
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider provider) {
        ListTag elements = NbtHelper.fromList(this.entries, a -> StringTag.valueOf((String)Component.Serializer.toJson((Component)a, (HolderLookup.Provider)provider)));
        nbt.put("entries", (Tag)elements);
        return nbt;
    }

    public void addText(Component text) {
        this.entries.addFirst(text);
        this.setDirty();
    }

    public List<Component> getPage(int from, int to) {
        to = Math.min(this.entries.size(), to);
        return to <= from ? List.of() : this.entries.subList(from, to);
    }
}

