/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.server.world.data;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.conczin.mca.MCA;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.s2c.CustomSkinsChangedMessage;
import net.conczin.mca.resources.data.skin.Clothing;
import net.conczin.mca.resources.data.skin.Hair;
import net.conczin.mca.resources.data.skin.SkinListEntry;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;

public class CustomClothingManager {
    static final Storage<Clothing> CLOTHING_DUMMY = new Storage();
    static final Storage<Hair> HAIR_DUMMY = new Storage();

    public static Storage<Clothing> getClothing() {
        Optional<MinecraftServer> server = MCA.getServer();
        return server.map(minecraftServer -> (Storage)minecraftServer.overworld().getDataStorage().computeIfAbsent(new SavedData.Factory(Storage::new, (nbt, provider) -> new Storage<Clothing>((CompoundTag)nbt, Clothing::new), null), "immersive_library_clothing")).orElse(CLOTHING_DUMMY);
    }

    public static Storage<Hair> getHair() {
        Optional<MinecraftServer> server = MCA.getServer();
        return server.map(minecraftServer -> (Storage)minecraftServer.overworld().getDataStorage().computeIfAbsent(new SavedData.Factory(Storage::new, (nbt, provider) -> new Storage<Hair>((CompoundTag)nbt, Hair::new), null), "immersive_library_hair")).orElse(HAIR_DUMMY);
    }

    public static class Storage<T extends SkinListEntry>
    extends SavedData {
        final Map<String, T> entries = new HashMap<String, T>();

        public Storage() {
        }

        public Storage(CompoundTag nbt, BiFunction<String, JsonObject, T> entryFromNbt) {
            Gson gson = new Gson();
            for (String identifier : nbt.getAllKeys()) {
                this.entries.put(identifier, (SkinListEntry)entryFromNbt.apply(identifier, (JsonObject)gson.fromJson(nbt.getString(identifier), JsonObject.class)));
            }
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider provider) {
            CompoundTag c = new CompoundTag();
            for (Map.Entry<String, T> entry : this.entries.entrySet()) {
                c.putString(entry.getKey(), ((SkinListEntry)entry.getValue()).toJson().toString());
            }
            return c;
        }

        public Map<String, T> getEntries() {
            return this.entries;
        }

        public void addEntry(String id, T entry) {
            this.entries.put(id, entry);
            this.setDirty();
        }

        public void removeEntry(String id) {
            this.entries.remove(id);
            this.setDirty();
        }

        public void setDirty() {
            super.setDirty();
            MCA.getServer().ifPresent(s -> {
                for (ServerPlayer player : s.getPlayerList().getPlayers()) {
                    Network.sendToPlayer(new CustomSkinsChangedMessage(), player);
                }
            });
        }
    }
}

