/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.server.world.data;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import net.conczin.mca.MCA;
import net.conczin.mca.entity.ai.relationship.EntityRelationship;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.conczin.mca.entity.ai.relationship.RelationshipState;
import net.conczin.mca.server.world.data.FamilyTree;
import net.conczin.mca.util.NbtHelper;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerProfession;
import org.jetbrains.annotations.Nullable;

public final class FamilyTreeNode {
    public static final StreamCodec<ByteBuf, FamilyTreeNode> STREAM_CODEC = StreamCodec.of((out, value) -> ByteBufCodecs.COMPOUND_TAG.encode(out, (Object)value.save()), in -> new FamilyTreeNode(null, (CompoundTag)ByteBufCodecs.COMPOUND_TAG.decode(in)));
    private final boolean isPlayer;
    private final UUID id;
    private final Set<UUID> children = new HashSet<UUID>();
    private final transient FamilyTree rootNode;
    private Gender gender;
    private String name;
    private String profession = BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)VillagerProfession.NONE).toString();
    private UUID father;
    private UUID mother;
    private UUID partner = Util.NIL_UUID;
    private RelationshipState relationshipState = RelationshipState.SINGLE;
    private boolean deceased;

    public FamilyTreeNode(FamilyTree rootNode, UUID id, String name, boolean isPlayer, Gender gender, UUID father, UUID mother) {
        this.rootNode = rootNode;
        this.id = id;
        this.name = name;
        this.isPlayer = isPlayer;
        this.gender = gender;
        this.father = father;
        this.mother = mother;
    }

    public FamilyTreeNode(FamilyTree rootNode, CompoundTag nbt) {
        this(rootNode, nbt.getUUID("id"), nbt.getString("name"), nbt.getBoolean("isPlayer"), Gender.byId(nbt.getInt("gender")), nbt.getUUID("father"), nbt.getUUID("mother"));
        this.children.addAll(NbtHelper.toList((Tag)nbt.getList("children", 10), c -> ((CompoundTag)c).getUUID("uuid")));
        this.profession = nbt.getString("profession");
        this.deceased = nbt.getBoolean("isDeceased");
        if (nbt.hasUUID("spouse")) {
            this.partner = nbt.getUUID("spouse");
        }
        this.relationshipState = RelationshipState.byId(nbt.getInt("marriageState"));
    }

    public static boolean isValid(@Nullable UUID uuid) {
        return uuid != null && !Util.NIL_UUID.equals(uuid);
    }

    private static void gatherParents(FamilyTreeNode current, Set<UUID> family, int depth) {
        FamilyTreeNode.gather(current, family, depth, FamilyTreeNode::streamParents);
    }

    private static void gatherChildren(FamilyTreeNode current, Set<UUID> family, int depth) {
        FamilyTreeNode.gather(current, family, depth, FamilyTreeNode::streamChildren);
    }

    private static void gather(@Nullable FamilyTreeNode entry, Set<UUID> output, int depth, Function<FamilyTreeNode, Stream<UUID>> walker) {
        if (entry == null || depth <= 0) {
            return;
        }
        walker.apply(entry).forEach(id -> {
            if (!Util.NIL_UUID.equals(id)) {
                output.add((UUID)id);
            }
            if (depth > 1) {
                entry.getRoot().getOrEmpty((UUID)id).ifPresent(e -> FamilyTreeNode.gather(e, output, depth - 1, walker));
            }
        });
    }

    public UUID id() {
        return this.id;
    }

    private void markDirty() {
        if (this.rootNode != null) {
            this.rootNode.setDirty();
        }
    }

    public boolean isDeceased() {
        return this.deceased;
    }

    public void setDeceased(boolean deceased) {
        this.deceased = deceased;
        this.markDirty();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.markDirty();
    }

    public VillagerProfession getProfession() {
        return (VillagerProfession)BuiltInRegistries.VILLAGER_PROFESSION.get(this.getProfessionId());
    }

    public void setProfession(VillagerProfession profession) {
        this.profession = BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)profession).toString();
        this.markDirty();
    }

    public ResourceLocation getProfessionId() {
        return ResourceLocation.tryParse((String)this.profession);
    }

    public String getProfessionName() {
        String professionName = (this.getProfessionId().getNamespace().equalsIgnoreCase("minecraft") ? (this.getProfessionId().getPath().equals("none") ? "mca.none" : this.getProfessionId().getPath()) : this.getProfessionId().toString()).replace(":", ".");
        return MCA.isBlankString(professionName) ? "mca.none" : professionName;
    }

    public MutableComponent getProfessionText() {
        return Component.translatable((String)("entity.minecraft.villager." + this.getProfessionName()));
    }

    public boolean isPlayer() {
        return this.isPlayer;
    }

    public Gender gender() {
        return this.gender;
    }

    public UUID father() {
        return this.father;
    }

    public UUID mother() {
        return this.mother;
    }

    public UUID partner() {
        return this.partner;
    }

    public RelationshipState getRelationshipState() {
        return this.relationshipState;
    }

    public void setRelationshipState(RelationshipState relationshipState) {
        this.relationshipState = relationshipState;
    }

    public void updatePartner(@Nullable Entity newPartner, @Nullable RelationshipState state) {
        if (!(this.partner.equals(Util.NIL_UUID) || newPartner != null && this.partner.equals(newPartner.getUUID()))) {
            this.getRoot().getOrEmpty(this.partner).ifPresent(n -> {
                n.partner = Util.NIL_UUID;
                n.relationshipState = RelationshipState.SINGLE;
            });
        }
        this.partner = newPartner == null ? Util.NIL_UUID : newPartner.getUUID();
        RelationshipState relationshipState = this.relationshipState = state == null && newPartner == null ? RelationshipState.SINGLE : state;
        if (newPartner != null) {
            this.rootNode.getOrCreate(newPartner);
        }
        this.rootNode.setDirty();
    }

    public void updatePartner(FamilyTreeNode spouse) {
        this.partner = spouse.id();
        this.relationshipState = spouse.isPlayer ? RelationshipState.MARRIED_TO_PLAYER : RelationshipState.MARRIED_TO_VILLAGER;
        this.markDirty();
    }

    public Set<UUID> children() {
        return this.children;
    }

    public Stream<UUID> streamChildren() {
        return this.children.stream().filter(FamilyTreeNode::isValid);
    }

    public Stream<UUID> streamParents() {
        return Stream.of(this.father(), this.mother()).filter(FamilyTreeNode::isValid);
    }

    public Set<UUID> siblings() {
        HashSet<UUID> siblings = new HashSet<UUID>();
        this.streamParents().forEach(parent -> this.getRoot().getOrEmpty((UUID)parent).ifPresent(p -> FamilyTreeNode.gatherChildren(p, siblings, 1)));
        return siblings;
    }

    public Stream<UUID> getChildren() {
        return this.getRelatives(0, 1);
    }

    public Stream<UUID> getAllRelatives(int depth) {
        HashSet family = new HashSet();
        HashSet<UUID> todo = new HashSet<UUID>();
        todo.add(this.id);
        for (int d = 0; d < depth; ++d) {
            HashSet nextTodo = new HashSet();
            for (UUID uuid : todo) {
                if (family.contains(uuid)) continue;
                this.rootNode.getOrEmpty(uuid).ifPresent(node -> {
                    family.add(uuid);
                    node.streamParents().forEach(nextTodo::add);
                    node.streamChildren().forEach(nextTodo::add);
                });
            }
            todo = nextTodo;
        }
        family.remove(this.id);
        return family.stream();
    }

    public Stream<UUID> getRelatives(int parentDepth, int childrenDepth) {
        HashSet<UUID> family = new HashSet<UUID>();
        FamilyTreeNode.gatherParents(this, family, parentDepth);
        FamilyTreeNode.gatherChildren(this, family, childrenDepth);
        family.remove(this.id);
        return family.stream();
    }

    public boolean isRelative(UUID with) {
        return this.getAllRelatives(9).anyMatch(with::equals);
    }

    public Stream<FamilyTreeNode> getParents() {
        return this.lookup(this.streamParents());
    }

    public Stream<FamilyTreeNode> getSiblings() {
        return this.lookup(this.siblings().stream());
    }

    public Stream<FamilyTreeNode> lookup(Stream<UUID> uuids) {
        return uuids.map(this.getRoot()::getOrEmpty).filter(Optional::isPresent).map(Optional::get);
    }

    public boolean isParent(UUID id) {
        return this.streamParents().anyMatch(parent -> parent.equals(id));
    }

    public boolean isGrandParent(UUID id) {
        return this.getParents().anyMatch(parent -> parent.isParent(id));
    }

    public boolean isUncle(UUID id) {
        return this.getParents().flatMap(parent -> parent.siblings().stream()).distinct().anyMatch(id::equals);
    }

    public void addChild(UUID child) {
        this.children.add(child);
    }

    public FamilyTree getRoot() {
        return this.rootNode;
    }

    public boolean assignParents(EntityRelationship one, EntityRelationship two) {
        return this.assignParent(one.getFamilyEntry()) | this.assignParent(two.getFamilyEntry());
    }

    public boolean assignParent(FamilyTreeNode parent) {
        int parents = (FamilyTreeNode.isValid(this.father) ? 1 : 0) + (FamilyTreeNode.isValid(this.mother) ? 1 : 0);
        if (parents == 1) {
            if (!FamilyTreeNode.isValid(this.father)) {
                return this.setFather(parent);
            }
            if (!FamilyTreeNode.isValid(this.mother)) {
                return this.setMother(parent);
            }
        } else {
            if (parent.gender() == Gender.MALE) {
                return this.setFather(parent);
            }
            return this.setMother(parent);
        }
        return true;
    }

    public boolean setFather(FamilyTreeNode parent) {
        this.father = parent.id();
        parent.children().add(this.id);
        this.markDirty();
        return true;
    }

    public boolean setMother(FamilyTreeNode parent) {
        this.mother = parent.id();
        parent.children().add(this.id);
        this.markDirty();
        return true;
    }

    public boolean removeFather() {
        if (FamilyTreeNode.isValid(this.father)) {
            this.rootNode.getOrEmpty(this.father).ifPresent(e -> e.children.remove(this.id));
            this.father = Util.NIL_UUID;
            this.markDirty();
            return true;
        }
        return false;
    }

    public boolean removeMother() {
        if (FamilyTreeNode.isValid(this.mother)) {
            this.rootNode.getOrEmpty(this.mother).ifPresent(e -> e.children.remove(this.id));
            this.mother = Util.NIL_UUID;
            this.markDirty();
            return true;
        }
        return false;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
        this.markDirty();
    }

    public boolean probablyGenerated() {
        return this.mother.equals(Util.NIL_UUID) && this.father.equals(Util.NIL_UUID) && this.children.size() == 1 && this.deceased && !this.isPlayer();
    }

    public boolean willBeRemembered() {
        if (!this.children.isEmpty()) {
            return true;
        }
        if (!this.partner.equals(Util.NIL_UUID)) {
            return true;
        }
        return !this.getParents().allMatch(FamilyTreeNode::probablyGenerated);
    }

    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("name", this.name);
        nbt.putUUID("id", this.id);
        nbt.putBoolean("isPlayer", this.isPlayer);
        nbt.putBoolean("isDeceased", this.deceased);
        nbt.putInt("gender", this.gender.getId());
        nbt.putUUID("father", this.father);
        nbt.putUUID("mother", this.mother);
        nbt.putUUID("spouse", this.partner);
        nbt.putInt("marriageState", this.relationshipState.ordinal());
        nbt.put("children", (Tag)NbtHelper.fromList(this.children, child -> {
            CompoundTag n = new CompoundTag();
            n.putUUID("uuid", child);
            return n;
        }));
        return nbt;
    }
}

