/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.server.world.data;

import java.util.HashMap;
import java.util.Map;
import net.conczin.mca.util.NbtHelper;
import net.conczin.mca.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.saveddata.SavedData;

public class Nationality
extends SavedData {
    private static final int CHUNK_SIZE = 128;
    private static final int[][] neighbours = new int[][]{{0, 0}, {-1, 0}, {1, 0}, {0, -1}, {0, 1}, {-1, 1}, {1, 1}, {-1, -1}, {-1, 1}};
    final RandomSource random = RandomSource.create();
    private Map<Long, Integer> map = new HashMap<Long, Integer>();

    Nationality(ServerLevel level) {
    }

    Nationality(CompoundTag nbt, HolderLookup.Provider provider) {
        this.map = NbtHelper.toMap(nbt, Long::valueOf, e -> ((IntTag)e).getAsInt());
    }

    public static Nationality get(ServerLevel world) {
        return WorldUtils.loadData(world.getServer().overworld(), Nationality::new, Nationality::new, "mca_nationality");
    }

    private static long toId(long x, long z) {
        return x / 128L * Integer.MAX_VALUE + z / 128L;
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider provider) {
        NbtHelper.fromMap(nbt, this.map, String::valueOf, IntTag::valueOf);
        return nbt;
    }

    public int getRegionId(BlockPos pos) {
        long rid;
        int id = -1;
        for (int[] neighbour : neighbours) {
            int z;
            int x = pos.getX() + neighbour[0] * 128;
            long rid2 = Nationality.toId(x, z = pos.getZ() + neighbour[1] * 128);
            if (!this.map.containsKey(rid2)) continue;
            id = this.map.get(rid2);
            break;
        }
        if (id == -1) {
            id = this.random.nextInt();
        }
        if (!this.map.containsKey(rid = Nationality.toId(pos.getX(), pos.getZ()))) {
            this.map.put(rid, id);
            this.setDirty();
        }
        return id;
    }
}

