/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.server.world.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.conczin.mca.Config;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.Memories;
import net.conczin.mca.resources.API;
import net.conczin.mca.resources.BuildingTypes;
import net.conczin.mca.server.world.data.Building;
import net.conczin.mca.server.world.data.CivilRegistryManager;
import net.conczin.mca.server.world.data.PlayerSaveData;
import net.conczin.mca.server.world.data.VillageManager;
import net.conczin.mca.server.world.data.villageComponents.VillageGuardsManager;
import net.conczin.mca.server.world.data.villageComponents.VillageInnManager;
import net.conczin.mca.server.world.data.villageComponents.VillageMarriageManager;
import net.conczin.mca.server.world.data.villageComponents.VillageProcreationManager;
import net.conczin.mca.server.world.data.villageComponents.VillageTaxesManager;
import net.conczin.mca.util.BlockBoxExtended;
import net.conczin.mca.util.NbtHelper;
import net.conczin.mca.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class Village
implements Iterable<Building> {
    public static final int PLAYER_BORDER_MARGIN = 32;
    public static final int BORDER_MARGIN = 48;
    public static final int MERGE_MARGIN = 64;
    private static final int MOVE_IN_COOLDOWN = 1200;
    private static final long BED_SYNC_TIME = 200L;
    public final List<ItemStack> storageBuffer = new LinkedList<ItemStack>();
    private final ServerLevel world;
    private final Map<Integer, Building> buildings = new HashMap<Integer, Building>();
    private final int id;
    private final VillageGuardsManager villageGuardsManager = new VillageGuardsManager(this);
    private final VillageInnManager villageInnManager = new VillageInnManager(this);
    private final VillageMarriageManager villageMarriageManager = new VillageMarriageManager(this);
    private final VillageProcreationManager villageProcreationManager = new VillageProcreationManager(this);
    private final VillageTaxesManager villageTaxesManager = new VillageTaxesManager(this);
    public long lastMoveIn;
    private String name = API.getVillagePool().pickVillageName("village");
    private Map<UUID, Map<UUID, Integer>> reputation = new HashMap<UUID, Map<UUID, Integer>>();
    private int beds;
    private long lastBedSync;
    private Map<UUID, String> residentNames = new HashMap<UUID, String>();
    private Map<UUID, Long> residentHomes = new HashMap<UUID, Long>();
    private float taxes = 0.0f;
    private float populationThreshold = 0.75f;
    private float marriageThreshold = 0.5f;
    private boolean autoScan;
    private BlockBoxExtended box;

    public Village(int id, ServerLevel world) {
        this.autoScan = Config.getInstance().enableAutoScanByDefault;
        this.box = new BlockBoxExtended(0, 0, 0, 0, 0, 0);
        this.id = id;
        this.world = world;
    }

    public Village(CompoundTag v, ServerLevel world) {
        this.autoScan = Config.getInstance().enableAutoScanByDefault;
        this.box = new BlockBoxExtended(0, 0, 0, 0, 0, 0);
        this.id = v.getInt("id");
        this.name = v.getString("name");
        this.taxes = v.getFloat("taxesFloat");
        this.beds = v.getInt("beds");
        this.reputation = NbtHelper.toMap(v.getCompound("reputation"), UUID::fromString, i -> NbtHelper.toMap((CompoundTag)i, UUID::fromString, i2 -> ((IntTag)i2).getAsInt()));
        this.residentNames = NbtHelper.toMap(v.getCompound("residentNames"), UUID::fromString, Tag::getAsString);
        this.residentHomes = NbtHelper.toMap(v.getCompound("residentHomes"), UUID::fromString, i -> ((LongTag)i).getAsLong());
        if (v.contains("populationThresholdFloat")) {
            this.populationThreshold = v.getFloat("populationThresholdFloat");
        }
        if (v.contains("marriageThresholdFloat")) {
            this.marriageThreshold = v.getFloat("marriageThresholdFloat");
        }
        this.world = world;
        this.autoScan = v.contains("autoScan") ? v.getBoolean("autoScan") : true;
        ListTag b = v.getList("buildings", 10);
        for (int i2 = 0; i2 < b.size(); ++i2) {
            Building building = new Building(b.getCompound(i2));
            if (world != null && !BuildingTypes.getInstance().getBuildingTypes().containsKey(building.getType())) continue;
            this.buildings.put(building.getId(), building);
        }
        if (!this.buildings.isEmpty()) {
            this.calculateDimensions();
        }
    }

    public static Optional<Village> findNearest(Entity entity) {
        return VillageManager.get((ServerLevel)entity.level()).findNearestVillage(entity);
    }

    public boolean isWithinBorder(Entity entity) {
        return this.isWithinBorder(entity.blockPosition(), entity instanceof Player ? 32 : 48);
    }

    public boolean isWithinBorder(BlockPos pos, int margin) {
        return this.box.inflatedBy(margin).isInside((Vec3i)pos);
    }

    @Override
    public Iterator<Building> iterator() {
        return this.buildings.values().iterator();
    }

    public void removeBuilding(int id) {
        this.buildings.remove(id);
        if (!this.buildings.isEmpty()) {
            this.calculateDimensions();
        }
        this.markDirty();
    }

    public Stream<Building> getBuildingsOfType(String type) {
        return this.getBuildings().values().stream().filter(b -> b.getType().equals(type));
    }

    public Optional<Building> getBuildingAt(Vec3i pos) {
        return this.getBuildings().values().stream().filter(b -> b.containsPos(pos)).findAny();
    }

    public void calculateDimensions() {
        int sx = Integer.MAX_VALUE;
        int sy = Integer.MAX_VALUE;
        int sz = Integer.MAX_VALUE;
        int ex = Integer.MIN_VALUE;
        int ey = Integer.MIN_VALUE;
        int ez = Integer.MIN_VALUE;
        for (Building building : this.buildings.values()) {
            ex = Math.max(building.getPos1().getX(), ex);
            sx = Math.min(building.getPos0().getX(), sx);
            ey = Math.max(building.getPos1().getY(), ey);
            sy = Math.min(building.getPos0().getY(), sy);
            ez = Math.max(building.getPos1().getZ(), ez);
            sz = Math.min(building.getPos0().getZ(), sz);
        }
        this.box = new BlockBoxExtended(sx, sy, sz, ex, ey, ez);
    }

    public Vec3i getCenter() {
        return this.box.getCenter();
    }

    public BlockBoxExtended getBox() {
        return this.box;
    }

    public List<String> getResidents(int building) {
        return this.getBuilding(building).map(value -> this.residentHomes.entrySet().stream().filter(e -> value.containsPos((Vec3i)BlockPos.of((long)((Long)e.getValue())))).map(k -> this.residentNames.getOrDefault(k.getKey(), "Unknown")).collect(Collectors.toList())).orElseGet(List::of);
    }

    public float getTaxes() {
        return this.taxes;
    }

    public void setTaxes(float taxes) {
        this.taxes = taxes;
    }

    public float getPopulationThreshold() {
        return this.populationThreshold;
    }

    public void setPopulationThreshold(float populationThreshold) {
        this.populationThreshold = populationThreshold;
    }

    public float getMarriageThreshold() {
        return this.marriageThreshold;
    }

    public void setMarriageThreshold(float marriageThreshold) {
        this.marriageThreshold = marriageThreshold;
    }

    public boolean isAutoScan() {
        return this.autoScan;
    }

    public void setAutoScan(boolean autoScan) {
        this.autoScan = autoScan;
    }

    public void toggleAutoScan() {
        this.setAutoScan(!this.isAutoScan());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<Integer, Building> getBuildings() {
        return this.buildings;
    }

    public Optional<Building> getBuilding(int id) {
        return Optional.ofNullable(this.buildings.get(id));
    }

    public int getId() {
        return this.id;
    }

    public boolean hasSpace() {
        return this.getPopulation() < this.getMaxPopulation();
    }

    public int getPopulation() {
        return this.residentNames.size();
    }

    public Stream<UUID> getResidentsUUIDs() {
        return this.residentNames.keySet().stream();
    }

    public boolean isPositionValidBed(BlockPos pos) {
        return this.getBuildingAt((Vec3i)pos).filter(b -> b.getBuildingType().noBeds()).isEmpty();
    }

    public List<VillagerEntityMCA> getResidents(ServerLevel world) {
        return this.getResidentsUUIDs().map(arg_0 -> ((ServerLevel)world).getEntity(arg_0)).filter(VillagerEntityMCA.class::isInstance).map(VillagerEntityMCA.class::cast).collect(Collectors.toList());
    }

    public void updateMaxPopulation() {
        if (this.world != null) {
            Vec3i dimensions = this.box.getLength();
            int radius = (int)Math.sqrt(dimensions.getX() * dimensions.getX() + dimensions.getY() * dimensions.getY() + dimensions.getZ() * dimensions.getZ());
            this.beds = (int)this.world.getPoiManager().findAll(registryEntry -> registryEntry.is(PoiTypes.HOME), this::isPositionValidBed, new BlockPos(this.getCenter()), radius + 48, PoiManager.Occupancy.ANY).count();
        }
    }

    public int getMaxPopulation() {
        if (this.world != null && this.world.getGameTime() - this.lastBedSync > 200L) {
            this.lastBedSync = this.world.getGameTime();
            this.updateMaxPopulation();
        }
        return this.beds;
    }

    public boolean hasStoredResource() {
        return !this.storageBuffer.isEmpty();
    }

    public boolean hasBuilding(String building) {
        return this.buildings.values().stream().anyMatch(b -> b.getType().equals(building) && b.isComplete());
    }

    public void tick(ServerLevel world, long time) {
        boolean isVillageUpdateTime;
        boolean isTaxSeason = (time += (long)this.getId()) % (long)Config.getInstance().taxSeason == 0L;
        boolean bl = isVillageUpdateTime = time % 1200L == 0L;
        if (isTaxSeason && this.hasBuilding("storage")) {
            this.villageTaxesManager.taxes(world);
        }
        if (time % 24000L == 0L) {
            this.cleanReputation();
        }
        if (isVillageUpdateTime && this.lastMoveIn + 1200L < time && WorldUtils.isChunkLoaded(world, this.getCenter())) {
            this.villageGuardsManager.spawnGuards(world);
            this.villageInnManager.updateInn(world);
            this.villageMarriageManager.marry(world);
            this.villageProcreationManager.procreate(world);
        }
    }

    public void onEnter(ServerLevel world) {
        this.villageTaxesManager.deliverTaxes(world);
    }

    public void broadCastMessage(ServerLevel world, String event, VillagerEntityMCA suitor, VillagerEntityMCA mate) {
        world.players().stream().filter(p -> PlayerSaveData.get(p).getLastSeenVillageId().orElse(-2).intValue() == this.getId() || suitor.getVillagerBrain().getMemoriesForPlayer((Player)p).getHearts() > Config.getInstance().heartsToBeConsideredAsFriend || mate.getVillagerBrain().getMemoriesForPlayer((Player)p).getHearts() > Config.getInstance().heartsToBeConsideredAsFriend).forEach(player -> player.displayClientMessage((Component)Component.translatable((String)event, (Object[])new Object[]{suitor.getName(), mate.getName()}), !Config.getInstance().showNotificationsAsChat));
    }

    public void broadCastMessage(ServerLevel world, String event, String targetName) {
        world.players().stream().filter(p -> PlayerSaveData.get(p).getLastSeenVillageId().orElse(-2).intValue() == this.getId()).forEach(player -> player.displayClientMessage((Component)Component.translatable((String)event, (Object[])new Object[]{targetName}), !Config.getInstance().showNotificationsAsChat));
    }

    public void markDirty() {
        VillageManager.get(this.world).setDirty();
    }

    public void cleanReputation() {
        Set residents = this.getResidentsUUIDs().collect(Collectors.toSet());
        for (Map<UUID, Integer> map : this.reputation.values()) {
            Set toRemove = map.keySet().stream().filter(v -> !residents.contains(v)).collect(Collectors.toSet());
            for (UUID uuid : toRemove) {
                map.remove(uuid);
            }
        }
    }

    public void setReputation(Player player, VillagerEntityMCA villager, int rep) {
        this.reputation.computeIfAbsent(player.getUUID(), i -> new HashMap()).put(villager.getUUID(), rep);
        this.markDirty();
    }

    public int getReputation(Player player) {
        return this.reputation.getOrDefault(player.getUUID(), Collections.emptyMap()).values().stream().mapToInt(i -> i).sum();
    }

    public void pushHearts(Player player, int h) {
        ArrayList<Memories> loadedMemories = new ArrayList<Memories>();
        for (UUID uuid : this.residentNames.keySet()) {
            Entity entity = this.world.getEntity(uuid);
            if (!(entity instanceof VillagerEntityMCA)) continue;
            VillagerEntityMCA villager = (VillagerEntityMCA)entity;
            loadedMemories.add(villager.getVillagerBrain().getMemoriesForPlayer(player));
        }
        if (loadedMemories.isEmpty()) {
            return;
        }
        int splitHearts = (int)Math.ceil((double)h / (double)loadedMemories.size());
        for (Memories memories : loadedMemories) {
            memories.modHearts(splitHearts);
        }
        this.markDirty();
    }

    public void pushMood(int m) {
        for (UUID uuid : this.residentNames.keySet()) {
            Entity entity = this.world.getEntity(uuid);
            if (!(entity instanceof VillagerEntityMCA)) continue;
            VillagerEntityMCA villager = (VillagerEntityMCA)entity;
            villager.getVillagerBrain().modifyMoodValue(m);
        }
        this.markDirty();
    }

    public CompoundTag save() {
        CompoundTag v = new CompoundTag();
        v.putInt("id", this.id);
        v.putString("name", this.name);
        v.putFloat("taxesFloat", this.taxes);
        v.putInt("beds", this.beds);
        v.put("reputation", (Tag)NbtHelper.fromMap(new CompoundTag(), this.reputation, UUID::toString, i -> NbtHelper.fromMap(new CompoundTag(), i, UUID::toString, IntTag::valueOf)));
        v.put("residentNames", (Tag)NbtHelper.fromMap(new CompoundTag(), this.residentNames, Object::toString, StringTag::valueOf));
        v.put("residentHomes", (Tag)NbtHelper.fromMap(new CompoundTag(), this.residentHomes, Object::toString, LongTag::valueOf));
        v.putFloat("populationThresholdFloat", this.populationThreshold);
        v.putFloat("marriageThresholdFloat", this.marriageThreshold);
        v.put("buildings", (Tag)NbtHelper.fromList(this.buildings.values(), Building::save));
        v.putBoolean("autoScan", this.autoScan);
        return v;
    }

    public void merge(Village village) {
        this.buildings.putAll(village.buildings);
        this.calculateDimensions();
    }

    public boolean isVillage() {
        return this.getBuildings().size() >= Config.getInstance().minimumBuildingsToBeConsideredAVillage;
    }

    public void updateResident(VillagerEntityMCA e) {
        this.residentNames.put(e.getUUID(), e.getName().getString());
        Optional<GlobalPos> home = e.getResidency().getHome();
        if (home.isPresent()) {
            this.residentHomes.put(e.getUUID(), home.get().pos().asLong());
        } else {
            this.residentHomes.remove(e.getUUID());
        }
    }

    public Map<UUID, String> getResidentNames() {
        return this.residentNames;
    }

    public void removeResident(VillagerEntityMCA villager) {
        this.removeResident(villager.getUUID());
    }

    public void removeResident(UUID uuid) {
        this.residentNames.remove(uuid);
        this.residentHomes.remove(uuid);
        this.cleanReputation();
        this.markDirty();
    }

    public VillageGuardsManager getVillageGuardsManager() {
        return this.villageGuardsManager;
    }

    public Optional<CivilRegistryManager> getCivilRegistry() {
        return this.world != null ? Optional.of(CivilRegistryManager.get(this.world, this)) : Optional.empty();
    }
}

