/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.util;

import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.jetbrains.annotations.Nullable;

public interface InventoryUtils {
    public static Stream<ItemStack> stream(Container inventory) {
        return IntStream.range(0, inventory.getContainerSize()).mapToObj(arg_0 -> ((Container)inventory).getItem(arg_0));
    }

    public static int getFirstSlotContainingItem(Container inv, Predicate<ItemStack> predicate) {
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (!predicate.test(stack)) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(Container inv, Class<?> clazz) {
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            Item item = stack.getItem();
            if (item.getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getBestItemOfType(Container inv, @Nullable Class<?> type) {
        return type == null ? ItemStack.EMPTY : inv.getItem(InventoryUtils.getBestItemOfTypeSlot(inv, type));
    }

    public static int getBestItemOfTypeSlot(Container inv, Class<?> type) {
        int highestMaxDamage = 0;
        int best = -1;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stackInInventory = inv.getItem(i);
            String itemClassName = stackInInventory.getItem().getClass().getName();
            if (!itemClassName.equals(type.getName()) || highestMaxDamage >= stackInInventory.getMaxDamage()) continue;
            highestMaxDamage = stackInInventory.getMaxDamage();
            best = i;
        }
        return best;
    }

    public static Optional<ItemStack> getBestArmor(Container inv, EquipmentSlot slot) {
        return InventoryUtils.stream(inv).filter(s -> s.getItem() instanceof ArmorItem).filter(s -> ((ArmorItem)s.getItem()).getEquipmentSlot() == slot).max(Comparator.comparingDouble(s -> ((ArmorItem)s.getItem()).getDefense()));
    }

    public static Optional<ItemStack> getBestSword(Container inv) {
        return InventoryUtils.stream(inv).filter(s -> s.getItem() instanceof SwordItem).max(Comparator.comparingDouble(ItemStack::getMaxDamage));
    }

    public static Optional<ItemStack> getBestRanged(Container inv) {
        return InventoryUtils.stream(inv).filter(s -> s.getItem() instanceof ProjectileWeaponItem).max(Comparator.comparingDouble(ItemStack::getMaxDamage));
    }

    public static void dropAllItems(Entity entity, Container inv) {
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            entity.spawnAtLocation(stack, 1.0f);
        }
        inv.clearContent();
    }

    public static void saveToNBT(RegistryAccess registryAccess, SimpleContainer inv, CompoundTag nbt) {
        nbt.put("Inventory", (Tag)inv.createTag((HolderLookup.Provider)registryAccess));
    }

    public static void readFromNBT(RegistryAccess registryAccess, SimpleContainer inv, CompoundTag nbt) {
        inv.fromTag(nbt.getList("Inventory", 10), (HolderLookup.Provider)registryAccess);
    }

    public static double approximateDamage(ItemStack stack, LivingEntity entity) {
        double base = entity.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
        ItemAttributeModifiers comp = (ItemAttributeModifiers)stack.get(DataComponents.ATTRIBUTE_MODIFIERS);
        return comp == null ? base : comp.compute(base, EquipmentSlot.MAINHAND);
    }
}

