/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.conczin.mca.MCA;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import org.apache.logging.log4j.Logger;

public interface NbtHelper {
    public static <T extends Tag> T computeIfAbsent(CompoundTag nbt, String key, int type, Supplier<T> factory) {
        if (!nbt.contains(key, type)) {
            nbt.put(key, (Tag)factory.get());
        }
        return (T)nbt.get(key);
    }

    public static CompoundTag copyTo(CompoundTag from, CompoundTag to) {
        from.getAllKeys().forEach(key -> to.put(key, from.get(key)));
        return to;
    }

    public static <V> List<V> toList(Tag nbt, Function<Tag, V> valueMapper) {
        return NbtHelper.toStream(nbt, valueMapper).collect(Collectors.toList());
    }

    public static <V> Stream<V> toStream(Tag nbt, Function<Tag, V> valueMapper) {
        return ((ListTag)nbt).stream().map(valueMapper);
    }

    public static <K, V> Map<K, V> toMap(CompoundTag nbt, Function<String, K> keyMapper, Function<Tag, V> valueMapper) {
        return NbtHelper.toMap(nbt, keyMapper, (K k, Tag e) -> valueMapper.apply((Tag)e));
    }

    public static <K, V> Map<K, V> toMap(CompoundTag nbt, Function<String, K> keyMapper, BiFunction<K, Tag, V> valueMapper) {
        return nbt.getAllKeys().stream().map(e -> {
            Object k = keyMapper.apply((String)e);
            if (k == null) {
                return null;
            }
            Object v = valueMapper.apply(k, nbt.get(e));
            if (v == null) {
                return null;
            }
            return k == null ? null : new Pair(k, v);
        }).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    public static <V> ListTag fromList(Iterable<V> list, Function<V, Tag> valueMapper) {
        ListTag output = new ListTag();
        list.forEach(item -> output.add((Object)((Tag)valueMapper.apply(item))));
        return output;
    }

    public static <K, V> CompoundTag fromMap(CompoundTag output, Map<K, V> map, Function<K, String> keyMapper, Function<V, Tag> valueMapper) {
        map.forEach((key, value) -> output.put((String)keyMapper.apply(key), (Tag)valueMapper.apply(value)));
        return output;
    }

    public static Tag encodeGlobalPosition(GlobalPos v) {
        return (Tag)GlobalPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)v).resultOrPartial(arg_0 -> ((Logger)MCA.LOGGER).error(arg_0)).orElseThrow();
    }

    public static GlobalPos decodeGlobalPos(Tag element) {
        return GlobalPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)element).resultOrPartial(arg_0 -> ((Logger)MCA.LOGGER).error(arg_0)).orElse(null);
    }
}

