/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.client.models.entity.arapaima;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.voidarkana.fintastic.client.animation.ArapaimaAnims;
import net.voidarkana.fintastic.client.models.entity.base.FintasticModel;
import net.voidarkana.fintastic.common.entity.custom.ArapaimaEntity;

public class ArapaimaModel<T extends ArapaimaEntity>
extends FintasticModel<T> {
    private final ModelPart root;
    private final ModelPart swim_rot;
    private final ModelPart body;
    private final ModelPart torso;
    private final ModelPart head;
    private final ModelPart mouth;
    private final ModelPart rightfin;
    private final ModelPart leftfin;
    private final ModelPart leftpelvicfin;
    private final ModelPart rightpelvicfin;
    private final ModelPart torsoend;
    private final ModelPart tailfin;
    private final ModelPart analfin;
    private final ModelPart dorsalfin;

    public ArapaimaModel(ModelPart root) {
        super(1.0f, 1.0f);
        this.root = root.m_171324_("root");
        this.swim_rot = this.root.m_171324_("swim_rot");
        this.body = this.swim_rot.m_171324_("body");
        this.torso = this.body.m_171324_("torso");
        this.head = this.torso.m_171324_("head");
        this.mouth = this.head.m_171324_("mouth");
        this.rightfin = this.torso.m_171324_("rightfin");
        this.leftfin = this.torso.m_171324_("leftfin");
        this.leftpelvicfin = this.torso.m_171324_("leftpelvicfin");
        this.rightpelvicfin = this.torso.m_171324_("rightpelvicfin");
        this.torsoend = this.body.m_171324_("torsoend");
        this.tailfin = this.torsoend.m_171324_("tailfin");
        this.analfin = this.torsoend.m_171324_("analfin");
        this.dorsalfin = this.torsoend.m_171324_("dorsalfin");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition swim_rot = root.m_171599_("swim_rot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5f, (float)-9.0f, (float)-25.0f));
        PartDefinition body = swim_rot.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition torso = body.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.5f, -6.0f, -31.0f, 9.0f, 12.0f, 31.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)-1.0f, (float)28.0f));
        PartDefinition head = torso.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(74, 83).m_171488_(-3.5f, -2.75f, -9.0f, 7.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.75f, (float)-30.0f));
        PartDefinition mouth = head.m_171599_("mouth", CubeListBuilder.m_171558_().m_171514_(42, 95).m_171488_(-3.0f, -4.0f, -0.5f, 6.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.25f, (float)-9.5f));
        PartDefinition rightfin = torso.m_171599_("rightfin", CubeListBuilder.m_171558_().m_171514_(0, 41).m_171488_(0.0f, 0.0f, -0.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-4.5f, (float)6.0f, (float)-25.5f, (float)0.0f, (float)0.0f, (float)1.1345f));
        PartDefinition leftfin = torso.m_171599_("leftfin", CubeListBuilder.m_171558_().m_171514_(0, 41).m_171480_().m_171488_(0.0f, 0.0f, -0.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.01f)).m_171555_(false), PartPose.m_171423_((float)4.5f, (float)6.0f, (float)-25.5f, (float)0.0f, (float)0.0f, (float)-1.1345f));
        PartDefinition leftpelvicfin = torso.m_171599_("leftpelvicfin", CubeListBuilder.m_171558_().m_171514_(42, 84).m_171488_(0.0f, -0.5f, -1.5f, 0.0f, 5.0f, 5.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)4.8f, (float)6.1f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)-1.1345f));
        PartDefinition rightpelvicfin = torso.m_171599_("rightpelvicfin", CubeListBuilder.m_171558_().m_171514_(42, 84).m_171488_(0.0f, -0.5f, -1.5f, 0.0f, 5.0f, 5.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-4.7f, (float)6.1f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)1.1345f));
        PartDefinition torsoend = body.m_171599_("torsoend", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171488_(-3.5f, -6.0f, 0.0f, 7.0f, 12.0f, 30.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)-1.0f, (float)28.0f));
        PartDefinition tailfin = torsoend.m_171599_("tailfin", CubeListBuilder.m_171558_().m_171514_(0, 85).m_171488_(-0.5f, -4.0f, 0.0f, 0.0f, 8.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.5f, (float)0.0f, (float)30.0f));
        PartDefinition analfin = torsoend.m_171599_("analfin", CubeListBuilder.m_171558_().m_171514_(46, 14).m_171488_(0.0f, -3.0f, -15.5f, 0.0f, 8.0f, 31.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)17.5f));
        PartDefinition dorsalfin = torsoend.m_171599_("dorsalfin", CubeListBuilder.m_171558_().m_171514_(46, 29).m_171488_(0.0f, -4.5f, -16.5f, 0.0f, 7.0f, 33.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)-6.5f, (float)16.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(ArapaimaEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.animateIdle(pEntity.idleAnimationState, ArapaimaAnims.IDLE_SWIM, pAgeInTicks, 1.0f, Math.max(0.0f, 1.0f - (float)pEntity.getTicksOutsideWater() / 3.0f - Math.abs(pLimbSwingAmount)));
        this.animateIdle(pEntity.idleAnimationState, ArapaimaAnims.GROUND_IDLE, pAgeInTicks, 1.0f, (float)pEntity.getTicksOutsideWater() / 3.0f - Math.abs(pLimbSwingAmount));
        if (pEntity.m_20072_()) {
            this.head.f_104203_ = headPitch * ((float)Math.PI / 180) / 8.0f;
            this.body.f_104203_ = headPitch * ((float)Math.PI / 180) / 8.0f;
            this.torsoend.f_104203_ = -(headPitch * ((float)Math.PI / 180) / 4.0f);
            this.head.f_104204_ = pEntity.currentRoll;
            this.body.f_104204_ = pEntity.currentRoll / 2.0f;
            this.torsoend.f_104204_ = -pEntity.currentRoll;
            this.swim_rot.f_104203_ = headPitch * ((float)Math.PI / 180) / 2.0f;
            this.swim_rot.f_104205_ = netHeadYaw * ((float)Math.PI / 360);
            this.m_267799_(ArapaimaAnims.SWIM, pLimbSwing, pLimbSwingAmount * 5.0f, 2.0f, 3.0f);
        } else {
            this.swim_rot.m_233569_();
            this.head.m_233569_();
            this.torsoend.m_233569_();
            this.body.m_233569_();
            this.m_267799_(ArapaimaAnims.CRAWL, pLimbSwing, pLimbSwingAmount * 5.0f, 2.0f, 3.0f);
        }
    }

    @Override
    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

