/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.fintastic.client.models.entity.arapaima;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.voidarkana.fintastic.client.animation.BabyArapaimaAnims;
import net.voidarkana.fintastic.client.models.entity.base.FintasticModel;
import net.voidarkana.fintastic.common.entity.custom.ArapaimaEntity;

public class BabyArapaimaModel<T extends ArapaimaEntity>
extends FintasticModel<T> {
    private final ModelPart root;
    private final ModelPart swim_rot;
    private final ModelPart body;
    private final ModelPart torso;
    private final ModelPart dorsalfin;
    private final ModelPart analfin;
    private final ModelPart leftfin;
    private final ModelPart rightfin;
    private final ModelPart tailfin;
    private final ModelPart head;

    public BabyArapaimaModel(ModelPart root) {
        super(1.0f, 1.0f);
        this.root = root.m_171324_("root");
        this.swim_rot = this.root.m_171324_("swim_rot");
        this.body = this.swim_rot.m_171324_("body");
        this.torso = this.body.m_171324_("torso");
        this.dorsalfin = this.torso.m_171324_("dorsalfin");
        this.analfin = this.torso.m_171324_("analfin");
        this.leftfin = this.torso.m_171324_("leftfin");
        this.rightfin = this.torso.m_171324_("rightfin");
        this.tailfin = this.torso.m_171324_("tailfin");
        this.head = this.torso.m_171324_("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition swim_rot = root.m_171599_("swim_rot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-3.5f, (float)-5.5f));
        PartDefinition body = swim_rot.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition torso = body.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, -1.5f, -13.0f, 3.0f, 3.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)12.5f));
        PartDefinition dorsalfin = torso.m_171599_("dorsalfin", CubeListBuilder.m_171558_().m_171514_(3, 14).m_171488_(0.5f, -2.0f, -2.5f, 0.0f, 2.0f, 5.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)-0.5f, (float)-1.5f, (float)-2.5f));
        PartDefinition analfin = torso.m_171599_("analfin", CubeListBuilder.m_171558_().m_171514_(14, 14).m_171488_(0.0f, 0.0f, -3.0f, 0.0f, 2.0f, 5.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)1.5f, (float)-2.0f));
        PartDefinition leftfin = torso.m_171599_("leftfin", CubeListBuilder.m_171558_().m_171514_(12, 23).m_171488_(0.0f, 0.0f, -0.5f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)1.5f, (float)1.5f, (float)-11.5f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition rightfin = torso.m_171599_("rightfin", CubeListBuilder.m_171558_().m_171514_(12, 23).m_171488_(0.0f, 0.0f, -0.5f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-1.5f, (float)1.5f, (float)-11.5f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition tailfin = torso.m_171599_("tailfin", CubeListBuilder.m_171558_().m_171514_(17, 23).m_171488_(0.0f, -2.5f, 0.0f, 0.0f, 5.0f, 4.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = torso.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(2, 24).m_171488_(-1.0f, -1.0f, -3.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)-13.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(ArapaimaEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.animateIdle(pEntity.idleAnimationState, BabyArapaimaAnims.IDLE, pAgeInTicks, 1.0f, Math.max(0.0f, 1.0f - (float)pEntity.getTicksOutsideWater() / 3.0f - Math.abs(pLimbSwingAmount)));
        this.animateIdle(pEntity.idleAnimationState, BabyArapaimaAnims.CRAWL_IDLE, pAgeInTicks, 1.0f, (float)pEntity.getTicksOutsideWater() / 3.0f - Math.abs(pLimbSwingAmount));
        if (pEntity.m_20072_()) {
            this.swim_rot.f_104203_ = headPitch * ((float)Math.PI / 180);
            this.swim_rot.f_104205_ = netHeadYaw * ((float)Math.PI / 360);
            this.m_267799_(BabyArapaimaAnims.SWIM, pLimbSwing / 2.0f, pLimbSwingAmount / 2.0f, 2.0f, 3.0f);
        } else {
            this.swim_rot.m_233569_();
            this.m_267799_(BabyArapaimaAnims.CRAWL_WALK, pLimbSwing / 2.0f, pLimbSwingAmount / 2.0f, 2.0f, 3.0f);
        }
    }

    @Override
    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

